/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import com.sun.source.doctree.DocTree;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.builders.MemberSummaryBuilder;
import jdk.javadoc.internal.doclets.toolkit.util.CommentHelper;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class AnnotationTypeWriterImpl
extends SubWriterHolderWriter
implements AnnotationTypeWriter {
    protected TypeElement annotationType;
    protected TypeMirror prev;
    protected TypeMirror next;

    public AnnotationTypeWriterImpl(ConfigurationImpl configuration, TypeElement annotationType, TypeMirror prevType, TypeMirror nextType) throws Exception {
        super(configuration, DocPath.forClass(configuration.utils, annotationType));
        this.annotationType = annotationType;
        configuration.currentTypeElement = annotationType;
        this.prev = prevType;
        this.next = nextType;
    }

    @Override
    protected Content getNavLinkPackage() {
        Content linkContent = this.getHyperLink(DocPaths.PACKAGE_SUMMARY, this.packageLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    protected Content getNavLinkClass() {
        HtmlTree li = HtmlTree.LI(HtmlStyle.navBarCell1Rev, this.classLabel);
        return li;
    }

    @Override
    protected Content getNavLinkClassUse() {
        Content linkContent = this.getHyperLink(DocPaths.CLASS_USE.resolve(this.filename), this.useLabel);
        HtmlTree li = HtmlTree.LI(linkContent);
        return li;
    }

    @Override
    public Content getNavLinkPrevious() {
        HtmlTree li;
        if (this.prev != null) {
            Content prevLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.utils.asTypeElement(this.prev)).label(this.prevclassLabel).strong(true));
            li = HtmlTree.LI(prevLink);
        } else {
            li = HtmlTree.LI(this.prevclassLabel);
        }
        return li;
    }

    @Override
    public Content getNavLinkNext() {
        HtmlTree li;
        if (this.next != null) {
            Content nextLink = this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS, this.utils.asTypeElement(this.next)).label(this.nextclassLabel).strong(true));
            li = HtmlTree.LI(nextLink);
        } else {
            li = HtmlTree.LI(this.nextclassLabel);
        }
        return li;
    }

    @Override
    public Content getHeader(String header) {
        HtmlTree bodyTree = this.getBody(true, this.getWindowTitle(this.utils.getSimpleName(this.annotationType)));
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.HEADER) ? HtmlTree.HEADER() : bodyTree;
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        if (this.configuration.allowTag(HtmlTag.HEADER)) {
            bodyTree.addContent(htmlTree);
        }
        bodyTree.addContent(HtmlConstants.START_OF_CLASS_DATA);
        HtmlTree div = new HtmlTree(HtmlTag.DIV);
        div.addStyle(HtmlStyle.header);
        PackageElement pkg = this.utils.containingPackage(this.annotationType);
        if (!pkg.isUnnamed()) {
            StringContent pkgNameContent = new StringContent(this.utils.getPackageName(pkg));
            HtmlTree pkgNameDiv = HtmlTree.DIV(HtmlStyle.subTitle, pkgNameContent);
            div.addContent(pkgNameDiv);
        }
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_HEADER, this.annotationType);
        StringContent headerContent = new StringContent(header);
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.CLASS_PAGE_HEADING, true, HtmlStyle.title, headerContent);
        ((Content)heading).addContent(this.getTypeParameterLinks(linkInfo));
        div.addContent(heading);
        if (this.configuration.allowTag(HtmlTag.MAIN)) {
            this.mainTree.addContent(div);
        } else {
            bodyTree.addContent(div);
        }
        return bodyTree;
    }

    @Override
    public Content getAnnotationContentHeader() {
        return this.getContentHeader();
    }

    @Override
    public void addFooter(Content contentTree) {
        contentTree.addContent(HtmlConstants.END_OF_CLASS_DATA);
        Content htmlTree = this.configuration.allowTag(HtmlTag.FOOTER) ? HtmlTree.FOOTER() : contentTree;
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        if (this.configuration.allowTag(HtmlTag.FOOTER)) {
            contentTree.addContent(htmlTree);
        }
    }

    @Override
    public void printDocument(Content contentTree) throws IOException {
        this.printHtmlDocument(this.configuration.metakeywords.getMetaKeywords(this.annotationType), true, contentTree);
    }

    @Override
    public Content getAnnotationInfoTreeHeader() {
        return this.getMemberTreeHeader();
    }

    @Override
    public Content getAnnotationInfo(Content annotationInfoTree) {
        return this.getMemberTree(HtmlStyle.description, annotationInfoTree);
    }

    @Override
    public void addAnnotationTypeSignature(String modifiers, Content annotationInfoTree) {
        annotationInfoTree.addContent(new HtmlTree(HtmlTag.BR));
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.addAnnotationInfo(this.annotationType, (Content)pre);
        ((Content)pre).addContent(modifiers);
        LinkInfoImpl linkInfo = new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.CLASS_SIGNATURE, this.annotationType);
        StringContent annotationName = new StringContent(this.utils.getSimpleName(this.annotationType));
        Content parameterLinks = this.getTypeParameterLinks(linkInfo);
        if (this.configuration.linksource) {
            this.addSrcLink(this.annotationType, annotationName, pre);
            ((Content)pre).addContent(parameterLinks);
        } else {
            HtmlTree span = HtmlTree.SPAN(HtmlStyle.memberNameLabel, annotationName);
            ((Content)span).addContent(parameterLinks);
            ((Content)pre).addContent(span);
        }
        annotationInfoTree.addContent(pre);
    }

    @Override
    public void addAnnotationTypeDescription(Content annotationInfoTree) {
        if (!this.configuration.nocomment && !this.utils.getBody(this.annotationType).isEmpty()) {
            this.addInlineComment(this.annotationType, annotationInfoTree);
        }
    }

    @Override
    public void addAnnotationTypeTagInfo(Content annotationInfoTree) {
        if (!this.configuration.nocomment) {
            this.addTagsInfo(this.annotationType, annotationInfoTree);
        }
    }

    @Override
    public void addAnnotationTypeDeprecationInfo(Content annotationInfoTree) {
        HtmlTree hr = new HtmlTree(HtmlTag.HR);
        annotationInfoTree.addContent(hr);
        List<? extends DocTree> deprs = this.utils.getBlockTags((Element)this.annotationType, DocTree.Kind.DEPRECATED);
        if (this.utils.isDeprecated(this.annotationType)) {
            List<? extends DocTree> commentTags;
            CommentHelper ch = this.utils.getCommentHelper(this.annotationType);
            HtmlTree deprLabel = HtmlTree.SPAN(HtmlStyle.deprecatedLabel, this.deprecatedPhrase);
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprLabel);
            if (!deprs.isEmpty() && !(commentTags = ch.getDescription(this.configuration, deprs.get(0))).isEmpty()) {
                ((Content)div).addContent(this.getSpace());
                this.addInlineDeprecatedComment(this.annotationType, deprs.get(0), div);
            }
            annotationInfoTree.addContent(div);
        }
    }

    @Override
    protected Content getNavLinkTree() {
        Content treeLinkContent = this.getHyperLink(DocPaths.PACKAGE_TREE, this.treeLabel, "", "");
        HtmlTree li = HtmlTree.LI(treeLinkContent);
        return li;
    }

    @Override
    protected void addSummaryDetailLinks(Content subDiv) {
        try {
            HtmlTree div = HtmlTree.DIV(this.getNavSummaryLinks());
            ((Content)div).addContent(this.getNavDetailLinks());
            subDiv.addContent(div);
        }
        catch (Exception e) {
            throw new DocletAbortException(e);
        }
    }

    protected Content getNavSummaryLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.summaryLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        HtmlTree liNavField = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navField", VisibleMemberMap.Kind.ANNOTATION_TYPE_FIELDS, liNavField);
        this.addNavGap(liNavField);
        ((Content)ulNav).addContent(liNavField);
        HtmlTree liNavReq = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navAnnotationTypeRequiredMember", VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_REQUIRED, liNavReq);
        this.addNavGap(liNavReq);
        ((Content)ulNav).addContent(liNavReq);
        HtmlTree liNavOpt = new HtmlTree(HtmlTag.LI);
        this.addNavSummaryLink(memberSummaryBuilder, "doclet.navAnnotationTypeOptionalMember", VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_OPTIONAL, liNavOpt);
        ((Content)ulNav).addContent(liNavOpt);
        return ulNav;
    }

    protected void addNavSummaryLink(MemberSummaryBuilder builder, String label, VisibleMemberMap.Kind type, Content liNav) {
        AbstractMemberWriter writer = (AbstractMemberWriter)((Object)builder.getMemberSummaryWriter(type));
        if (writer == null) {
            liNav.addContent(this.getResource(label));
        } else {
            liNav.addContent(writer.getNavSummaryLink(null, !builder.getVisibleMemberMap(type).noVisibleMembers()));
        }
    }

    protected Content getNavDetailLinks() throws Exception {
        HtmlTree li = HtmlTree.LI(this.detailLabel);
        ((Content)li).addContent(this.getSpace());
        HtmlTree ulNav = HtmlTree.UL(HtmlStyle.subNavList, li);
        MemberSummaryBuilder memberSummaryBuilder = (MemberSummaryBuilder)this.configuration.getBuilderFactory().getMemberSummaryBuilder(this);
        AbstractMemberWriter writerField = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(VisibleMemberMap.Kind.ANNOTATION_TYPE_FIELDS));
        AbstractMemberWriter writerOptional = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_OPTIONAL));
        AbstractMemberWriter writerRequired = (AbstractMemberWriter)((Object)memberSummaryBuilder.getMemberSummaryWriter(VisibleMemberMap.Kind.ANNOTATION_TYPE_MEMBER_REQUIRED));
        HtmlTree liNavField = new HtmlTree(HtmlTag.LI);
        if (writerField != null) {
            writerField.addNavDetailLink(!this.utils.getAnnotationFields(this.annotationType).isEmpty(), (Content)liNavField);
        } else {
            ((Content)liNavField).addContent(this.getResource("doclet.navField"));
        }
        this.addNavGap(liNavField);
        ((Content)ulNav).addContent(liNavField);
        if (writerOptional != null) {
            HtmlTree liNavOpt = new HtmlTree(HtmlTag.LI);
            writerOptional.addNavDetailLink(!this.annotationType.getAnnotationMirrors().isEmpty(), (Content)liNavOpt);
            ((Content)ulNav).addContent(liNavOpt);
        } else if (writerRequired != null) {
            HtmlTree liNavReq = new HtmlTree(HtmlTag.LI);
            writerRequired.addNavDetailLink(!this.annotationType.getAnnotationMirrors().isEmpty(), (Content)liNavReq);
            ((Content)ulNav).addContent(liNavReq);
        } else {
            HtmlTree liNav = HtmlTree.LI(this.getResource("doclet.navAnnotationTypeMember"));
            ((Content)ulNav).addContent(liNav);
        }
        return ulNav;
    }

    protected void addNavGap(Content liNav) {
        liNav.addContent(this.getSpace());
        liNav.addContent("|");
        liNav.addContent(this.getSpace());
    }

    @Override
    public TypeElement getAnnotationTypeElement() {
        return this.annotationType;
    }
}

