/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.DerivedGenerator;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.PerCollectionSizeTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestSubjectGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapAsMapGetTester;
import com.google.common.collect.testing.google.MultimapAsMapTester;
import com.google.common.collect.testing.google.MultimapClearTester;
import com.google.common.collect.testing.google.MultimapContainsEntryTester;
import com.google.common.collect.testing.google.MultimapContainsKeyTester;
import com.google.common.collect.testing.google.MultimapContainsValueTester;
import com.google.common.collect.testing.google.MultimapEntriesTester;
import com.google.common.collect.testing.google.MultimapEqualsTester;
import com.google.common.collect.testing.google.MultimapFeature;
import com.google.common.collect.testing.google.MultimapGetTester;
import com.google.common.collect.testing.google.MultimapKeySetTester;
import com.google.common.collect.testing.google.MultimapKeysTester;
import com.google.common.collect.testing.google.MultimapPutAllMultimapTester;
import com.google.common.collect.testing.google.MultimapPutIterableTester;
import com.google.common.collect.testing.google.MultimapPutTester;
import com.google.common.collect.testing.google.MultimapRemoveAllTester;
import com.google.common.collect.testing.google.MultimapRemoveEntryTester;
import com.google.common.collect.testing.google.MultimapReplaceValuesTester;
import com.google.common.collect.testing.google.MultimapSizeTester;
import com.google.common.collect.testing.google.MultimapToStringTester;
import com.google.common.collect.testing.google.MultimapValuesTester;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultimapGenerator;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class MultimapTestSuiteBuilder<K, V, M extends Multimap<K, V>>
extends PerCollectionSizeTestSuiteBuilder<MultimapTestSuiteBuilder<K, V, M>, TestMultimapGenerator<K, V, M>, M, Map.Entry<K, V>> {
    private static final ImmutableMultimap<Feature<?>, Feature<?>> GET_FEATURE_MAP = ImmutableMultimap.builder().put((Object)MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, (Object)CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION).put((Object)MapFeature.GENERAL_PURPOSE, (Object)ListFeature.SUPPORTS_ADD_WITH_INDEX).put((Object)MapFeature.GENERAL_PURPOSE, (Object)ListFeature.SUPPORTS_REMOVE_WITH_INDEX).put((Object)MapFeature.GENERAL_PURPOSE, (Object)ListFeature.SUPPORTS_SET).put((Object)MapFeature.ALLOWS_NULL_VALUE_QUERIES, (Object)CollectionFeature.ALLOWS_NULL_QUERIES).put((Object)MapFeature.ALLOWS_NULL_VALUES, (Object)CollectionFeature.ALLOWS_NULL_VALUES).put((Object)MapFeature.SUPPORTS_REMOVE, (Object)CollectionFeature.SUPPORTS_REMOVE).put((Object)MapFeature.SUPPORTS_PUT, (Object)CollectionFeature.SUPPORTS_ADD).build();

    public static <K, V, M extends Multimap<K, V>> MultimapTestSuiteBuilder<K, V, M> using(TestMultimapGenerator<K, V, M> generator) {
        return (MultimapTestSuiteBuilder)new MultimapTestSuiteBuilder<K, V, M>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        return ImmutableList.of(MultimapAsMapGetTester.class, MultimapAsMapTester.class, MultimapSizeTester.class, MultimapClearTester.class, MultimapContainsKeyTester.class, MultimapContainsValueTester.class, MultimapContainsEntryTester.class, MultimapEntriesTester.class, MultimapEqualsTester.class, MultimapGetTester.class, MultimapKeySetTester.class, MultimapKeysTester.class, (Object[])new Class[]{MultimapPutTester.class, MultimapPutAllMultimapTester.class, MultimapPutIterableTester.class, MultimapReplaceValuesTester.class, MultimapRemoveEntryTester.class, MultimapRemoveAllTester.class, MultimapToStringTester.class, MultimapValuesTester.class});
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<M, Map.Entry<K, V>>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)MultimapTestSuiteBuilder.using(new ReserializedMultimapGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(MultimapTestSuiteBuilder.computeReserializedMultimapFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(" reserialized"))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        }
        derivedSuites.add(((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new AsMapGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(MultimapTestSuiteBuilder.computeAsMapFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(".asMap"))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite());
        derivedSuites.add(this.computeEntriesTestSuite(parentBuilder));
        derivedSuites.add(this.computeMultimapGetTestSuite(parentBuilder));
        derivedSuites.add(this.computeMultimapAsMapGetTestSuite(parentBuilder));
        derivedSuites.add(this.computeKeysTestSuite(parentBuilder));
        derivedSuites.add(this.computeValuesTestSuite(parentBuilder));
        return derivedSuites;
    }

    TestSuite computeValuesTestSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<M, Map.Entry<K, V>>> parentBuilder) {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new ValuesGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(MultimapTestSuiteBuilder.computeValuesFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(".values"))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite();
    }

    TestSuite computeEntriesTestSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<M, Map.Entry<K, V>>> parentBuilder) {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new EntriesGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(MultimapTestSuiteBuilder.computeEntriesFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(".entries"))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite();
    }

    TestSuite computeMultimapGetTestSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<M, Map.Entry<K, V>>> parentBuilder) {
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new MultimapGetGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(this.computeMultimapGetFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(".get[key]"))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite();
    }

    TestSuite computeMultimapAsMapGetTestSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<M, Map.Entry<K, V>>> parentBuilder) {
        Set<Feature<?>> features = this.computeMultimapAsMapGetFeatures(parentBuilder.getFeatures());
        if (Collections.disjoint(features, EnumSet.allOf(CollectionSize.class))) {
            return new TestSuite();
        }
        return ((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using(new MultimapAsMapGetGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(features)).named(String.valueOf(parentBuilder.getName()).concat(".asMap[].get[key]"))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite();
    }

    TestSuite computeKeysTestSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<M, Map.Entry<K, V>>> parentBuilder) {
        return ((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using(new KeysGenerator<K, V, M>(parentBuilder.getSubjectGenerator())).withFeatures(MultimapTestSuiteBuilder.computeKeysFeatures(parentBuilder.getFeatures()))).named(String.valueOf(parentBuilder.getName()).concat(".keys"))).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite();
    }

    static Set<Feature<?>> computeDerivedCollectionFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(multimapFeatures);
        if (!derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        }
        if (derivedFeatures.remove(MapFeature.SUPPORTS_REMOVE)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_REMOVE);
        }
        return derivedFeatures;
    }

    static Set<Feature<?>> computeEntriesFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> result = MultimapTestSuiteBuilder.computeDerivedCollectionFeatures(multimapFeatures);
        if (multimapFeatures.contains(MapFeature.ALLOWS_NULL_ENTRY_QUERIES)) {
            result.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        return result;
    }

    static Set<Feature<?>> computeValuesFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> result = MultimapTestSuiteBuilder.computeDerivedCollectionFeatures(multimapFeatures);
        if (multimapFeatures.contains(MapFeature.ALLOWS_NULL_VALUES)) {
            result.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        if (multimapFeatures.contains(MapFeature.ALLOWS_NULL_VALUE_QUERIES)) {
            result.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        return result;
    }

    static Set<Feature<?>> computeKeysFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> result = MultimapTestSuiteBuilder.computeDerivedCollectionFeatures(multimapFeatures);
        if (multimapFeatures.contains(MapFeature.ALLOWS_NULL_KEYS)) {
            result.add(CollectionFeature.ALLOWS_NULL_VALUES);
        }
        if (multimapFeatures.contains(MapFeature.ALLOWS_NULL_KEY_QUERIES)) {
            result.add(CollectionFeature.ALLOWS_NULL_QUERIES);
        }
        return result;
    }

    private static Set<Feature<?>> computeReserializedMultimapFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(multimapFeatures);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    private static Set<Feature<?>> computeAsMapFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(multimapFeatures);
        derivedFeatures.remove(MapFeature.GENERAL_PURPOSE);
        derivedFeatures.remove(MapFeature.SUPPORTS_PUT);
        derivedFeatures.remove(MapFeature.ALLOWS_NULL_VALUES);
        derivedFeatures.add(MapFeature.ALLOWS_NULL_VALUE_QUERIES);
        derivedFeatures.add(MapFeature.REJECTS_DUPLICATES_AT_CREATION);
        if (!derivedFeatures.contains(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        }
        return derivedFeatures;
    }

    Set<Feature<?>> computeMultimapGetFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(multimapFeatures);
        for (Map.Entry entry : GET_FEATURE_MAP.entries()) {
            if (!derivedFeatures.contains(entry.getKey())) continue;
            derivedFeatures.add((Feature)entry.getValue());
        }
        if (derivedFeatures.remove(MultimapFeature.VALUE_COLLECTIONS_SUPPORT_ITERATOR_REMOVE)) {
            derivedFeatures.add(CollectionFeature.SUPPORTS_ITERATOR_REMOVE);
        }
        if (!derivedFeatures.contains(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS)) {
            derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        }
        derivedFeatures.removeAll((Collection<?>)GET_FEATURE_MAP.keySet());
        return derivedFeatures;
    }

    Set<Feature<?>> computeMultimapAsMapGetFeatures(Set<Feature<?>> multimapFeatures) {
        Set<Feature<?>> derivedFeatures = Helpers.copyToSet(this.computeMultimapGetFeatures(multimapFeatures));
        if (derivedFeatures.remove(CollectionSize.ANY)) {
            derivedFeatures.addAll(CollectionSize.ANY.getImpliedFeatures());
        }
        derivedFeatures.remove(CollectionSize.ZERO);
        return derivedFeatures;
    }

    private static class ReserializedMultimapGenerator<K, V, M extends Multimap<K, V>>
    implements TestMultimapGenerator<K, V, M> {
        private final OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator;

        public ReserializedMultimapGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            this.multimapGenerator = multimapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.multimapGenerator.samples();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return (Map.Entry[])this.multimapGenerator.createArray(length);
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.multimapGenerator.order(insertionOrder);
        }

        @Override
        public M create(Object ... elements) {
            return (M)SerializableTester.reserialize((Multimap)((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).create(elements));
        }

        @Override
        public K[] createKeyArray(int length) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        @Override
        public V[] createValueArray(int length) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createValueArray(length);
        }

        @Override
        public SampleElements<K> sampleKeys() {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys();
        }

        @Override
        public SampleElements<V> sampleValues() {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleValues();
        }

        @Override
        public Collection<V> createCollection(Iterable<? extends V> values) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createCollection(values);
        }
    }

    static class MultimapAsMapGetGenerator<K, V, M extends Multimap<K, V>>
    extends MultimapGetGenerator<K, V, M> {
        public MultimapAsMapGetGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            super(multimapGenerator);
        }

        @Override
        public Collection<V> create(Object ... elements) {
            Map.Entry[] array = (Map.Entry[])this.multimapGenerator.createArray(elements.length);
            Object k = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys().e0();
            for (int i = 0; i < elements.length; ++i) {
                array[i] = Helpers.mapEntry(k, elements[i]);
            }
            return (Collection)((Multimap)this.multimapGenerator.create(array)).asMap().get(k);
        }
    }

    static class MultimapGetGenerator<K, V, M extends Multimap<K, V>>
    implements TestCollectionGenerator<V> {
        final OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator;

        public MultimapGetGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            this.multimapGenerator = multimapGenerator;
        }

        @Override
        public SampleElements<V> samples() {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleValues();
        }

        @Override
        public V[] createArray(int length) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createValueArray(length);
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            Object k = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys().e0();
            ArrayList entries = new ArrayList();
            for (V v : insertionOrder) {
                entries.add(Helpers.mapEntry(k, v));
            }
            Iterable orderedEntries = this.multimapGenerator.order(entries);
            ArrayList values = new ArrayList();
            for (Map.Entry entry : orderedEntries) {
                values.add(entry.getValue());
            }
            return values;
        }

        @Override
        public Collection<V> create(Object ... elements) {
            Map.Entry[] array = (Map.Entry[])this.multimapGenerator.createArray(elements.length);
            Object k = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys().e0();
            for (int i = 0; i < elements.length; ++i) {
                array[i] = Helpers.mapEntry(k, elements[i]);
            }
            return ((Multimap)this.multimapGenerator.create(array)).get(k);
        }
    }

    static class KeysGenerator<K, V, M extends Multimap<K, V>>
    implements TestMultisetGenerator<K>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator;

        public KeysGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            this.multimapGenerator = multimapGenerator;
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.multimapGenerator;
        }

        @Override
        public SampleElements<K> samples() {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys();
        }

        @Override
        public Multiset<K> create(Object ... elements) {
            Map.Entry[] entries = new Map.Entry[elements.length];
            HashMap<Object, Iterator<V>> valueIterators = new HashMap<Object, Iterator<V>>();
            for (int i = 0; i < elements.length; ++i) {
                Object key = elements[i];
                Iterator<V> valueItr = (Iterator<V>)valueIterators.get(key);
                if (valueItr == null) {
                    valueItr = this.sampleValuesIterator();
                    valueIterators.put(key, valueItr);
                }
                entries[i] = Helpers.mapEntry(elements[i], valueItr.next());
            }
            return ((Multimap)this.multimapGenerator.create(entries)).keys();
        }

        private Iterator<V> sampleValuesIterator() {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleValues().iterator();
        }

        @Override
        public K[] createArray(int length) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        @Override
        public Iterable<K> order(List<K> insertionOrder) {
            Iterator<V> valueIter = this.sampleValuesIterator();
            ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>();
            for (K k : insertionOrder) {
                entries.add(Helpers.mapEntry(k, valueIter.next()));
            }
            Iterable ordered = this.multimapGenerator.order(entries);
            ArrayList orderedValues = new ArrayList();
            for (Map.Entry entry : ordered) {
                orderedValues.add(entry.getKey());
            }
            return orderedValues;
        }
    }

    static class ValuesGenerator<K, V, M extends Multimap<K, V>>
    implements TestCollectionGenerator<V> {
        private final OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator;

        public ValuesGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            this.multimapGenerator = multimapGenerator;
        }

        @Override
        public SampleElements<V> samples() {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleValues();
        }

        @Override
        public Collection<V> create(Object ... elements) {
            Object k = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys().e0();
            Map.Entry[] entries = new Map.Entry[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                entries[i] = Helpers.mapEntry(k, elements[i]);
            }
            return ((Multimap)this.multimapGenerator.create(entries)).values();
        }

        @Override
        public V[] createArray(int length) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createValueArray(length);
        }

        @Override
        public Iterable<V> order(List<V> insertionOrder) {
            Object k = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys().e0();
            ArrayList entries = new ArrayList();
            for (V v : insertionOrder) {
                entries.add(Helpers.mapEntry(k, v));
            }
            Iterable ordered = this.multimapGenerator.order(entries);
            ArrayList orderedValues = new ArrayList();
            for (Map.Entry entry : ordered) {
                orderedValues.add(entry.getValue());
            }
            return orderedValues;
        }
    }

    static class EntriesGenerator<K, V, M extends Multimap<K, V>>
    implements TestCollectionGenerator<Map.Entry<K, V>>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator;

        public EntriesGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            this.multimapGenerator = multimapGenerator;
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.multimapGenerator;
        }

        @Override
        public SampleElements<Map.Entry<K, V>> samples() {
            return this.multimapGenerator.samples();
        }

        @Override
        public Collection<Map.Entry<K, V>> create(Object ... elements) {
            return ((Multimap)this.multimapGenerator.create(elements)).entries();
        }

        public Map.Entry<K, V>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<K, V>> order(List<Map.Entry<K, V>> insertionOrder) {
            return this.multimapGenerator.order(insertionOrder);
        }
    }

    private static class AsMapGenerator<K, V, M extends Multimap<K, V>>
    implements TestMapGenerator<K, Collection<V>>,
    DerivedGenerator {
        private final OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator;

        public AsMapGenerator(OneSizeTestContainerGenerator<M, Map.Entry<K, V>> multimapGenerator) {
            this.multimapGenerator = multimapGenerator;
        }

        @Override
        public TestSubjectGenerator<?> getInnerGenerator() {
            return this.multimapGenerator;
        }

        private Collection<V> createCollection(V v) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createCollection(Collections.singleton(v));
        }

        @Override
        public SampleElements<Map.Entry<K, Collection<V>>> samples() {
            SampleElements sampleKeys = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleKeys();
            SampleElements sampleValues = ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).sampleValues();
            return new SampleElements(Helpers.mapEntry(sampleKeys.e0(), this.createCollection(sampleValues.e0())), Helpers.mapEntry(sampleKeys.e1(), this.createCollection(sampleValues.e1())), Helpers.mapEntry(sampleKeys.e2(), this.createCollection(sampleValues.e2())), Helpers.mapEntry(sampleKeys.e3(), this.createCollection(sampleValues.e3())), Helpers.mapEntry(sampleKeys.e4(), this.createCollection(sampleValues.e4())));
        }

        @Override
        public Map<K, Collection<V>> create(Object ... elements) {
            HashSet keySet = new HashSet();
            ArrayList builder = new ArrayList();
            for (Object o : elements) {
                Map.Entry entry = (Map.Entry)o;
                keySet.add(entry.getKey());
                for (Object v : (Collection)entry.getValue()) {
                    builder.add(Helpers.mapEntry(entry.getKey(), v));
                }
            }
            Preconditions.checkArgument((keySet.size() == elements.length ? 1 : 0) != 0, (Object)"Duplicate keys");
            return ((Multimap)this.multimapGenerator.create(builder.toArray())).asMap();
        }

        public Map.Entry<K, Collection<V>>[] createArray(int length) {
            return new Map.Entry[length];
        }

        @Override
        public Iterable<Map.Entry<K, Collection<V>>> order(List<Map.Entry<K, Collection<V>>> insertionOrder) {
            HashMap<K, Collection<V>> map = new HashMap<K, Collection<V>>();
            ArrayList<Map.Entry<K, Object>> builder = new ArrayList<Map.Entry<K, Object>>();
            for (Map.Entry<K, Collection<V>> entry : insertionOrder) {
                for (Object v : entry.getValue()) {
                    builder.add(Helpers.mapEntry(entry.getKey(), v));
                }
                map.put(entry.getKey(), entry.getValue());
            }
            Iterable ordered = this.multimapGenerator.order(builder);
            LinkedHashMap orderedMap = new LinkedHashMap();
            for (Map.Entry entry : ordered) {
                orderedMap.put(entry.getKey(), (Collection)map.get(entry.getKey()));
            }
            return orderedMap.entrySet();
        }

        @Override
        public K[] createKeyArray(int length) {
            return ((TestMultimapGenerator)this.multimapGenerator.getInnerGenerator()).createKeyArray(length);
        }

        public Collection<V>[] createValueArray(int length) {
            return new Collection[length];
        }
    }
}

