/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss.ast;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import java.util.Arrays;
import java.util.List;

public class CssDotPathNode
extends CssValueNode {
    private String suffix;
    private String prefix;
    private String path;
    private String instance;

    public static String resolveExpression(String instance, String path, String prefix, String suffix) {
        String string;
        String string2;
        String expression = String.valueOf(path.replace(".", "().")).concat("()");
        if (!Strings.isNullOrEmpty(instance)) {
            string2 = expression;
            expression = new StringBuilder(1 + String.valueOf(instance).length() + String.valueOf(string2).length()).append(instance).append(".").append(string2).toString();
        }
        if (!Strings.isNullOrEmpty(prefix)) {
            string2 = String.valueOf(Generator.escape((String)prefix));
            string = expression;
            expression = new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string).length()).append("\"").append(string2).append("\" + ").append(string).toString();
        }
        if (!Strings.isNullOrEmpty(suffix)) {
            string2 = String.valueOf(expression);
            string = String.valueOf(Generator.escape((String)suffix));
            expression = new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" + \"").append(string).append("\"").toString();
        }
        return expression;
    }

    public CssDotPathNode(String dotPath, String prefix, String suffix, SourceCodeLocation sourceCodeLocation) {
        this(null, dotPath, prefix, suffix, sourceCodeLocation);
    }

    public CssDotPathNode(String instance, String dotPath, String prefix, String suffix, SourceCodeLocation sourceCodeLocation) {
        super(CssDotPathNode.resolveExpression(instance, dotPath, prefix, suffix), sourceCodeLocation);
        this.prefix = prefix;
        this.suffix = suffix;
        this.path = dotPath;
        this.instance = instance;
    }

    public CssValueNode deepCopy() {
        return new CssDotPathNode(this.instance, this.path, this.prefix, this.suffix, this.getSourceCodeLocation());
    }

    public String getPath() {
        return this.path;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getInstance() {
        return this.instance;
    }

    public List<String> getPathElements() {
        return Arrays.asList(this.path.split("\\."));
    }
}

