/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.Util;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.ResourcePrototype;
import com.google.gwt.resources.converter.Css2Gss;
import com.google.gwt.resources.converter.Css2GssConversionException;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.ext.SupportsGeneratorResultCaching;
import com.google.gwt.resources.gss.BooleanConditionCollector;
import com.google.gwt.resources.gss.CollectAndRemoveConstantDefinitions;
import com.google.gwt.resources.gss.CreateRuntimeConditionalNodes;
import com.google.gwt.resources.gss.CssPrinter;
import com.google.gwt.resources.gss.ExtendedEliminateConditionalNodes;
import com.google.gwt.resources.gss.ExternalClassesCollector;
import com.google.gwt.resources.gss.GwtGssFunctionMapProvider;
import com.google.gwt.resources.gss.ImageSpriteCreator;
import com.google.gwt.resources.gss.PermutationsCollector;
import com.google.gwt.resources.gss.RecordingBidiFlipper;
import com.google.gwt.resources.gss.RenamingSubstitutionMap;
import com.google.gwt.resources.gss.RuntimeConditionalBlockCollector;
import com.google.gwt.resources.gss.ValidateRuntimeConditionalNode;
import com.google.gwt.resources.rg.AbstractCssResourceGenerator;
import com.google.gwt.resources.rg.CssObfuscationStyle;
import com.google.gwt.resources.rg.CssResourceGenerator;
import com.google.gwt.thirdparty.common.css.MinimalSubstitutionMap;
import com.google.gwt.thirdparty.common.css.PrefixingSubstitutionMap;
import com.google.gwt.thirdparty.common.css.SourceCode;
import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.SubstitutionMap;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompositeValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssDefinitionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNumericNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.ErrorManager;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssError;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssFunction;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParser;
import com.google.gwt.thirdparty.common.css.compiler.ast.GssParserException;
import com.google.gwt.thirdparty.common.css.compiler.ast.VisitController;
import com.google.gwt.thirdparty.common.css.compiler.passes.AbbreviatePositionalValues;
import com.google.gwt.thirdparty.common.css.compiler.passes.CheckDependencyNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CollectConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.CollectMixinDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.ColorValueOptimizer;
import com.google.gwt.thirdparty.common.css.compiler.passes.ConstantDefinitions;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateComponentNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateConditionalNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateConstantReferences;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateDefinitionNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateMixins;
import com.google.gwt.thirdparty.common.css.compiler.passes.CreateStandardAtRuleNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.CssClassRenaming;
import com.google.gwt.thirdparty.common.css.compiler.passes.DisallowDuplicateDeclarations;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateEmptyRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateUnitsFromZeroNumericValues;
import com.google.gwt.thirdparty.common.css.compiler.passes.EliminateUselessRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.HandleUnknownAtRuleNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.MarkNonFlippableNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.MarkRemovableRulesetNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.MergeAdjacentRulesetNodesWithSameDeclarations;
import com.google.gwt.thirdparty.common.css.compiler.passes.MergeAdjacentRulesetNodesWithSameSelector;
import com.google.gwt.thirdparty.common.css.compiler.passes.ProcessComponents;
import com.google.gwt.thirdparty.common.css.compiler.passes.ProcessKeyframes;
import com.google.gwt.thirdparty.common.css.compiler.passes.ProcessRefiners;
import com.google.gwt.thirdparty.common.css.compiler.passes.ReplaceConstantReferences;
import com.google.gwt.thirdparty.common.css.compiler.passes.ReplaceMixins;
import com.google.gwt.thirdparty.common.css.compiler.passes.ResolveCustomFunctionNodes;
import com.google.gwt.thirdparty.common.css.compiler.passes.SplitRulesetNodes;
import com.google.gwt.thirdparty.guava.common.base.CaseFormat;
import com.google.gwt.thirdparty.guava.common.base.Charsets;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableCollection;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.io.ByteSource;
import com.google.gwt.thirdparty.guava.common.io.Resources;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import org.apache.commons.io.IOUtils;

public class GssResourceGenerator
extends AbstractCssResourceGenerator
implements SupportsGeneratorResultCaching {
    private static boolean shouldEmitVariables;
    private static PrintWriter printWriter;
    private static Set<String> writtenAtDefs;
    private static final String KEY_ENABLE_GSS = "CssResource.enableGss";
    private static final String KEY_GSS_DEFAULT_IN_UIBINDER = "CssResource.gssDefaultInUiBinder";
    private static final SubstitutionMap resourcePrefixBuilder;
    private static final String KEY_CONVERSION_MODE = "CssResource.conversionMode";
    private static final String KEY_STYLE = "CssResource.style";
    private static final String ALLOWED_AT_RULE = "CssResource.allowedAtRules";
    private static final String ALLOWED_FUNCTIONS = "CssResource.allowedFunctions";
    private static final String KEY_OBFUSCATION_PREFIX = "CssResource.obfuscationPrefix";
    private static final String KEY_CLASS_PREFIX = "cssResourcePrefix";
    private static final String KEY_BY_CLASS_AND_METHOD = "cssResourceClassAndMethod";
    private static final String KEY_HAS_CACHED_DATA = "hasCachedData";
    private static final String KEY_SHARED_METHODS = "sharedMethods";
    private static final char[] BASE32_CHARS;
    private static final Pattern CHARSET;
    private static final int CHARSET_MIN_LENGTH;
    private Map<JMethod, CssParsingResult> cssParsingResultMap;
    private Set<String> allowedNonStandardFunctions;
    private LoggerErrorManager errorManager;
    private JMethod getTextMethod;
    private JMethod ensuredInjectedMethod;
    private JMethod getNameMethod;
    private String obfuscationPrefix;
    private CssObfuscationStyle obfuscationStyle;
    private Set<String> allowedAtRules;
    private Map<JClassType, Map<String, String>> replacementsByClassAndMethod;
    private Map<JMethod, String> replacementsForSharedMethods;
    private final GssOptions gssOptions;

    public static GssOptions getGssOptions(PropertyOracle propertyOracle, TreeLogger logger) throws UnableToCompleteException {
        boolean gssDefaultInUiBinder;
        AutoConversionMode conversionMode;
        boolean gssEnabled;
        try {
            ConfigurationProperty enableGssProp = propertyOracle.getConfigurationProperty(KEY_ENABLE_GSS);
            String enableGss = (String)enableGssProp.getValues().get(0);
            gssEnabled = Boolean.parseBoolean(enableGss);
        }
        catch (BadPropertyValueException ex) {
            logger.log(TreeLogger.Type.ERROR, "Unable to determine if GSS need to be used");
            throw new UnableToCompleteException();
        }
        try {
            conversionMode = Enum.valueOf(AutoConversionMode.class, ((String)propertyOracle.getConfigurationProperty(KEY_CONVERSION_MODE).getValues().get(0)).toUpperCase(Locale.ROOT));
        }
        catch (BadPropertyValueException ex) {
            logger.log(TreeLogger.Type.ERROR, "Unable to conversion mode for GSS");
            throw new UnableToCompleteException();
        }
        try {
            ConfigurationProperty uiBinderGssDefaultProp = propertyOracle.getConfigurationProperty(KEY_GSS_DEFAULT_IN_UIBINDER);
            String uiBinderGssDefaultValue = (String)uiBinderGssDefaultProp.getValues().get(0);
            gssDefaultInUiBinder = Boolean.parseBoolean(uiBinderGssDefaultValue);
        }
        catch (BadPropertyValueException ex) {
            logger.log(TreeLogger.Type.ERROR, "Unable to determine default for GSS in UiBinder");
            throw new UnableToCompleteException();
        }
        return new GssOptions(gssEnabled, conversionMode, gssDefaultInUiBinder);
    }

    private static synchronized void write(Set<String> variables) {
        for (String atDef : variables) {
            if (!writtenAtDefs.add(atDef)) continue;
            printWriter.println("@def " + atDef + " 1px;");
        }
        printWriter.flush();
    }

    public static String getImportPrefix(JClassType importType) {
        String prefix = importType.getSimpleSourceName();
        CssResource.ImportedWithPrefix exp = (CssResource.ImportedWithPrefix)importType.getAnnotation(CssResource.ImportedWithPrefix.class);
        if (exp != null) {
            prefix = exp.value();
        }
        return prefix + "-";
    }

    private static String encode(long id) {
        assert (id >= 0L);
        StringBuilder b = new StringBuilder();
        b.append(BASE32_CHARS[(int)(id & 0xFL)]);
        id >>= 4;
        while (id != 0L) {
            b.append(BASE32_CHARS[(int)(id & 0x1FL)]);
            id >>= 5;
        }
        return b.toString();
    }

    private static boolean checkPropertyIsSingleValueAndBoolean(ConfigurationProperty property, TreeLogger logger) {
        List values = property.getValues();
        if (values.size() > 1) {
            logger.log(TreeLogger.Type.ERROR, "The configuration property " + property.getName() + " is used in " + "a conditional css and cannot be a multi-valued property");
            return false;
        }
        String value = (String)values.get(0);
        if (!"true".equals(value) && !"false".equals(value)) {
            logger.log(TreeLogger.Type.ERROR, "The configuration property " + property.getName() + " is used in " + "a conditional css. Its value must be either \"true\" or \"false\"");
            return false;
        }
        return true;
    }

    static URL[] findResources(TreeLogger logger, ResourceContext context, JMethod method, boolean gssEnabled) throws UnableToCompleteException {
        boolean isSourceAnnotationUsed;
        boolean bl = isSourceAnnotationUsed = method.getAnnotation(ClientBundle.Source.class) != null;
        if (!isSourceAnnotationUsed) {
            String[] stringArray;
            if (gssEnabled) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = ".gss";
                stringArray = stringArray2;
                stringArray2[1] = ".css";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = ".css";
                stringArray = stringArray3;
                stringArray3[1] = ".gss";
            }
            String[] extensions = stringArray;
            return ResourceGeneratorUtil.findResources(logger, context, method, extensions);
        }
        URL[] originalResources = ResourceGeneratorUtil.findResources(logger, context, method);
        URL[] resourcesToUse = new URL[originalResources.length];
        String preferredExtension = gssEnabled ? ".gss" : ".css";
        String[] sourceFiles = ((ClientBundle.Source)method.getAnnotation(ClientBundle.Source.class)).value();
        for (int i = 0; i < sourceFiles.length; ++i) {
            URL preferredUrl;
            String preferredFile;
            String original = sourceFiles[i];
            if (!original.endsWith(preferredExtension) && original.length() > 4) {
                preferredFile = original.substring(0, original.length() - 4) + preferredExtension;
                String path = method.getEnclosingType().getPackage().getName().replace('.', '/') + '/';
                preferredUrl = ResourceGeneratorUtil.tryFindResource(logger, context.getGeneratorContext(), context, path + preferredFile);
                if (preferredUrl == null) {
                    preferredUrl = ResourceGeneratorUtil.tryFindResource(logger, context.getGeneratorContext(), context, preferredFile);
                }
                if (preferredUrl == null) {
                    return originalResources;
                }
            } else {
                return originalResources;
            }
            logger.log(TreeLogger.Type.DEBUG, "Preferred resource file found: " + preferredFile + ". This file " + "will be used in replacement of " + original);
            resourcesToUse[i] = preferredUrl;
        }
        return resourcesToUse;
    }

    public GssResourceGenerator(GssOptions gssOptions) {
        this.gssOptions = gssOptions;
    }

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        CssParsingResult cssParsingResult = this.cssParsingResultMap.get(method);
        CssTree cssTree = cssParsingResult.tree;
        RenamingResult renamingResult = this.doClassRenaming(cssTree, method, logger, context);
        ConstantDefinitions constantDefinitions = this.optimizeTree(cssParsingResult, context, true, true, logger);
        this.checkErrors();
        Set<String> externalClasses = this.revertRenamingOfExternalClasses(cssTree, renamingResult);
        this.checkErrors();
        this.validateExternalClasses(externalClasses, renamingResult.externalClassCandidate, method, logger);
        StringSourceWriter sw = new StringSourceWriter();
        sw.println("new " + method.getReturnType().getQualifiedSourceName() + "() {");
        sw.indent();
        Map<JMethod, String> actualReplacements = this.writeMethods(logger, context, method, (SourceWriter)sw, constantDefinitions, cssParsingResult.originalConstantNameMapping, renamingResult.mapping);
        sw.outdent();
        sw.println("}");
        CssResourceGenerator.outputCssMapArtifact(logger, context, method, actualReplacements);
        return sw.toString();
    }

    private void validateExternalClasses(Set<String> externalClasses, Set<String> externalClassCandidates, JMethod method, TreeLogger logger) throws UnableToCompleteException {
        if (!this.isStrictResource(method)) {
            return;
        }
        boolean hasError = false;
        for (String candidate : externalClassCandidates) {
            if (externalClasses.contains(candidate)) continue;
            logger.log(TreeLogger.Type.ERROR, "The following non-obfuscated class is present in a strict CssResource: " + candidate + ". Fix by adding String accessor " + "method(s) to the CssResource interface for obfuscated classes, " + "or use an @external declaration for unobfuscated classes.");
            hasError = true;
        }
        if (hasError) {
            throw new UnableToCompleteException();
        }
    }

    @Override
    public void init(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        this.cssParsingResultMap = new IdentityHashMap<JMethod, CssParsingResult>();
        this.errorManager = new LoggerErrorManager(logger);
        this.allowedNonStandardFunctions = new HashSet<String>();
        this.allowedAtRules = Sets.newHashSet("external");
        try {
            PropertyOracle propertyOracle = context.getGeneratorContext().getPropertyOracle();
            ConfigurationProperty styleProp = propertyOracle.getConfigurationProperty(KEY_STYLE);
            this.obfuscationStyle = CssObfuscationStyle.getObfuscationStyle((String)styleProp.getValues().get(0));
            this.obfuscationPrefix = this.getObfuscationPrefix(propertyOracle, context);
            ConfigurationProperty allowedAtRuleProperty = propertyOracle.getConfigurationProperty(ALLOWED_AT_RULE);
            this.allowedAtRules.addAll(allowedAtRuleProperty.getValues());
            ConfigurationProperty allowedFunctionsProperty = propertyOracle.getConfigurationProperty(ALLOWED_FUNCTIONS);
            this.allowedNonStandardFunctions.addAll(allowedFunctionsProperty.getValues());
            ClientBundleRequirements requirements = context.getRequirements();
            requirements.addConfigurationProperty(KEY_STYLE);
            requirements.addConfigurationProperty(KEY_OBFUSCATION_PREFIX);
            requirements.addConfigurationProperty(ALLOWED_AT_RULE);
            requirements.addConfigurationProperty(ALLOWED_FUNCTIONS);
            requirements.addConfigurationProperty(KEY_CONVERSION_MODE);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Unable to query module property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType cssResourceInterface = typeOracle.findType(CssResource.class.getCanonicalName());
        JClassType resourcePrototypeInterface = typeOracle.findType(ResourcePrototype.class.getCanonicalName());
        try {
            this.getTextMethod = cssResourceInterface.getMethod("getText", new JType[0]);
            this.ensuredInjectedMethod = cssResourceInterface.getMethod("ensureInjected", new JType[0]);
            this.getNameMethod = resourcePrototypeInterface.getMethod("getName", new JType[0]);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Unable to lookup methods from CssResource and ResourcePrototype interface", (Throwable)e);
            throw new UnableToCompleteException();
        }
        this.initReplacement(context);
    }

    private void initReplacement(ResourceContext context) {
        if (context.getCachedData(KEY_HAS_CACHED_DATA, Boolean.class) != Boolean.TRUE) {
            context.putCachedData(KEY_SHARED_METHODS, new IdentityHashMap());
            context.putCachedData(KEY_BY_CLASS_AND_METHOD, new IdentityHashMap());
            context.putCachedData(KEY_HAS_CACHED_DATA, Boolean.TRUE);
        }
        this.replacementsByClassAndMethod = context.getCachedData(KEY_BY_CLASS_AND_METHOD, Map.class);
        this.replacementsForSharedMethods = context.getCachedData(KEY_SHARED_METHODS, Map.class);
    }

    private String getObfuscationPrefix(PropertyOracle propertyOracle, ResourceContext context) throws BadPropertyValueException {
        String prefix = (String)propertyOracle.getConfigurationProperty(KEY_OBFUSCATION_PREFIX).getValues().get(0);
        if ("empty".equalsIgnoreCase(prefix)) {
            return "";
        }
        if ("default".equalsIgnoreCase(prefix)) {
            return this.getDefaultObfuscationPrefix(context);
        }
        return prefix;
    }

    private String getDefaultObfuscationPrefix(ResourceContext context) {
        String prefix = context.getCachedData(KEY_CLASS_PREFIX, String.class);
        if (prefix == null) {
            prefix = this.computeDefaultPrefix(context);
            context.putCachedData(KEY_CLASS_PREFIX, prefix);
        }
        return prefix;
    }

    private String computeDefaultPrefix(ResourceContext context) {
        SortedSet<JClassType> gssResources = this.computeOperableTypes(context);
        Adler32 checksum = new Adler32();
        for (JClassType type : gssResources) {
            checksum.update(Util.getBytes((String)type.getQualifiedSourceName()));
        }
        int seed = Math.abs((int)checksum.getValue());
        return GssResourceGenerator.encode(seed) + "-";
    }

    private SortedSet<JClassType> computeOperableTypes(ResourceContext context) {
        JClassType[] cssResourceSubtypes;
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        JClassType baseInterface = typeOracle.findType(CssResource.class.getCanonicalName());
        TreeSet<JClassType> toReturn = new TreeSet<JClassType>(new CssResourceGenerator.JClassOrderComparator());
        for (JClassType type : cssResourceSubtypes = baseInterface.getSubtypes()) {
            if (type.isInterface() == null) continue;
            toReturn.add(type);
        }
        return toReturn;
    }

    @Override
    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        if (method.getReturnType().isInterface() == null) {
            logger.log(TreeLogger.ERROR, "Return type must be an interface");
            throw new UnableToCompleteException();
        }
        URL[] resourceUrls = GssResourceGenerator.findResources(logger, context, method, this.gssOptions.isEnabled());
        if (resourceUrls.length == 0) {
            logger.log(TreeLogger.ERROR, "At least one source must be specified");
            throw new UnableToCompleteException();
        }
        CssParsingResult cssParsingResult = this.parseResources(Lists.newArrayList(resourceUrls), context, logger);
        this.cssParsingResultMap.put(method, cssParsingResult);
        for (String permutationAxis : cssParsingResult.permutationAxes) {
            try {
                context.getRequirements().addPermutationAxis(permutationAxis);
            }
            catch (BadPropertyValueException e) {
                logger.log(TreeLogger.ERROR, "Unknown deferred-binding property " + permutationAxis, (Throwable)e);
                throw new UnableToCompleteException();
            }
        }
    }

    @Override
    protected String getCssExpression(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        CssTree cssTree = this.cssParsingResultMap.get((Object)method).tree;
        String standard = this.printCssTree(cssTree);
        RecordingBidiFlipper recordingBidiFlipper = new RecordingBidiFlipper(cssTree.getMutatingVisitController(), false, false, true);
        recordingBidiFlipper.runPass();
        if (recordingBidiFlipper.nodeFlipped()) {
            String reversed = this.printCssTree(cssTree);
            return LocaleInfo.class.getName() + ".getCurrentLocale().isRTL() ? " + reversed + " : " + standard;
        }
        return standard;
    }

    private void checkErrors() throws UnableToCompleteException {
        if (this.errorManager.hasErrors()) {
            throw new UnableToCompleteException();
        }
    }

    private RenamingResult doClassRenaming(CssTree cssTree, JMethod method, TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        Map<String, Map<String, String>> replacementsWithPrefix = this.computeReplacements(method, logger, context);
        RenamingSubstitutionMap substitutionMap = new RenamingSubstitutionMap(replacementsWithPrefix);
        new CssClassRenaming(cssTree.getMutatingVisitController(), (SubstitutionMap)substitutionMap, null).runPass();
        Map<String, String> mapping = replacementsWithPrefix.get("");
        mapping = Maps.newHashMap(Maps.filterKeys(mapping, Predicates.in(substitutionMap.getStyleClasses())));
        return new RenamingResult(mapping, substitutionMap.getExternalClassCandidates());
    }

    private Set<String> revertRenamingOfExternalClasses(CssTree cssTree, RenamingResult renamingResult) {
        ExternalClassesCollector externalClassesCollector = new ExternalClassesCollector(cssTree.getMutatingVisitController(), this.errorManager);
        externalClassesCollector.runPass();
        Map<String, String> styleClassesMapping = renamingResult.mapping;
        HashSet<String> allStyleClassSet = Sets.newHashSet(styleClassesMapping.keySet());
        allStyleClassSet.addAll(renamingResult.externalClassCandidate);
        ImmutableSet<String> externalClasses = externalClassesCollector.getExternalClassNames(allStyleClassSet, renamingResult.externalClassCandidate);
        final HashMap<String, String> revertMap = new HashMap<String, String>(externalClasses.size());
        for (String external : externalClasses) {
            revertMap.put(styleClassesMapping.get(external), external);
            styleClassesMapping.put(external, external);
        }
        SubstitutionMap revertExternalClasses = new SubstitutionMap(){

            public String get(String key) {
                return (String)revertMap.get(key);
            }
        };
        new CssClassRenaming(cssTree.getMutatingVisitController(), revertExternalClasses, null).runPass();
        return externalClasses;
    }

    private boolean isStrictResource(JMethod method) {
        CssResource.NotStrict notStrict = (CssResource.NotStrict)method.getAnnotation(CssResource.NotStrict.class);
        return notStrict == null;
    }

    private void finalizeTree(CssTree cssTree) throws UnableToCompleteException {
        new CheckDependencyNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, false).runPass();
        this.checkErrors();
        new CreateStandardAtRuleNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateMixins(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateDefinitionNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateConstantReferences(cssTree.getMutatingVisitController()).runPass();
        new CreateConditionalNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new CreateRuntimeConditionalNodes(cssTree.getMutatingVisitController()).runPass();
        new CreateComponentNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        new HandleUnknownAtRuleNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, this.allowedAtRules, true, false).runPass();
        new ProcessKeyframes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, true, true).runPass();
        new ProcessRefiners(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, true).runPass();
        new MarkNonFlippableNodes((VisitController)cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
    }

    private ConstantDefinitions optimizeTree(CssParsingResult cssParsingResult, ResourceContext context, boolean simplifyCss, boolean eliminateDeadStyles, TreeLogger logger) throws UnableToCompleteException {
        CssTree cssTree = cssParsingResult.tree;
        CollectMixinDefinitions collectMixinDefinitions = new CollectMixinDefinitions(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager);
        collectMixinDefinitions.runPass();
        new ReplaceMixins(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, collectMixinDefinitions.getDefinitions()).runPass();
        new ProcessComponents(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        RuntimeConditionalBlockCollector runtimeConditionalBlockCollector = new RuntimeConditionalBlockCollector(cssTree.getVisitController());
        runtimeConditionalBlockCollector.runPass();
        ImmutableCollection trueCompileTimeConditions = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.getCurrentDeferredBindingProperties(context, cssParsingResult.permutationAxes, logger))).addAll(this.getTrueConfigurationProperties(context, cssParsingResult.trueConditions, logger))).build();
        new ExtendedEliminateConditionalNodes(cssTree.getMutatingVisitController(), (Set<String>)((Object)trueCompileTimeConditions), runtimeConditionalBlockCollector.getRuntimeConditionalBlock()).runPass();
        new ValidateRuntimeConditionalNode(cssTree.getVisitController(), this.errorManager, this.gssOptions.isLenientConversion()).runPass();
        this.checkErrors();
        CollectConstantDefinitions collectConstantDefinitionsPass = new CollectConstantDefinitions(cssTree);
        collectConstantDefinitionsPass.runPass();
        ReplaceConstantReferences replaceConstantReferences = new ReplaceConstantReferences(cssTree, collectConstantDefinitionsPass.getConstantDefinitions(), false, (ErrorManager)this.errorManager, false);
        replaceConstantReferences.runPass();
        new ImageSpriteCreator(cssTree.getMutatingVisitController(), context, this.errorManager).runPass();
        Map<String, GssFunction> gssFunctionMap = new GwtGssFunctionMapProvider(context).get();
        new ResolveCustomFunctionNodes(cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager, gssFunctionMap, true, this.allowedNonStandardFunctions).runPass();
        collectConstantDefinitionsPass = new CollectAndRemoveConstantDefinitions(cssTree);
        collectConstantDefinitionsPass.runPass();
        if (simplifyCss) {
            new EliminateEmptyRulesetNodes(cssTree.getMutatingVisitController()).runPass();
            new EliminateUnitsFromZeroNumericValues(cssTree.getMutatingVisitController()).runPass();
            new ColorValueOptimizer(cssTree.getMutatingVisitController()).runPass();
            new AbbreviatePositionalValues(cssTree.getMutatingVisitController()).runPass();
        }
        if (eliminateDeadStyles) {
            new DisallowDuplicateDeclarations(cssTree.getVisitController(), (ErrorManager)this.errorManager).runPass();
            new SplitRulesetNodes(cssTree.getMutatingVisitController()).runPass();
            new MarkRemovableRulesetNodes(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MergeAdjacentRulesetNodesWithSameSelector(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MergeAdjacentRulesetNodesWithSameDeclarations(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MarkNonFlippableNodes((VisitController)cssTree.getMutatingVisitController(), (ErrorManager)this.errorManager).runPass();
        }
        return collectConstantDefinitionsPass.getConstantDefinitions();
    }

    private Set<String> getTrueConfigurationProperties(ResourceContext context, Set<String> configurationProperties, TreeLogger logger) throws UnableToCompleteException {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        PropertyOracle oracle = context.getGeneratorContext().getPropertyOracle();
        for (String property : configurationProperties) {
            try {
                ConfigurationProperty confProp = oracle.getConfigurationProperty(property);
                if (!GssResourceGenerator.checkPropertyIsSingleValueAndBoolean(confProp, logger)) {
                    throw new UnableToCompleteException();
                }
                if (!"true".equals(confProp.getValues().get(0))) continue;
                setBuilder.add(property);
            }
            catch (BadPropertyValueException e1) {
                logger.log(TreeLogger.Type.ERROR, "Unknown configuration property [" + property + "]");
                throw new UnableToCompleteException();
            }
        }
        return setBuilder.build();
    }

    private Set<String> getCurrentDeferredBindingProperties(ResourceContext context, List<String> permutationAxes, TreeLogger logger) throws UnableToCompleteException {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        PropertyOracle oracle = context.getGeneratorContext().getPropertyOracle();
        for (String permutationAxis : permutationAxes) {
            String propValue;
            try {
                SelectionProperty selProp = oracle.getSelectionProperty(null, permutationAxis);
                propValue = selProp.getCurrentValue();
            }
            catch (BadPropertyValueException e) {
                try {
                    ConfigurationProperty confProp = oracle.getConfigurationProperty(permutationAxis);
                    propValue = (String)confProp.getValues().get(0);
                }
                catch (BadPropertyValueException e1) {
                    logger.log(TreeLogger.Type.ERROR, "Unknown configuration property [" + permutationAxis + "]");
                    throw new UnableToCompleteException();
                }
            }
            if (propValue == null) continue;
            setBuilder.add(permutationAxis + ":" + propValue);
        }
        return setBuilder.build();
    }

    private CssParsingResult parseResources(List<URL> resources, ResourceContext context, TreeLogger logger) throws UnableToCompleteException {
        CssTree tree;
        ArrayList<SourceCode> sourceCodes = new ArrayList<SourceCode>(resources.size());
        ImmutableMap.Builder<String, String> constantNameMappingBuilder = ImmutableMap.builder();
        boolean css = this.ensureEitherCssOrGss(resources, logger);
        if (css && this.gssOptions.isAutoConversionOff()) {
            logger.log(TreeLogger.Type.ERROR, "Your ClientBundle is referencing css files instead of gss. You will need to either convert these files to gss using the converter tool or turn on auto convertion in your gwt.xml file. Note: Autoconversion will be removed in the next version of GWT, you will need to move to gss.Add this line to your gwt.xml file to temporary avoid this:<set-configuration-property name=\"CssResource.conversionMode\"    value=\"strict\" />");
            throw new UnableToCompleteException();
        }
        if (css) {
            String concatenatedCss = GssResourceGenerator.concatCssFiles(resources, logger);
            ConversionResult result = this.convertToGss(concatenatedCss, context, logger);
            if (shouldEmitVariables) {
                GssResourceGenerator.write(result.defNameMapping.keySet());
            }
            String gss = result.gss;
            String name = "[auto-converted gss files from : " + resources + "]";
            sourceCodes.add(new SourceCode(name, gss));
            constantNameMappingBuilder.putAll(result.defNameMapping);
        } else {
            for (URL stylesheet : resources) {
                TreeLogger branchLogger = logger.branch(TreeLogger.DEBUG, "Parsing GSS stylesheet " + stylesheet.toExternalForm());
                try {
                    ByteSource byteSource = Resources.asByteSource(stylesheet);
                    Charset charset = Charsets.UTF_8;
                    String styleSheetCharset = this.extractCharset(byteSource);
                    if (styleSheetCharset != null) {
                        try {
                            charset = Charset.forName(styleSheetCharset);
                        }
                        catch (UnsupportedCharsetException e) {
                            logger.log(TreeLogger.Type.ERROR, "Unsupported charset found: " + styleSheetCharset);
                            throw new UnableToCompleteException();
                        }
                    }
                    String fileContent = byteSource.asCharSource(charset).read();
                    if (styleSheetCharset != null) {
                        int charsetAtRuleLength = CHARSET_MIN_LENGTH + styleSheetCharset.length();
                        fileContent = Strings.repeat(" ", charsetAtRuleLength) + fileContent.substring(charsetAtRuleLength);
                    }
                    sourceCodes.add(new SourceCode(stylesheet.getFile(), fileContent));
                }
                catch (IOException e) {
                    branchLogger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
                    throw new UnableToCompleteException();
                }
            }
        }
        try {
            tree = new GssParser(sourceCodes).parse();
        }
        catch (GssParserException e) {
            logger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
            throw new UnableToCompleteException();
        }
        this.finalizeTree(tree);
        this.checkErrors();
        BooleanConditionCollector booleanConditionCollector = new BooleanConditionCollector(tree.getMutatingVisitController());
        booleanConditionCollector.runPass();
        PermutationsCollector permutationsCollector = new PermutationsCollector(tree.getMutatingVisitController());
        permutationsCollector.runPass();
        return new CssParsingResult(tree, permutationsCollector.getPermutationAxes(), booleanConditionCollector.getBooleanConditions(), constantNameMappingBuilder.build());
    }

    private String extractCharset(ByteSource byteSource) throws IOException {
        Matcher matcher;
        String firstLine = byteSource.asCharSource(Charsets.UTF_8).readFirstLine();
        if (firstLine != null && (matcher = CHARSET.matcher(firstLine)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConversionResult convertToGss(String concatenatedCss, ResourceContext context, TreeLogger logger) throws UnableToCompleteException {
        ConversionResult conversionResult;
        FileOutputStream fos;
        block10: {
            File tempFile = null;
            fos = null;
            try {
                tempFile = File.createTempFile(UUID.randomUUID() + "css_converter", "css.tmp");
                fos = new FileOutputStream(tempFile);
                IOUtils.write((String)concatenatedCss, (OutputStream)fos);
                fos.close();
                ConfigurationPropertyMatcher configurationPropertyMatcher = new ConfigurationPropertyMatcher(context, logger);
                Css2Gss converter = new Css2Gss(tempFile.toURI().toURL(), logger, this.gssOptions.isLenientConversion(), configurationPropertyMatcher);
                String gss = converter.toGss();
                if (configurationPropertyMatcher.error) {
                    throw new UnableToCompleteException();
                }
                conversionResult = new ConversionResult(gss, converter.getDefNameMapping());
                if (tempFile == null) break block10;
            }
            catch (Css2GssConversionException e) {
                try {
                    String message = "An error occurs during the automatic conversion: " + e.getMessage();
                    if (!this.gssOptions.isLenientConversion()) {
                        message = message + "\n You should try to change the faulty css to fix this error. If you are unable to change the css, you can setup the automatic conversion to be lenient. Add the following line to your gwt.xml file: <set-configuration-property name=\"CssResource.conversionMode\" value=\"lenient\" />";
                    }
                    logger.log(TreeLogger.Type.ERROR, message, (Throwable)e);
                    throw new UnableToCompleteException();
                    catch (IOException e2) {
                        logger.log(TreeLogger.Type.ERROR, "Error while writing temporary css file", (Throwable)e2);
                        throw new UnableToCompleteException();
                    }
                }
                catch (Throwable throwable) {
                    if (tempFile != null) {
                        tempFile.delete();
                    }
                    if (fos != null) {
                        IOUtils.closeQuietly(fos);
                    }
                    throw throwable;
                }
            }
            tempFile.delete();
        }
        if (fos != null) {
            IOUtils.closeQuietly((OutputStream)fos);
        }
        return conversionResult;
    }

    public static String concatCssFiles(List<URL> resources, TreeLogger logger) throws UnableToCompleteException {
        StringBuffer buffer = new StringBuffer();
        for (URL stylesheet : resources) {
            try {
                String fileContent = Resources.asByteSource(stylesheet).asCharSource(Charsets.UTF_8).read();
                buffer.append(fileContent);
                buffer.append("\n");
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unable to parse CSS", (Throwable)e);
                throw new UnableToCompleteException();
            }
        }
        return buffer.toString();
    }

    private boolean ensureEitherCssOrGss(List<URL> resources, TreeLogger logger) throws UnableToCompleteException {
        boolean css = resources.get(0).toString().endsWith(".css");
        for (URL stylesheet : resources) {
            if (css && !stylesheet.toString().endsWith(".css")) {
                logger.log(TreeLogger.Type.ERROR, "Only either css files or gss files are supported on one interface");
                throw new UnableToCompleteException();
            }
            if (css || stylesheet.toString().endsWith(".gss")) continue;
            logger.log(TreeLogger.Type.ERROR, "Only either css files or gss files are supported on one interface");
            throw new UnableToCompleteException();
        }
        return css;
    }

    private String printCssTree(CssTree tree) {
        CssPrinter cssPrinterPass = new CssPrinter(tree);
        cssPrinterPass.runPass();
        return cssPrinterPass.getCompactPrintedString();
    }

    private boolean writeClassMethod(TreeLogger logger, JMethod userMethod, Map<String, String> substitutionMap, SourceWriter sw) throws UnableToCompleteException {
        if (userMethod.getParameters().length > 0) {
            logger.log(TreeLogger.Type.ERROR, "The method [" + userMethod.getName() + "] shouldn't contain any " + "parameters");
            throw new UnableToCompleteException();
        }
        String name = this.getClassName(userMethod);
        String value = substitutionMap.get(name);
        if (value == null) {
            logger.log(TreeLogger.Type.ERROR, "The following style class [" + name + "] is missing from the source" + " CSS file");
            return false;
        }
        this.writeSimpleGetter(userMethod, "\"" + value + "\"", sw);
        return true;
    }

    private String getClassName(JMethod method) {
        String name = method.getName();
        CssResource.ClassName classNameOverride = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
        if (classNameOverride != null) {
            name = classNameOverride.value();
        }
        return name;
    }

    private boolean writeDefMethod(CssDefinitionNode definitionNode, TreeLogger logger, JMethod userMethod, SourceWriter sw) throws UnableToCompleteException {
        String returnExpr;
        String name = userMethod.getName();
        JClassType classReturnType = userMethod.getReturnType().isClass();
        List params = definitionNode.getParameters();
        if (params.size() != 1 && !this.isReturnTypeString(classReturnType)) {
            logger.log(TreeLogger.ERROR, "@def rule " + name + " must define exactly one value or return type must be String");
            return false;
        }
        if (this.isReturnTypeString(classReturnType)) {
            ArrayList<String> returnValues = new ArrayList<String>();
            for (CssValueNode valueNode : params) {
                returnValues.add(Generator.escape((String)valueNode.toString()));
            }
            returnExpr = "\"" + Joiner.on(" ").join(returnValues) + "\"";
        } else {
            CssCompositeValueNode toUnwrap;
            JPrimitiveType returnType = userMethod.getReturnType().isPrimitive();
            if (returnType == null) {
                logger.log(TreeLogger.ERROR, name + ": Return type must be primitive type " + "or String for @def accessors");
                return false;
            }
            CssValueNode valueNode = (CssValueNode)params.get(0);
            if (valueNode instanceof CssCompositeValueNode && (toUnwrap = (CssCompositeValueNode)valueNode).getValues().size() == 1) {
                valueNode = (CssValueNode)toUnwrap.getValues().get(0);
            }
            if (!(valueNode instanceof CssNumericNode)) {
                logger.log(TreeLogger.ERROR, "The value of the constant defined by @" + name + " is not a" + " numeric");
                return false;
            }
            String numericValue = ((CssNumericNode)valueNode).getNumericPart();
            if (returnType == JPrimitiveType.INT || returnType == JPrimitiveType.LONG) {
                returnExpr = "" + Long.parseLong(numericValue);
            } else if (returnType == JPrimitiveType.FLOAT) {
                returnExpr = numericValue + "F";
            } else if (returnType == JPrimitiveType.DOUBLE) {
                returnExpr = "" + numericValue;
            } else {
                logger.log(TreeLogger.ERROR, returnType.getQualifiedSourceName() + " is not a valid primitive return type for @def accessors");
                return false;
            }
        }
        this.writeSimpleGetter(userMethod, returnExpr, sw);
        return true;
    }

    private Map<JMethod, String> writeMethods(TreeLogger logger, ResourceContext context, JMethod method, SourceWriter sw, ConstantDefinitions constantDefinitions, Map<String, String> originalConstantNameMapping, Map<String, String> substitutionMap) throws UnableToCompleteException {
        JClassType gssResource = method.getReturnType().isInterface();
        boolean success = true;
        LinkedHashMap<JMethod, String> methodToClassName = new LinkedHashMap<JMethod, String>();
        for (JMethod toImplement : gssResource.getOverridableMethods()) {
            if (toImplement == this.getTextMethod) {
                this.writeGetText(logger, context, method, sw);
                continue;
            }
            if (toImplement == this.ensuredInjectedMethod) {
                this.writeEnsureInjected(sw);
                continue;
            }
            if (toImplement == this.getNameMethod) {
                this.writeGetName(method, sw);
                continue;
            }
            success &= this.writeUserMethod(logger, toImplement, sw, constantDefinitions, originalConstantNameMapping, substitutionMap, methodToClassName);
        }
        if (!success) {
            throw new UnableToCompleteException();
        }
        return methodToClassName;
    }

    private boolean writeUserMethod(TreeLogger logger, JMethod userMethod, SourceWriter sw, ConstantDefinitions constantDefinitions, Map<String, String> originalConstantNameMapping, Map<String, String> substitutionMap, Map<JMethod, String> methodToClassName) throws UnableToCompleteException {
        CssDefinitionNode definitionNode;
        String className = this.getClassName(userMethod);
        if (substitutionMap.containsKey(className) && this.isReturnTypeString(userMethod.getReturnType().isClass())) {
            methodToClassName.put(userMethod, substitutionMap.get(className));
            return this.writeClassMethod(logger, userMethod, substitutionMap, sw);
        }
        String methodName = userMethod.getName();
        if (originalConstantNameMapping.containsKey(methodName)) {
            String constantName = originalConstantNameMapping.get(methodName);
            definitionNode = constantDefinitions.getConstantDefinition(constantName);
        } else {
            definitionNode = constantDefinitions.getConstantDefinition(methodName);
            if (definitionNode == null) {
                definitionNode = constantDefinitions.getConstantDefinition(this.toUpperCase(methodName));
            }
        }
        if (definitionNode != null) {
            return this.writeDefMethod(definitionNode, logger, userMethod, sw);
        }
        if (substitutionMap.containsKey(className)) {
            logger.log(TreeLogger.Type.ERROR, "The return type of the method [" + userMethod.getName() + "] must " + "be java.lang.String.");
            throw new UnableToCompleteException();
        }
        logger.log(TreeLogger.Type.ERROR, "The following method [" + userMethod.getName() + "()] doesn't match a constant" + " nor a style class. You could fix that by adding ." + className + " {}");
        return false;
    }

    private String toUpperCase(String camelCase) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCase);
    }

    private Map<String, Map<String, String>> computeReplacements(JMethod method, TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        HashMap<String, Map<String, String>> replacementsWithPrefix = new HashMap<String, Map<String, String>>();
        replacementsWithPrefix.put("", this.computeReplacementsForType(method.getReturnType().isInterface()));
        CssResource.Import imp = (CssResource.Import)method.getAnnotation(CssResource.Import.class);
        if (imp != null) {
            boolean fail = false;
            TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
            for (Class<? extends CssResource> clazz : imp.value()) {
                JClassType importType = typeOracle.findType(clazz.getName().replace('$', '.'));
                assert (importType != null) : "TypeOracle does not have type " + clazz.getName();
                context.getRequirements().addTypeHierarchy(importType);
                String prefix = GssResourceGenerator.getImportPrefix(importType);
                if (replacementsWithPrefix.put(prefix, this.computeReplacementsForType(importType)) == null) continue;
                logger.log(TreeLogger.ERROR, "Multiple imports that would use the prefix " + prefix);
                fail = true;
            }
            if (fail) {
                throw new UnableToCompleteException();
            }
        }
        return replacementsWithPrefix;
    }

    private Map<String, String> computeReplacementsForType(JClassType cssResource) {
        Map<String, String> replacements = this.replacementsByClassAndMethod.get(cssResource);
        if (replacements == null) {
            replacements = new HashMap<String, String>();
            this.replacementsByClassAndMethod.put(cssResource, replacements);
            String resourcePrefix = resourcePrefixBuilder.get(cssResource.getQualifiedSourceName());
            PrefixingSubstitutionMap prefixingSubstitutionMap = new PrefixingSubstitutionMap((SubstitutionMap)new MinimalSubstitutionMap(), this.obfuscationPrefix + resourcePrefix + "-");
            for (JMethod method : cssResource.getOverridableMethods()) {
                if (method == this.getNameMethod || method == this.getTextMethod || method == this.ensuredInjectedMethod) continue;
                String styleClass = this.getClassName(method);
                if (this.replacementsForSharedMethods.containsKey(method)) {
                    replacements.put(styleClass, this.replacementsForSharedMethods.get(method));
                    continue;
                }
                String obfuscatedClassName = prefixingSubstitutionMap.get(styleClass);
                String replacement = this.obfuscationStyle.getPrettyName(styleClass, cssResource, obfuscatedClassName);
                if (this.hasSharedAnnotation(method)) {
                    replacement = this.obfuscationStyle.getPrettyName(styleClass, method.getEnclosingType(), obfuscatedClassName);
                    this.replacementsForSharedMethods.put(method, replacement);
                }
                replacements.put(styleClass, replacement);
            }
        }
        return replacements;
    }

    private boolean hasSharedAnnotation(JMethod method) {
        JClassType enclosingType = method.getEnclosingType();
        CssResource.Shared shared = (CssResource.Shared)enclosingType.getAnnotation(CssResource.Shared.class);
        return shared != null;
    }

    static {
        writtenAtDefs = new HashSet<String>();
        String varFileName = System.getProperty("emitGssVarNameFile");
        boolean bl = shouldEmitVariables = varFileName != null;
        if (shouldEmitVariables) {
            try {
                File file = new File(varFileName);
                file.createNewFile();
                printWriter = new PrintWriter(new FileOutputStream(file));
            }
            catch (Exception e) {
                System.err.println("Error while opening file");
                e.printStackTrace();
                System.exit(-1);
            }
        }
        resourcePrefixBuilder = new MinimalSubstitutionMap();
        BASE32_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', '0', '1', '2', '3', '4', '5', '6'};
        CHARSET = Pattern.compile("^@charset \"([^\"]*)\";");
        CHARSET_MIN_LENGTH = "@charset \"\";".length();
    }

    private static class ConfigurationPropertyMatcher
    implements Predicate<String> {
        private final PropertyOracle propertyOracle;
        private final TreeLogger logger;
        private boolean error;

        ConfigurationPropertyMatcher(ResourceContext context, TreeLogger logger) {
            this.logger = logger;
            this.propertyOracle = context.getGeneratorContext().getPropertyOracle();
        }

        @Override
        public boolean apply(String booleanCondition) {
            if (booleanCondition.startsWith("!")) {
                booleanCondition = booleanCondition.substring(1);
            }
            try {
                ConfigurationProperty property = this.propertyOracle.getConfigurationProperty(booleanCondition);
                boolean valid = GssResourceGenerator.checkPropertyIsSingleValueAndBoolean(property, this.logger);
                this.error |= !valid;
                return valid;
            }
            catch (BadPropertyValueException e) {
                return false;
            }
        }
    }

    private static class CssParsingResult {
        final CssTree tree;
        final List<String> permutationAxes;
        final Map<String, String> originalConstantNameMapping;
        final Set<String> trueConditions;

        private CssParsingResult(CssTree tree, List<String> permutationAxis, Set<String> trueConditions, Map<String, String> originalConstantNameMapping) {
            this.tree = tree;
            this.permutationAxes = permutationAxis;
            this.originalConstantNameMapping = originalConstantNameMapping;
            this.trueConditions = trueConditions;
        }
    }

    private static class RenamingResult {
        final Map<String, String> mapping;
        final Set<String> externalClassCandidate;

        private RenamingResult(Map<String, String> mapping, Set<String> externalClassCandidate) {
            this.mapping = mapping;
            this.externalClassCandidate = externalClassCandidate;
        }
    }

    private static class ConversionResult {
        final String gss;
        final Map<String, String> defNameMapping;

        private ConversionResult(String gss, Map<String, String> defNameMapping) {
            this.gss = gss;
            this.defNameMapping = defNameMapping;
        }
    }

    private static class LoggerErrorManager
    implements ErrorManager {
        private final TreeLogger logger;
        private boolean hasErrors;

        private LoggerErrorManager(TreeLogger logger) {
            this.logger = logger;
        }

        public void generateReport() {
        }

        public boolean hasErrors() {
            return this.hasErrors;
        }

        public void report(GssError error) {
            String fileName = "";
            String location = "";
            SourceCodeLocation codeLocation = error.getLocation();
            if (codeLocation != null) {
                fileName = codeLocation.getSourceCode().getFileName();
                location = "[line: " + codeLocation.getBeginLineNumber() + " column: " + codeLocation.getBeginIndexInLine() + "]";
            }
            this.logger.log(TreeLogger.Type.ERROR, "Error in " + fileName + location + ": " + error.getMessage());
            this.hasErrors = true;
        }

        public void reportWarning(GssError warning) {
            this.logger.log(TreeLogger.Type.WARN, warning.getMessage());
        }
    }

    public static enum AutoConversionMode {
        STRICT,
        LENIENT,
        OFF;

    }

    public static class GssOptions {
        private final boolean enabled;
        private final AutoConversionMode autoConversionMode;
        private final boolean gssDefaultInUiBinder;

        public GssOptions(boolean enabled, AutoConversionMode autoConversionMode, boolean gssDefaultInUiBinder) {
            this.enabled = enabled;
            this.autoConversionMode = autoConversionMode;
            this.gssDefaultInUiBinder = gssDefaultInUiBinder;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isGssDefaultInUiBinder() {
            return this.gssDefaultInUiBinder;
        }

        public boolean isAutoConversionOff() {
            return this.autoConversionMode == AutoConversionMode.OFF;
        }

        public boolean isLenientConversion() {
            return this.autoConversionMode == AutoConversionMode.LENIENT;
        }
    }
}

