/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ControlStructureCheck;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import java.util.Map;

public class DiagnosticGroups {
    private static final Map<String, DiagnosticGroup> groupsByName = Maps.newHashMap();
    static final String DIAGNOSTIC_GROUP_NAMES = "accessControls, ambiguousFunctionDecl, checkRegExp,checkTypes, checkVars, constantProperty, deprecated, es5Strict, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, invalidCasts, missingProperties, nonStandardJsDocs, strictModuleDepCheck, typeInvalidation, undefinedVars, unknownDefines, uselessCode, visibility";
    public static DiagnosticGroup GLOBAL_THIS = DiagnosticGroups.registerGroup("globalThis", CheckGlobalThis.GLOBAL_THIS);
    public static DiagnosticGroup DEPRECATED = DiagnosticGroups.registerGroup("deprecated", CheckAccessControls.DEPRECATED_NAME, CheckAccessControls.DEPRECATED_NAME_REASON, CheckAccessControls.DEPRECATED_PROP, CheckAccessControls.DEPRECATED_PROP_REASON, CheckAccessControls.DEPRECATED_CLASS, CheckAccessControls.DEPRECATED_CLASS_REASON);
    public static DiagnosticGroup VISIBILITY = DiagnosticGroups.registerGroup("visibility", CheckAccessControls.BAD_PRIVATE_GLOBAL_ACCESS, CheckAccessControls.BAD_PRIVATE_PROPERTY_ACCESS, CheckAccessControls.BAD_PROTECTED_PROPERTY_ACCESS, CheckAccessControls.PRIVATE_OVERRIDE, CheckAccessControls.VISIBILITY_MISMATCH);
    public static DiagnosticGroup CONSTANT_PROPERTY = DiagnosticGroups.registerGroup("constantProperty", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE);
    public static DiagnosticGroup NON_STANDARD_JSDOC = DiagnosticGroups.registerGroup("nonStandardJsDocs", RhinoErrorReporter.BAD_JSDOC_ANNOTATION);
    public static DiagnosticGroup ACCESS_CONTROLS = DiagnosticGroups.registerGroup("accessControls", DEPRECATED, VISIBILITY);
    public static DiagnosticGroup INVALID_CASTS = DiagnosticGroups.registerGroup("invalidCasts", TypeValidator.INVALID_CAST);
    public static DiagnosticGroup FILEOVERVIEW_JSDOC = DiagnosticGroups.registerGroup("fileoverviewTags", RhinoErrorReporter.EXTRA_FILEOVERVIEW);
    public static DiagnosticGroup STRICT_MODULE_DEP_CHECK = DiagnosticGroups.registerGroup("strictModuleDepCheck", VarCheck.STRICT_MODULE_DEP_ERROR, CheckGlobalNames.STRICT_MODULE_DEP_QNAME);
    public static DiagnosticGroup EXTERNS_VALIDATION = DiagnosticGroups.registerGroup("externsValidation", VarCheck.NAME_REFERENCE_IN_EXTERNS_ERROR, VarCheck.UNDEFINED_EXTERN_VAR_ERROR);
    public static DiagnosticGroup AMBIGUOUS_FUNCTION_DECL = DiagnosticGroups.registerGroup("ambiguousFunctionDecl", VariableReferenceCheck.AMBIGUOUS_FUNCTION_DECL);
    public static DiagnosticGroup UNKNOWN_DEFINES = DiagnosticGroups.registerGroup("unknownDefines", ProcessDefines.UNKNOWN_DEFINE_WARNING);
    public static DiagnosticGroup TWEAKS = DiagnosticGroups.registerGroup("tweakValidation", ProcessTweaks.INVALID_TWEAK_DEFAULT_VALUE_WARNING, ProcessTweaks.TWEAK_WRONG_GETTER_TYPE_WARNING, ProcessTweaks.UNKNOWN_TWEAK_WARNING);
    public static DiagnosticGroup MISSING_PROPERTIES = DiagnosticGroups.registerGroup("missingProperties", TypeCheck.INEXISTENT_PROPERTY);
    public static DiagnosticGroup INTERNET_EXPLORER_CHECKS = DiagnosticGroups.registerGroup("internetExplorerChecks", RhinoErrorReporter.TRAILING_COMMA);
    public static DiagnosticGroup UNDEFINED_VARIABLES = DiagnosticGroups.registerGroup("undefinedVars", VarCheck.UNDEFINED_VAR_ERROR);
    public static DiagnosticGroup CHECK_REGEXP = DiagnosticGroups.registerGroup("checkRegExp", CheckRegExp.REGEXP_REFERENCE, CheckRegExp.MALFORMED_REGEXP);
    public static DiagnosticGroup CHECK_TYPES = DiagnosticGroups.registerGroup("checkTypes", TypeValidator.ALL_DIAGNOSTICS, TypeCheck.ALL_DIAGNOSTICS);
    public static DiagnosticGroup CHECK_VARIABLES = DiagnosticGroups.registerGroup("checkVars", VarCheck.UNDEFINED_VAR_ERROR, SyntacticScopeCreator.VAR_MULTIPLY_DECLARED_ERROR);
    public static DiagnosticGroup CHECK_USELESS_CODE = DiagnosticGroups.registerGroup("uselessCode", CheckSideEffects.USELESS_CODE_ERROR, CheckUnreachableCode.UNREACHABLE_CODE);
    public static DiagnosticGroup CONST = DiagnosticGroups.registerGroup("const", CheckAccessControls.CONST_PROPERTY_DELETED, CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE, ConstCheck.CONST_REASSIGNED_VALUE_ERROR);
    public static DiagnosticGroup TYPE_INVALIDATION = DiagnosticGroups.registerGroup("typeInvalidation", DisambiguateProperties.Warnings.INVALIDATION);
    public static DiagnosticGroup DUPLICATE_VARS = DiagnosticGroups.registerGroup("duplicate", SyntacticScopeCreator.VAR_MULTIPLY_DECLARED_ERROR, TypeValidator.DUP_VAR_DECLARATION);
    public static DiagnosticGroup ES5_STRICT = DiagnosticGroups.registerGroup("es5Strict", ControlStructureCheck.USE_OF_WITH, StrictModeCheck.UNKNOWN_VARIABLE, StrictModeCheck.EVAL_DECLARATION, StrictModeCheck.EVAL_ASSIGNMENT, StrictModeCheck.ARGUMENTS_DECLARATION, StrictModeCheck.ARGUMENTS_ASSIGNMENT, StrictModeCheck.DELETE_VARIABLE, StrictModeCheck.DUPLICATE_OBJECT_KEY);

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup group) {
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticType ... types) {
        DiagnosticGroup group = new DiagnosticGroup(name, types);
        groupsByName.put(name, group);
        return group;
    }

    static DiagnosticGroup registerGroup(String name, DiagnosticGroup ... groups) {
        DiagnosticGroup group = new DiagnosticGroup(name, groups);
        groupsByName.put(name, group);
        return group;
    }

    protected Map<String, DiagnosticGroup> getRegisteredGroups() {
        return ImmutableMap.copyOf(groupsByName);
    }

    protected DiagnosticGroup forName(String name) {
        return groupsByName.get(name);
    }

    void setWarningLevel(CompilerOptions options, String name, CheckLevel level) {
        DiagnosticGroup group = this.forName(name);
        Preconditions.checkNotNull((Object)group, (Object)("No warning class for name: " + name));
        options.setWarningLevel(group, level);
    }
}

