/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

class ExploitAssigns
extends AbstractPeepholeOptimization {
    ExploitAssigns() {
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        Node child = subtree.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            if (NodeUtil.isExprAssign(child)) {
                this.collapseAssign(child.getFirstChild(), child, subtree);
            }
            child = next;
        }
        return subtree;
    }

    private void collapseAssign(Node assign, Node expr, Node exprParent) {
        Node leftValue = assign.getFirstChild();
        Node rightValue = leftValue.getNext();
        if (this.isCollapsibleValue(leftValue, true) && this.collapseAssignEqualTo(expr, exprParent, leftValue)) {
            this.reportCodeChange();
        } else if (this.isCollapsibleValue(rightValue, false) && this.collapseAssignEqualTo(expr, exprParent, rightValue)) {
            this.reportCodeChange();
        } else if (rightValue.getType() == 86) {
            this.collapseAssign(rightValue, expr, exprParent);
        }
    }

    private boolean isCollapsibleValue(Node value, boolean isLValue) {
        switch (value.getType()) {
            case 33: {
                return !isLValue || value.getFirstChild().getType() == 42;
            }
            case 38: {
                return true;
            }
        }
        return NodeUtil.isImmutableValue(value);
    }

    private boolean collapseAssignEqualTo(Node expr, Node exprParent, Node value) {
        Node assign = expr.getFirstChild();
        Node parent = exprParent;
        Node next = expr.getNext();
        block6: while (next != null) {
            switch (next.getType()) {
                case 4: 
                case 98: 
                case 100: 
                case 101: 
                case 108: 
                case 130: {
                    parent = next;
                    next = next.getFirstChild();
                    continue block6;
                }
                case 118: {
                    if (next.getFirstChild().hasChildren()) {
                        parent = next.getFirstChild();
                        next = parent.getFirstChild();
                        continue block6;
                    }
                    return false;
                }
                case 33: 
                case 38: {
                    if (next.isQualifiedName()) {
                        String nextName = next.getQualifiedName();
                        if (value.isQualifiedName() && nextName.equals(value.getQualifiedName())) {
                            if (!this.isSafeReplacement(next, assign)) {
                                return false;
                            }
                            exprParent.removeChild(expr);
                            expr.removeChild(assign);
                            parent.replaceChild(next, assign);
                            return true;
                        }
                    }
                    return false;
                }
                case 86: {
                    Node leftSide = next.getFirstChild();
                    if (leftSide.getType() == 38 || leftSide.getType() == 33 && leftSide.getFirstChild().getType() == 42) {
                        parent = next;
                        next = leftSide.getNext();
                        continue block6;
                    }
                    return false;
                }
            }
            if (NodeUtil.isImmutableValue(next) && next.isEquivalentTo(value)) {
                exprParent.removeChild(expr);
                expr.removeChild(assign);
                parent.replaceChild(next, assign);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isSafeReplacement(Node node, Node replacement) {
        if (node.getType() == 38) {
            return true;
        }
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        Node name = node.getFirstChild();
        return name.getType() != 38 || !this.isNameAssignedTo(name.getString(), replacement);
    }

    private boolean isNameAssignedTo(String name, Node node) {
        Node parent;
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            if (!this.isNameAssignedTo(name, c)) continue;
            return true;
        }
        return node.getType() == 38 && (parent = node.getParent()).getType() == 86 && parent.getFirstChild() == node && name.equals(node.getString());
    }
}

