/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.InlineCostEstimator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.Collection;
import java.util.List;

class FunctionRewriter
implements CompilerPass {
    private final AbstractCompiler compiler;
    private static final int SAVINGS_THRESHOLD = 16;

    FunctionRewriter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        ImmutableList reducers = ImmutableList.of((Object)new ReturnConstantReducer(), (Object)new GetterReducer(), (Object)new SetterReducer(), (Object)new EmptyFunctionReducer(), (Object)new IdentityReducer());
        HashMultimap reductionMap = HashMultimap.create();
        NodeTraversal.traverse(this.compiler, root, new ReductionGatherer((List<Reducer>)reducers, (Multimap<Reducer, Reduction>)reductionMap));
        for (Reducer reducer : reducers) {
            Node helperCode;
            Collection reductions = reductionMap.get((Object)reducer);
            if (reductions.isEmpty() || (helperCode = this.parseHelperCode(reducer)) == null) continue;
            int helperCodeCost = InlineCostEstimator.getCost(helperCode);
            int savings = 0;
            for (Reduction reduction : reductions) {
                savings += reduction.estimateSavings();
            }
            if (savings <= helperCodeCost + 16) continue;
            for (Reduction reduction : reductions) {
                reduction.apply();
            }
            Node addingRoot = this.compiler.getNodeForCodeInsertion(null);
            addingRoot.addChildrenToFront(helperCode);
            this.compiler.reportCodeChange();
        }
    }

    public Node parseHelperCode(Reducer reducer) {
        Node root = this.compiler.parseSyntheticCode(reducer.getClass().toString() + ":helper", reducer.getHelperSource());
        return root != null ? root.removeFirstChild() : null;
    }

    private static class SetterReducer
    extends Reducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_set";
        static final String HELPER_SOURCE = "function JSCompiler_set(JSCompiler_set_name) {  return function(JSCompiler_set_value) {this[JSCompiler_set_name] = JSCompiler_set_value}}";

        private SetterReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            Node propName = this.getSetPropertyName(node);
            if (propName != null) {
                if (propName.getType() != 40) {
                    throw new IllegalStateException("Expected STRING, got " + Token.name(propName.getType()));
                }
                return this.buildCallNode(FACTORY_METHOD_NAME, propName, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private Node getSetPropertyName(Node functionNode) {
            Node rhs;
            Node body = functionNode.getLastChild();
            if (!body.hasOneChild()) {
                return null;
            }
            Node argList = functionNode.getFirstChild().getNext();
            Node paramNode = argList.getFirstChild();
            if (paramNode == null) {
                return null;
            }
            Node statement = body.getFirstChild();
            if (!NodeUtil.isExprAssign(statement)) {
                return null;
            }
            Node assign = statement.getFirstChild();
            Node lhs = assign.getFirstChild();
            if (NodeUtil.isGetProp(lhs) && NodeUtil.isThis(lhs.getFirstChild()) && NodeUtil.isName(rhs = assign.getLastChild()) && rhs.getString().equals(paramNode.getString())) {
                Node propertyName = lhs.getLastChild();
                return propertyName;
            }
            return null;
        }
    }

    private static class GetterReducer
    extends SingleReturnStatementReducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_get";
        static final String HELPER_SOURCE = "function JSCompiler_get(JSCompiler_get_name) {  return function() {return this[JSCompiler_get_name]}}";

        private GetterReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            Node propName = this.getGetPropertyName(node);
            if (propName != null) {
                if (propName.getType() != 40) {
                    throw new IllegalStateException("Expected STRING, got " + Token.name(propName.getType()));
                }
                return this.buildCallNode(FACTORY_METHOD_NAME, propName, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private Node getGetPropertyName(Node functionNode) {
            Node value = this.maybeGetSingleReturnRValue(functionNode);
            if (value != null && NodeUtil.isGetProp(value) && NodeUtil.isThis(value.getFirstChild())) {
                return value.getLastChild();
            }
            return null;
        }
    }

    private static class ReturnConstantReducer
    extends SingleReturnStatementReducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_returnArg";
        static final String HELPER_SOURCE = "function JSCompiler_returnArg(JSCompiler_returnArg_value) {  return function() {return JSCompiler_returnArg_value}}";

        private ReturnConstantReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            Node valueNode = this.getValueNode(node);
            if (valueNode != null) {
                return this.buildCallNode(FACTORY_METHOD_NAME, valueNode, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private Node getValueNode(Node functionNode) {
            Node value = this.maybeGetSingleReturnRValue(functionNode);
            if (value != null && NodeUtil.isImmutableValue(value)) {
                return value;
            }
            return null;
        }
    }

    private static class IdentityReducer
    extends SingleReturnStatementReducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_identityFn";
        static final String HELPER_SOURCE = "function JSCompiler_identityFn() {  return function(JSCompiler_identityFn_value) {return JSCompiler_identityFn_value}}";

        private IdentityReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (!NodeUtil.isFunctionExpression(node)) {
                return node;
            }
            if (this.isIdentityFunction(node)) {
                return this.buildCallNode(FACTORY_METHOD_NAME, null, node.getLineno(), node.getCharno());
            }
            return node;
        }

        private boolean isIdentityFunction(Node functionNode) {
            Node argList = functionNode.getFirstChild().getNext();
            Node paramNode = argList.getFirstChild();
            if (paramNode == null) {
                return false;
            }
            Node value = this.maybeGetSingleReturnRValue(functionNode);
            return value != null && NodeUtil.isName(value) && value.getString().equals(paramNode.getString());
        }
    }

    static abstract class SingleReturnStatementReducer
    extends Reducer {
        SingleReturnStatementReducer() {
        }

        protected final Node maybeGetSingleReturnRValue(Node functionNode) {
            Node body = functionNode.getLastChild();
            if (!body.hasOneChild()) {
                return null;
            }
            Node statement = body.getFirstChild();
            if (statement.getType() == 4) {
                return statement.getFirstChild();
            }
            return null;
        }
    }

    private static class EmptyFunctionReducer
    extends Reducer {
        static final String FACTORY_METHOD_NAME = "JSCompiler_emptyFn";
        static final String HELPER_SOURCE = "function JSCompiler_emptyFn() {  return function() {}}";

        private EmptyFunctionReducer() {
        }

        @Override
        public String getHelperSource() {
            return HELPER_SOURCE;
        }

        @Override
        public Node reduce(Node node) {
            if (NodeUtil.isEmptyFunctionExpression(node)) {
                return this.buildCallNode(FACTORY_METHOD_NAME, null, node.getLineno(), node.getCharno());
            }
            return node;
        }
    }

    static abstract class Reducer {
        Reducer() {
        }

        abstract String getHelperSource();

        abstract Node reduce(Node var1);

        protected final Node buildCallNode(String methodName, Node argumentNode, int lineno, int charno) {
            Node call = new Node(37, lineno, charno);
            call.putBooleanProp(50, true);
            call.addChildToBack(Node.newString(38, methodName));
            if (argumentNode != null) {
                call.addChildToBack(argumentNode.cloneTree());
            }
            return call;
        }
    }

    private class ReductionGatherer
    implements NodeTraversal.Callback {
        private final List<Reducer> reducers;
        private final Multimap<Reducer, Reduction> reductions;

        ReductionGatherer(List<Reducer> reducers, Multimap<Reducer, Reduction> reductions) {
            this.reducers = reducers;
            this.reductions = reductions;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal raversal, Node node, Node parent) {
            for (Reducer reducer : this.reducers) {
                Node replacement = reducer.reduce(node);
                if (replacement == node) continue;
                this.reductions.put((Object)reducer, (Object)new Reduction(parent, node, replacement));
                return false;
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal traversal, Node node, Node parent) {
        }
    }

    private class Reduction {
        private final Node parent;
        private final Node oldChild;
        private final Node newChild;

        Reduction(Node parent, Node oldChild, Node newChild) {
            this.parent = parent;
            this.oldChild = oldChild;
            this.newChild = newChild;
        }

        void apply() {
            this.parent.replaceChild(this.oldChild, this.newChild);
            FunctionRewriter.this.compiler.reportCodeChange();
        }

        int estimateSavings() {
            return InlineCostEstimator.getCost(this.oldChild) - InlineCostEstimator.getCost(this.newChild);
        }
    }
}

