/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;

class OptimizeReturns
implements OptimizeCalls.CallGraphCompilerPass,
CompilerPass {
    private AbstractCompiler compiler;

    OptimizeReturns(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    @VisibleForTesting
    public void process(Node externs, Node root) {
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, root);
        this.process(externs, root, defFinder);
    }

    @Override
    public void process(Node externs, Node root, SimpleDefinitionFinder definitions) {
        ArrayList toOptimize = Lists.newArrayList();
        for (DefinitionSite defSite : definitions.getDefinitionSites()) {
            if (defSite.inExterns || this.callResultsMaybeUsed(definitions, defSite)) continue;
            toOptimize.add(defSite.definition.getRValue());
        }
        for (Node node : toOptimize) {
            this.rewriteReturns(definitions, node);
        }
    }

    private boolean callResultsMaybeUsed(SimpleDefinitionFinder defFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        Node rValue = definition.getRValue();
        if (rValue == null || !NodeUtil.isFunction(rValue)) {
            return true;
        }
        if (!SimpleDefinitionFinder.isSimpleFunctionDeclaration(rValue)) {
            return true;
        }
        if (!defFinder.canModifyDefinition(definition)) {
            return true;
        }
        Collection<UseSite> useSites = defFinder.getUseSites(definition);
        for (UseSite site : useSites) {
            Node useNodeParent = site.node.getParent();
            if (OptimizeReturns.isCall(site)) {
                Node callNode = useNodeParent;
                Preconditions.checkState((callNode.getType() == 37 ? 1 : 0) != 0);
                if (!OptimizeReturns.isValueUsed(callNode)) continue;
                return true;
            }
            if (NodeUtil.isVar(useNodeParent)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValueUsed(Node node) {
        Node parent = node.getParent();
        switch (parent.getType()) {
            case 130: {
                return false;
            }
            case 98: 
            case 100: 
            case 101: {
                return node == parent.getFirstChild() ? true : OptimizeReturns.isValueUsed(parent);
            }
            case 85: {
                return node == parent.getFirstChild() ? false : OptimizeReturns.isValueUsed(parent);
            }
            case 115: {
                if (NodeUtil.isForIn(parent)) {
                    return true;
                }
                return parent.getChildAtIndex(1) == node;
            }
        }
        return true;
    }

    private void rewriteReturns(final SimpleDefinitionFinder defFinder, Node fnNode) {
        Preconditions.checkState((boolean)NodeUtil.isFunction(fnNode));
        NodeUtil.visitPostOrder(fnNode.getLastChild(), new NodeUtil.Visitor(){

            @Override
            public void visit(Node node) {
                if (node.getType() == 4 && node.hasOneChild()) {
                    boolean keepValue = NodeUtil.mayHaveSideEffects(node.getFirstChild(), OptimizeReturns.this.compiler);
                    if (!keepValue) {
                        defFinder.removeReferences(node.getFirstChild());
                    }
                    Node result = node.removeFirstChild();
                    if (keepValue) {
                        node.getParent().addChildBefore(new Node(130, result).copyInformationFrom(result), node);
                    }
                    OptimizeReturns.this.compiler.reportCodeChange();
                }
            }
        }, new NodeUtil.MatchShallowStatement());
    }

    private static boolean isCall(UseSite site) {
        Node node = site.node;
        Node parent = node.getParent();
        return parent.getFirstChild() == node && NodeUtil.isCall(parent);
    }
}

