/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.logging.Logger;

class RemoveUnusedPrototypeProperties
implements SpecializationAwareCompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedPrototypeProperties.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;
    private final boolean anchorUnusedVars;
    private SpecializeModule.SpecializationState specializationState;

    RemoveUnusedPrototypeProperties(AbstractCompiler compiler, boolean canModifyExterns, boolean anchorUnusedVars) {
        this.compiler = compiler;
        this.canModifyExterns = canModifyExterns;
        this.anchorUnusedVars = anchorUnusedVars;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState state) {
        this.specializationState = state;
    }

    @Override
    public void process(Node externRoot, Node root) {
        AnalyzePrototypeProperties analyzer = new AnalyzePrototypeProperties(this.compiler, null, this.canModifyExterns, this.anchorUnusedVars);
        analyzer.process(externRoot, root);
        this.removeUnusedSymbols(analyzer.getAllNameInfo());
    }

    private void removeUnusedSymbols(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        boolean changed = false;
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (nameInfo.isReferenced()) continue;
            for (AnalyzePrototypeProperties.Symbol declaration : nameInfo.getDeclarations()) {
                boolean canRemove = false;
                if (this.specializationState == null) {
                    canRemove = true;
                } else {
                    Node specializableFunction = this.getSpecializableFunctionFromSymbol(declaration);
                    if (specializableFunction != null) {
                        this.specializationState.reportRemovedFunction(specializableFunction, null);
                        canRemove = true;
                    }
                }
                if (!canRemove) continue;
                declaration.remove();
                changed = true;
            }
            logger.fine("Removed unused prototype property: " + nameInfo.name);
        }
        if (changed) {
            this.compiler.reportCodeChange();
        }
    }

    private Node getSpecializableFunctionFromSymbol(AnalyzePrototypeProperties.Symbol symbol) {
        Preconditions.checkNotNull((Object)this.specializationState);
        Node specializableFunction = null;
        if (symbol instanceof AnalyzePrototypeProperties.GlobalFunction) {
            specializableFunction = ((AnalyzePrototypeProperties.GlobalFunction)symbol).getFunctionNode();
        } else if (symbol instanceof AnalyzePrototypeProperties.AssignmentProperty) {
            Node propertyValue = ((AnalyzePrototypeProperties.AssignmentProperty)symbol).getValue();
            if (NodeUtil.isFunction(propertyValue)) {
                specializableFunction = propertyValue;
            }
        } else {
            if (symbol instanceof AnalyzePrototypeProperties.LiteralProperty) {
                return null;
            }
            Preconditions.checkState((boolean)false, (Object)"Should be unreachable.");
        }
        if (specializableFunction != null && this.specializationState.canFixupFunction(specializableFunction)) {
            return specializableFunction;
        }
        return null;
    }
}

