/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.FunctionNode;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JavaScriptException;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjArray;
import com.google.javascript.rhino.Parser;
import com.google.javascript.rhino.ScriptOrFnNode;
import com.google.javascript.rhino.ScriptRuntime;

final class IRFactory {
    private Parser parser;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(132);
    }

    void initScript(ScriptOrFnNode scriptNode, Node body) {
        Node children = body.removeChildren();
        if (children != null) {
            scriptNode.addChildrenToBack(children);
        }
    }

    Node createLeaf(int nodeType) {
        return new Node(nodeType);
    }

    Node createLeaf(int nodeType, int lineno, int charno) {
        return new Node(nodeType, lineno, charno);
    }

    Node createSwitch(int lineno, int charno) {
        return new Node(110, lineno, charno);
    }

    void addSwitchCase(Node switchNode, Node caseExpression, Node statements, int lineno, int charno) {
        if (switchNode.getType() != 110) {
            throw Kit.codeBug();
        }
        Node caseNode = caseExpression != null ? new Node(111, caseExpression, lineno, charno) : new Node(112, lineno, charno);
        caseNode.addChildToBack(statements);
        switchNode.addChildToBack(caseNode);
    }

    void closeSwitch(Node switchBlock) {
    }

    Node createVariables(int token, int lineno, int charno) {
        return new Node(token, lineno, charno);
    }

    Node createExprStatement(Node expr, int lineno, int charno) {
        int type = this.parser.insideFunction() ? 129 : 130;
        return new Node(type, expr, lineno, charno);
    }

    Node createExprStatementNoReturn(Node expr, int lineno, int charno) {
        return new Node(129, expr, lineno, charno);
    }

    Node createDefaultNamespace(Node expr, int lineno, int charno) {
        this.setRequiresActivation();
        Node n = this.createUnary(70, expr, lineno, charno);
        Node result = this.createExprStatement(n, lineno, charno);
        return result;
    }

    public Node createErrorName() {
        return Node.newString(38, "error");
    }

    Node createName(String name, int lineno, int charno) {
        this.checkActivationName(name, 38);
        return Node.newString(38, name, lineno, charno);
    }

    public Node createTaggedName(String name, JSDocInfo info, int lineno, int charno) {
        Node n = this.createName(name, lineno, charno);
        if (info != null) {
            n.setJSDocInfo(info);
        }
        return n;
    }

    Node createString(String string) {
        return Node.newString(string);
    }

    Node createString(String string, int lineno, int charno) {
        return Node.newString(string, lineno, charno);
    }

    Node createNumber(double number) {
        return Node.newNumber(number);
    }

    Node createNumber(double number, int lineno, int charno) {
        return Node.newNumber(number, lineno, charno);
    }

    Node createCatch(String varName, int nameLineno, int nameCharno, Node catchCond, Node stmts, int catchLineno, int catchCharno) {
        if (catchCond == null) {
            catchCond = new Node(124, nameLineno, nameCharno);
        }
        return new Node(120, this.createName(varName, nameLineno, nameCharno), catchCond, stmts, catchLineno, catchCharno);
    }

    Node createThrow(Node expr, int lineno, int charno) {
        return new Node(49, expr, lineno, charno);
    }

    Node createReturn(Node expr, int lineno, int charno) {
        return expr == null ? new Node(4, lineno, charno) : new Node(4, expr, lineno, charno);
    }

    Node createLabel(String name, int lineno, int charno) {
        return new Node(126, Node.newString(38, name, lineno, charno), lineno, charno);
    }

    Node createBreak(String label, int lineno, int charno) {
        Node result = new Node(116, lineno, charno);
        if (label == null) {
            return result;
        }
        Node name = Node.newString(38, label, lineno, charno);
        result.addChildToBack(name);
        return result;
    }

    Node createContinue(String label, int lineno, int charno) {
        Node result = new Node(117, lineno, charno);
        if (label == null) {
            return result;
        }
        Node name = Node.newString(38, label, lineno, charno);
        result.addChildToBack(name);
        return result;
    }

    Node createDebugger(int lineno, int charno) {
        return new Node(152, lineno, charno);
    }

    Node createBlock(int lineno, int charno) {
        return new Node(125, lineno, charno);
    }

    FunctionNode createFunction(String name, int lineno, int charno) {
        FunctionNode fnNode = new FunctionNode(name, lineno, charno);
        fnNode.addChildToBack(this.createName(name, lineno, charno));
        return fnNode;
    }

    Node initFunction(FunctionNode fnNode, int functionIndex, Node args, JSDocInfo info, Node statements, int functionType) {
        int functionCount;
        fnNode.itsFunctionType = functionType;
        fnNode.addChildToBack(args);
        fnNode.addChildToBack(statements);
        if (this.parser.getSourceName() != null) {
            fnNode.putProp(16, this.parser.getSourceName());
        }
        if (info != null) {
            fnNode.setJSDocInfo(info);
        }
        if ((functionCount = fnNode.getFunctionCount()) != 0) {
            fnNode.itsNeedsActivation = true;
            for (int i = 0; i != functionCount; ++i) {
                String name;
                FunctionNode fn = fnNode.getFunctionNode(i);
                if (fn.getFunctionType() != 3 || (name = fn.getFunctionName()) == null || name.length() == 0) continue;
                fnNode.removeParamOrVar(name);
            }
        }
        fnNode.putIntProp(5, functionIndex);
        return fnNode;
    }

    void addChildToBack(Node parent, Node child) {
        parent.addChildToBack(child);
    }

    Node createWhile(Node cond, Node body, int lineno, int charno) {
        return new Node(113, cond, body, lineno, charno);
    }

    Node createDoWhile(Node body, Node cond, int lineno, int charno) {
        return new Node(114, body, cond, lineno, charno);
    }

    Node createFor(Node init, Node test, Node incr, Node body, int lineno, int charno) {
        return new Node(115, init, test, incr, body, lineno, charno);
    }

    Node createForIn(Node lhs, Node obj, Node body, int lineno, int charno) {
        return new Node(115, lhs, obj, body, lineno, charno);
    }

    Node createTryCatchFinally(Node tryBlock, Node catchBlocks, Node finallyBlock, int lineno, int charno) {
        if (finallyBlock == null) {
            return new Node(77, tryBlock, catchBlocks, lineno, charno);
        }
        return new Node(77, tryBlock, catchBlocks, finallyBlock, lineno, charno);
    }

    Node createWith(Node obj, Node body, int lineno, int charno) {
        return new Node(119, obj, body, lineno, charno);
    }

    public Node createDotQuery(Node obj, Node body, int lineno, int charno) {
        this.setRequiresActivation();
        Node result = new Node(142, obj, body, lineno, charno);
        return result;
    }

    Node createArrayLiteral(ObjArray elems, int skipCount, int lineno, int charno) {
        int length = elems.size();
        int[] skipIndexes = null;
        if (skipCount != 0) {
            skipIndexes = new int[skipCount];
        }
        Node array = new Node(63, lineno, charno);
        int j = 0;
        for (int i = 0; i != length; ++i) {
            Node elem = (Node)elems.get(i);
            if (elem != null) {
                array.addChildToBack(elem);
                continue;
            }
            skipIndexes[j] = i;
            ++j;
        }
        if (skipCount != 0) {
            array.putProp(31, skipIndexes);
        }
        return array;
    }

    Node createObjectLiteral(ObjArray obj, int lineno, int charno) {
        Node object = new Node(64, lineno, charno);
        for (int i = 0; i < obj.size(); i += 2) {
            Node n = (Node)obj.get(i);
            object.addChildToBack(n);
            n = (Node)obj.get(i + 1);
            object.addChildToBack(n);
        }
        return object;
    }

    Node createRegExp(String string, String flags, int lineno, int charno) {
        return flags.length() == 0 ? new Node(47, Node.newString(string, lineno, charno), lineno, charno) : new Node(47, Node.newString(string, lineno, charno), Node.newString(flags, lineno, charno), lineno, charno);
    }

    Node createIf(Node cond, Node ifTrue, Node ifFalse, int lineno, int charno) {
        if (ifFalse == null) {
            return new Node(108, cond, ifTrue, lineno, charno);
        }
        return new Node(108, cond, ifTrue, ifFalse, lineno, charno);
    }

    Node createCondExpr(Node cond, Node ifTrue, Node ifFalse, int lineno, int charno) {
        return new Node(98, cond, ifTrue, ifFalse, lineno, charno);
    }

    Node createUnary(int nodeType, Node child, int lineno, int charno) {
        return new Node(nodeType, child, lineno, charno);
    }

    Node createCallOrNew(int nodeType, Node child, int lineno, int charno) {
        String name;
        int type = 0;
        if (child.getType() == 38) {
            name = child.getString();
            if (name.equals("eval")) {
                type = 1;
            } else if (name.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 33 && (name = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        Node node = new Node(nodeType, child, lineno, charno);
        if (type != 0) {
            this.setRequiresActivation();
            node.putIntProp(27, type);
        }
        return node;
    }

    Node createIncDec(int nodeType, boolean post, Node child, int lineno, int charno) {
        if ((child = this.makeReference(child)) == null) {
            String msg = nodeType == 103 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(msg);
            return null;
        }
        int childType = child.getType();
        switch (childType) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 65: {
                Node n = new Node(nodeType, child, lineno, charno);
                n.putIntProp(32, post ? 1 : 0);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    Node createPropertyGet(Node target, String namespace, String name, int memberTypeFlags, int dotLineno, int dotCharno, int nameLineno, int nameCharno) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                return this.createName(name, nameLineno, nameCharno);
            }
            this.checkActivationName(name, 33);
            if (ScriptRuntime.isSpecialProperty(name)) {
                Node ref = new Node(69, target);
                ref.putProp(34, name);
                return new Node(65, ref, dotLineno, dotCharno);
            }
            return new Node(33, target, this.createString(name, nameLineno, nameCharno), dotLineno, dotCharno);
        }
        Node elem = this.createString(name);
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags |= 1, dotLineno, dotCharno);
    }

    Node createElementGet(Node target, String namespace, Node elem, int memberTypeFlags, int lineno, int charno) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                throw Kit.codeBug();
            }
            return new Node(35, target, elem, lineno, charno);
        }
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags, lineno, charno);
    }

    private Node createMemberRefGet(Node target, String namespace, Node elem, int memberTypeFlags, int lineno, int charno) {
        Node nsNode = null;
        if (namespace != null) {
            nsNode = namespace.equals("*") ? new Node(41, lineno, charno) : this.createName(namespace, lineno, charno);
        }
        Node ref = target == null ? (namespace == null ? new Node(75, elem, lineno, charno) : new Node(76, nsNode, elem, lineno, charno)) : (namespace == null ? new Node(73, target, elem, lineno, charno) : new Node(74, target, nsNode, elem, lineno, charno));
        if (memberTypeFlags != 0) {
            ref.putIntProp(33, memberTypeFlags);
        }
        return new Node(65, ref, lineno, charno);
    }

    Node createBinary(int nodeType, Node left, Node right, int lineno, int charno) {
        switch (nodeType) {
            case 104: {
                nodeType = 33;
                Node idNode = right;
                idNode.setType(40);
                break;
            }
            case 79: {
                nodeType = 35;
            }
        }
        return new Node(nodeType, left, right, lineno, charno);
    }

    Node createAssignment(int nodeOp, Node left, Node right, int lineno, int charno) throws JavaScriptException {
        int nodeType = left.getType();
        switch (nodeType) {
            case 33: 
            case 35: 
            case 38: {
                break;
            }
            default: {
                this.parser.reportError("msg.bad.assign.left");
            }
        }
        return new Node(86, left, right, lineno, charno);
    }

    private Node makeReference(Node node) {
        int type = node.getType();
        switch (type) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 65: {
                return node;
            }
        }
        return null;
    }

    private void checkActivationName(String name, int token) {
        if (this.parser.insideFunction()) {
            boolean activation = false;
            if ("arguments".equals(name) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.containsKey(name)) {
                activation = true;
            } else if ("length".equals(name) && token == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                activation = true;
            }
            if (activation) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }
}

