/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstChangeProxy;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.GatherSideEffectSubexpressionsCallback;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class NameAnalyzer
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final Map<String, JsName> allNames = Maps.newTreeMap();
    private DiGraph<JsName, RefType> referenceGraph = LinkedDirectedGraph.createWithoutAnnotations();
    private final Map<Node, NameInformation> scopes = Maps.newHashMap();
    private static final String PROTOTYPE_SUBSTRING = ".prototype.";
    private static final int PROTOTYPE_SUBSTRING_LEN = ".prototype.".length();
    private static final int PROTOTYPE_SUFFIX_LEN = ".prototype".length();
    private static final String WINDOW = "window";
    private static final String FUNCTION = "Function";
    static final Set<String> DEFAULT_GLOBAL_NAMES = ImmutableSet.of((Object)"window", (Object)"goog.global");
    private final boolean removeUnreferenced;
    private final Set<String> globalNames;
    private final AstChangeProxy changeProxy;
    private final Set<String> externalNames = Sets.newHashSet();
    private final List<RefNode> refNodes = Lists.newArrayList();
    private final Map<String, AliasSet> aliases = Maps.newHashMap();
    private static final Predicate<Node> NON_LOCAL_RESULT_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return !input.isCall();
        }
    };

    NameAnalyzer(AbstractCompiler compiler, boolean removeUnreferenced) {
        this.compiler = compiler;
        this.removeUnreferenced = removeUnreferenced;
        this.globalNames = DEFAULT_GLOBAL_NAMES;
        this.changeProxy = new AstChangeProxy();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, new ProcessExternals());
        NodeTraversal.traverse(this.compiler, root, new FindDependencyScopes());
        NodeTraversal.traverse(this.compiler, root, new HoistVariableAndFunctionDeclarations());
        NodeTraversal.traverse(this.compiler, root, new FindDeclarationsAndSetters());
        NodeTraversal.traverse(this.compiler, root, new FindReferences());
        this.referenceParentNames();
        this.referenceAliases();
        this.calculateReferences();
        if (this.removeUnreferenced) {
            this.removeUnreferenced();
        }
    }

    private void recordAlias(String fromName, String toName) {
        this.recordReference(fromName, toName, RefType.REGULAR);
        AliasSet toNameAliasSet = this.aliases.get(toName);
        AliasSet fromNameAliasSet = this.aliases.get(fromName);
        AliasSet resultSet = null;
        if (toNameAliasSet == null && fromNameAliasSet == null) {
            resultSet = new AliasSet(toName, fromName);
        } else if (toNameAliasSet != null && fromNameAliasSet != null) {
            resultSet = toNameAliasSet;
            resultSet.names.addAll(fromNameAliasSet.names);
            for (String name : fromNameAliasSet.names) {
                this.aliases.put(name, resultSet);
            }
        } else if (toNameAliasSet != null) {
            resultSet = toNameAliasSet;
            resultSet.names.add(fromName);
        } else {
            resultSet = fromNameAliasSet;
            resultSet.names.add(toName);
        }
        this.aliases.put(fromName, resultSet);
        this.aliases.put(toName, resultSet);
    }

    private void recordReference(String fromName, String toName, RefType depType) {
        if (fromName.equals(toName)) {
            return;
        }
        JsName from = this.getName(fromName, true);
        JsName to = this.getName(toName, true);
        this.referenceGraph.createNode(from);
        this.referenceGraph.createNode(to);
        if (!this.referenceGraph.isConnectedInDirection(from, depType, to)) {
            this.referenceGraph.connect(from, depType, to);
        }
    }

    void removeUnreferenced() {
        RemoveListener listener = new RemoveListener();
        this.changeProxy.registerListener(listener);
        for (RefNode refNode : this.refNodes) {
            JsName name = refNode.name();
            if (name.referenced || name.externallyDefined) continue;
            refNode.remove();
        }
        this.changeProxy.unregisterListener(listener);
    }

    String getHtmlReport() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><style type=\"text/css\">body, td, p {font-family: Arial; font-size: 83%} ul {margin-top:2px; margin-left:0px; padding-left:1em;} li {margin-top:3px; margin-left:24px; padding-left:0px;padding-bottom: 4px}</style>");
        sb.append("OVERALL STATS<ul>");
        this.appendListItem(sb, "Total Names: " + this.countOf(TriState.BOTH, TriState.BOTH));
        this.appendListItem(sb, "Total Classes: " + this.countOf(TriState.TRUE, TriState.BOTH));
        this.appendListItem(sb, "Total Static Functions: " + this.countOf(TriState.FALSE, TriState.BOTH));
        this.appendListItem(sb, "Referenced Names: " + this.countOf(TriState.BOTH, TriState.TRUE));
        this.appendListItem(sb, "Referenced Classes: " + this.countOf(TriState.TRUE, TriState.TRUE));
        this.appendListItem(sb, "Referenced Functions: " + this.countOf(TriState.FALSE, TriState.TRUE));
        sb.append("</ul>");
        sb.append("ALL NAMES<ul>\n");
        for (JsName node : this.allNames.values()) {
            sb.append("<li>" + this.nameAnchor(node.name) + "<ul>");
            if (node.prototypeNames.size() > 0) {
                sb.append("<li>PROTOTYPES: ");
                Iterator<String> protoIter = node.prototypeNames.iterator();
                while (protoIter.hasNext()) {
                    sb.append(protoIter.next());
                    if (!protoIter.hasNext()) continue;
                    sb.append(", ");
                }
            }
            if (this.referenceGraph.hasNode(node)) {
                List<DiGraph.DiGraphEdge<JsName, RefType>> referencedBy;
                List<DiGraph.DiGraphEdge<JsName, RefType>> refersTo = this.referenceGraph.getOutEdges(node);
                if (refersTo.size() > 0) {
                    sb.append("<li>REFERS TO: ");
                    Iterator<DiGraph.DiGraphEdge<JsName, RefType>> toIter = refersTo.iterator();
                    while (toIter.hasNext()) {
                        sb.append(this.nameLink(((JsName)toIter.next().getDestination().getValue()).name));
                        if (!toIter.hasNext()) continue;
                        sb.append(", ");
                    }
                }
                if ((referencedBy = this.referenceGraph.getInEdges(node)).size() > 0) {
                    sb.append("<li>REFERENCED BY: ");
                    Iterator<DiGraph.DiGraphEdge<JsName, RefType>> fromIter = refersTo.iterator();
                    while (fromIter.hasNext()) {
                        sb.append(this.nameLink(((JsName)fromIter.next().getDestination().getValue()).name));
                        if (!fromIter.hasNext()) continue;
                        sb.append(", ");
                    }
                }
            }
            sb.append("</li>");
            sb.append("</ul></li>");
        }
        sb.append("</ul>");
        sb.append("</body></html>");
        return sb.toString();
    }

    private void appendListItem(StringBuilder sb, String text) {
        sb.append("<li>" + text + "</li>\n");
    }

    private String nameLink(String name) {
        return "<a href=\"#" + name + "\">" + name + "</a>";
    }

    private String nameAnchor(String name) {
        return "<a name=\"" + name + "\">" + name + "</a>";
    }

    private JsName getName(String name, boolean canCreate) {
        if (canCreate) {
            this.createName(name);
        }
        return this.allNames.get(name);
    }

    private void createName(String name) {
        JsName jsn = this.allNames.get(name);
        if (jsn == null) {
            jsn = new JsName();
            jsn.name = name;
            this.allNames.put(name, jsn);
        }
    }

    private void referenceAliases() {
        for (Map.Entry<String, AliasSet> entry : this.aliases.entrySet()) {
            JsName name = this.getName(entry.getKey(), false);
            if (!name.hasWrittenDescendants && !name.hasInstanceOfReference) continue;
            for (String alias : entry.getValue().names) {
                this.recordReference(alias, entry.getKey(), RefType.REGULAR);
            }
        }
    }

    private void referenceParentNames() {
        HashSet allNamesCopy = Sets.newHashSet(this.allNames.values());
        for (JsName name : allNamesCopy) {
            String curName = name.name;
            JsName curJsName = name;
            while (curName.indexOf(46) != -1) {
                String parentName = curName.substring(0, curName.lastIndexOf(46));
                if (!this.globalNames.contains(parentName)) {
                    JsName parentJsName = this.getName(parentName, true);
                    this.recordReference(curJsName.name, parentJsName.name, RefType.REGULAR);
                    this.recordReference(parentJsName.name, curJsName.name, RefType.REGULAR);
                    curJsName = parentJsName;
                }
                curName = parentName;
            }
        }
    }

    private NameInformation createNameInformation(NodeTraversal t, Node n, Node parent) {
        boolean bNameWasShortened;
        Node rootNameNode;
        String name;
        block16: {
            name = "";
            rootNameNode = n;
            bNameWasShortened = false;
            while (true) {
                if (NodeUtil.isGet(rootNameNode)) {
                    Node prop = rootNameNode.getLastChild();
                    if (rootNameNode.isGetProp()) {
                        name = "." + prop.getString() + name;
                    } else {
                        bNameWasShortened = true;
                        name = "";
                    }
                    rootNameNode = rootNameNode.getFirstChild();
                    continue;
                }
                if (!NodeUtil.isObjectLitKey(rootNameNode, rootNameNode.getParent())) break block16;
                name = "." + rootNameNode.getString() + name;
                Node objLit = rootNameNode.getParent();
                Node objLitParent = objLit.getParent();
                if (objLitParent.isAssign()) {
                    rootNameNode = objLitParent.getFirstChild();
                    continue;
                }
                if (objLitParent.isName()) {
                    rootNameNode = objLitParent;
                    continue;
                }
                if (!objLitParent.isString()) break;
                rootNameNode = objLitParent;
            }
            return null;
        }
        if (parent.isCall() && t.inGlobalScope()) {
            CodingConvention convention = this.compiler.getCodingConvention();
            CodingConvention.SubclassRelationship classes = convention.getClassesDefinedByCall(parent);
            if (classes != null) {
                NameInformation nameInfo = new NameInformation();
                nameInfo.name = classes.subclassName;
                nameInfo.onlyAffectsClassDef = true;
                nameInfo.superclass = classes.superclassName;
                return nameInfo;
            }
            String singletonGetterClass = convention.getSingletonGetterClassName(parent);
            if (singletonGetterClass != null) {
                NameInformation nameInfo = new NameInformation();
                nameInfo.name = singletonGetterClass;
                nameInfo.onlyAffectsClassDef = true;
                return nameInfo;
            }
        }
        switch (rootNameNode.getType()) {
            case 38: {
                NameInformation nameInfo;
                if (!bNameWasShortened && n.isGetProp() && parent.isAssign() && "prototype".equals(n.getLastChild().getString())) {
                    if (this.createNameInformation(t, n.getFirstChild(), n) != null) {
                        name = rootNameNode.getString() + name;
                        name = name.substring(0, name.length() - PROTOTYPE_SUFFIX_LEN);
                        nameInfo = new NameInformation();
                        nameInfo.name = name;
                        return nameInfo;
                    }
                    return null;
                }
                return this.createNameInformation(rootNameNode.getString() + name, t.getScope(), rootNameNode);
            }
            case 42: {
                NameInformation nameInfo;
                if (t.inGlobalScope()) {
                    nameInfo = new NameInformation();
                    nameInfo.name = name.indexOf(46) == 0 ? name.substring(1) : name;
                    nameInfo.isExternallyReferenceable = true;
                    return nameInfo;
                }
                return null;
            }
        }
        return null;
    }

    private NameInformation createNameInformation(String name, Scope scope, Node rootNameNode) {
        boolean isGlobalRef;
        String rootName = rootNameNode.getString();
        Scope.Var v = scope.getVar(rootName);
        boolean isExtern = v == null && this.externalNames.contains(rootName);
        boolean bl = isGlobalRef = v != null && v.isGlobal() || isExtern || rootName.equals(WINDOW);
        if (!isGlobalRef) {
            return null;
        }
        NameInformation nameInfo = new NameInformation();
        int idx = name.indexOf(PROTOTYPE_SUBSTRING);
        if (idx != -1) {
            nameInfo.isPrototype = true;
            nameInfo.prototypeClass = name.substring(0, idx);
            nameInfo.prototypeProperty = name.substring(idx + PROTOTYPE_SUBSTRING_LEN);
        }
        nameInfo.name = name;
        nameInfo.isExternallyReferenceable = isExtern || this.isExternallyReferenceable(scope, name);
        return nameInfo;
    }

    private boolean isExternallyReferenceable(Scope scope, String name) {
        if (this.compiler.getCodingConvention().isExported(name)) {
            return true;
        }
        if (scope.isLocal()) {
            return false;
        }
        for (String s : this.globalNames) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private NameInformation getDependencyScope(Node n) {
        for (Node node : n.getAncestors()) {
            NameInformation ref = this.scopes.get(node);
            if (ref == null) continue;
            return ref;
        }
        return null;
    }

    private NameInformation getEnclosingFunctionDependencyScope(NodeTraversal t) {
        Node function = t.getEnclosingFunction();
        if (function == null) {
            return null;
        }
        NameInformation ref = this.scopes.get(function);
        if (ref != null) {
            return ref;
        }
        Node parent = function.getParent();
        if (parent != null) {
            while (parent.isHook()) {
                parent = parent.getParent();
            }
            if (parent.isName()) {
                return this.scopes.get(parent);
            }
            if (parent.isAssign()) {
                return this.scopes.get(parent);
            }
        }
        return null;
    }

    private void calculateReferences() {
        JsName window = this.getName(WINDOW, true);
        window.referenced = true;
        JsName function = this.getName(FUNCTION, true);
        function.referenced = true;
        FixedPointGraphTraversal.newTraversal(new ReferencePropagationCallback()).computeFixedPoint(this.referenceGraph);
    }

    private int countOf(TriState isClass, TriState referenced) {
        int count = 0;
        for (JsName name : this.allNames.values()) {
            boolean referenceMatch;
            boolean nodeIsClass = name.prototypeNames.size() > 0;
            boolean classMatch = isClass == TriState.BOTH || nodeIsClass && isClass == TriState.TRUE || !nodeIsClass && isClass == TriState.FALSE;
            boolean bl = referenceMatch = referenced == TriState.BOTH || name.referenced && referenced == TriState.TRUE || !name.referenced && referenced == TriState.FALSE;
            if (!classMatch || !referenceMatch || name.externallyDefined) continue;
            ++count;
        }
        return count;
    }

    private List<Node> getSideEffectNodes(Node n) {
        ArrayList subexpressions = Lists.newArrayList();
        NodeTraversal.traverse(this.compiler, n, new GatherSideEffectSubexpressionsCallback(this.compiler, new GatherSideEffectSubexpressionsCallback.CopySideEffectSubexpressions(this.compiler, subexpressions)));
        ArrayList replacements = Lists.newArrayListWithExpectedSize((int)subexpressions.size());
        for (Node subexpression : subexpressions) {
            replacements.add(NodeUtil.newExpr(subexpression));
        }
        return replacements;
    }

    private void replaceWithRhs(Node parent, Node n) {
        if (this.valueConsumedByParent(n, parent)) {
            List<Node> replacements = this.getRhsSubexpressions(n);
            ArrayList newReplacements = Lists.newArrayList();
            for (int i = 0; i < replacements.size() - 1; ++i) {
                newReplacements.addAll(this.getSideEffectNodes(replacements.get(i)));
            }
            Node valueExpr = replacements.get(replacements.size() - 1);
            valueExpr.detachFromParent();
            newReplacements.add(valueExpr);
            this.changeProxy.replaceWith(parent, n, this.collapseReplacements(newReplacements));
        } else if (n.isAssign() && !parent.isFor()) {
            Node replacement = n.getLastChild();
            replacement.detachFromParent();
            this.changeProxy.replaceWith(parent, n, replacement);
        } else {
            this.replaceTopLevelExpressionWithRhs(parent, n);
        }
    }

    private void replaceTopLevelExpressionWithRhs(Node parent, Node n) {
        switch (parent.getType()) {
            case 115: 
            case 125: 
            case 126: 
            case 132: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parent node type in replaceWithRhs " + Token.name(parent.getType()));
            }
        }
        switch (n.getType()) {
            case 105: 
            case 118: 
            case 130: {
                break;
            }
            case 86: {
                Preconditions.checkArgument((boolean)parent.isFor(), (String)"Unsupported assignment in replaceWithRhs. parent: %s", (Object[])new Object[]{Token.name(parent.getType())});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in replaceWithRhs " + Token.name(n.getType()));
            }
        }
        ArrayList replacements = Lists.newArrayList();
        for (Node rhs : this.getRhsSubexpressions(n)) {
            replacements.addAll(this.getSideEffectNodes(rhs));
        }
        if (parent.isFor()) {
            if (replacements.isEmpty()) {
                replacements.add(IR.empty());
            } else {
                Node expr = this.collapseReplacements(replacements);
                replacements.clear();
                replacements.add(expr);
            }
        }
        this.changeProxy.replaceWith(parent, n, replacements);
    }

    private boolean valueConsumedByParent(Node n, Node parent) {
        if (NodeUtil.isAssignmentOp(parent)) {
            return parent.getLastChild() == n;
        }
        switch (parent.getType()) {
            case 4: 
            case 38: {
                return true;
            }
            case 98: 
            case 100: 
            case 101: {
                return parent.getFirstChild() == n;
            }
            case 115: {
                return parent.getFirstChild().getNext() == n;
            }
            case 108: 
            case 113: {
                return parent.getFirstChild() == n;
            }
            case 114: {
                return parent.getLastChild() == n;
            }
        }
        return false;
    }

    private Node collapseReplacements(List<Node> replacements) {
        Node expr = null;
        for (Node rep : replacements) {
            if (rep.isExprResult()) {
                rep = rep.getFirstChild();
                rep.detachFromParent();
            }
            if (expr == null) {
                expr = rep;
                continue;
            }
            expr = IR.comma(expr, rep);
        }
        return expr;
    }

    private List<Node> getRhsSubexpressions(Node n) {
        switch (n.getType()) {
            case 130: {
                return this.getRhsSubexpressions(n.getFirstChild());
            }
            case 105: {
                return Collections.emptyList();
            }
            case 38: {
                Node rhs = n.getFirstChild();
                if (rhs != null) {
                    return Lists.newArrayList((Object[])new Node[]{rhs});
                }
                return Collections.emptyList();
            }
            case 86: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                return Lists.newArrayList((Object[])new Node[]{lhs, rhs});
            }
            case 118: {
                ArrayList nodes = Lists.newArrayList();
                for (Node child : n.children()) {
                    nodes.addAll(this.getRhsSubexpressions(child));
                }
                return nodes;
            }
        }
        throw new IllegalArgumentException("AstChangeProxy::getRhs " + n);
    }

    private static enum TriState {
        TRUE,
        FALSE,
        BOTH;

    }

    private class RemoveListener
    implements AstChangeProxy.ChangeListener {
        private RemoveListener() {
        }

        @Override
        public void nodeRemoved(Node n) {
            NameAnalyzer.this.compiler.reportCodeChange();
        }
    }

    private class FindReferences
    implements NodeTraversal.Callback {
        Set<Node> nodesToKeep = Sets.newHashSet();

        FindReferences() {
        }

        private void addAllChildren(Node n) {
            this.nodesToKeep.add(n);
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.addAllChildren(child);
            }
        }

        private void addSimplifiedChildren(Node n) {
            NodeTraversal.traverse(NameAnalyzer.this.compiler, n, new GatherSideEffectSubexpressionsCallback(NameAnalyzer.this.compiler, new NodeAccumulator()));
        }

        private void addSimplifiedExpression(Node n, Node parent) {
            if (parent.isVar()) {
                Node value = n.getFirstChild();
                if (value != null) {
                    this.addSimplifiedChildren(value);
                }
            } else if (n.isAssign() && (parent.isExprResult() || parent.isFor() || parent.isReturn())) {
                for (Node child : n.children()) {
                    this.addSimplifiedChildren(child);
                }
            } else if (n.isCall() && parent.isExprResult()) {
                this.addSimplifiedChildren(n);
            } else {
                this.addAllChildren(n);
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            if (parent == null) {
                return true;
            }
            if (n.isFor()) {
                if (!NodeUtil.isForIn(n)) {
                    Node decl = n.getFirstChild();
                    Node pred = decl.getNext();
                    Node step = pred.getNext();
                    this.addSimplifiedExpression(decl, n);
                    this.addSimplifiedExpression(pred, n);
                    this.addSimplifiedExpression(step, n);
                } else {
                    Node decl = n.getFirstChild();
                    Node iter = decl.getNext();
                    this.addAllChildren(decl);
                    this.addAllChildren(iter);
                }
            }
            if (parent.isVar() || parent.isExprResult() || parent.isReturn() || parent.isThrow()) {
                this.addSimplifiedExpression(n, parent);
            }
            if ((parent.isIf() || parent.isWhile() || parent.isWith() || parent.isSwitch() || parent.isCase()) && parent.getFirstChild() == n) {
                this.addAllChildren(n);
            }
            if (parent.isDo() && parent.getLastChild() == n) {
                this.addAllChildren(n);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            block15: {
                String name;
                block16: {
                    String referringName;
                    NameInformation referring;
                    block14: {
                        if (!(n.isName() || NodeUtil.isGet(n) && !parent.isGetProp())) {
                            return;
                        }
                        NameInformation nameInfo = NameAnalyzer.this.createNameInformation(t, n, parent);
                        if (nameInfo == null) {
                            return;
                        }
                        if (nameInfo.onlyAffectsClassDef) {
                            String nodeName;
                            if (nameInfo.superclass != null) {
                                NameAnalyzer.this.recordReference(nameInfo.name, nameInfo.superclass, RefType.INHERITANCE);
                            }
                            if ((nodeName = n.getQualifiedName()) != null) {
                                NameAnalyzer.this.recordReference(nameInfo.name, nodeName, RefType.REGULAR);
                            }
                            return;
                        }
                        if (parent.isInstanceOf() && parent.getLastChild() == n && n.isQualifiedName()) {
                            JsName checkedClass = NameAnalyzer.this.getName(nameInfo.name, true);
                            NameAnalyzer.this.refNodes.add(new InstanceOfCheckNode(checkedClass, n, parent, parent.getParent()));
                            checkedClass.hasInstanceOfReference = true;
                            return;
                        }
                        referring = NameAnalyzer.this.getDependencyScope(n);
                        referringName = "";
                        if (referring != null) {
                            String string = referringName = referring.isPrototype ? referring.prototypeClass : referring.name;
                        }
                        if (this.maybeHiddenAlias(name = nameInfo.name, n)) {
                            NameAnalyzer.this.recordAlias(name, NameAnalyzer.WINDOW);
                        }
                        if (nameInfo.isExternallyReferenceable) {
                            NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, name, RefType.REGULAR);
                            this.maybeRecordAlias(name, parent, referring, referringName);
                            return;
                        }
                        if (NodeUtil.isVarOrSimpleAssignLhs(n, parent)) {
                            if (referring != null) {
                                NameAnalyzer.this.recordReference(referringName, name, RefType.REGULAR);
                            }
                            return;
                        }
                        if (!this.nodesToKeep.contains(n)) break block14;
                        NameInformation functionScope = NameAnalyzer.this.getEnclosingFunctionDependencyScope(t);
                        if (functionScope != null) {
                            NameAnalyzer.this.recordReference(functionScope.name, name, RefType.REGULAR);
                        } else {
                            NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, name, RefType.REGULAR);
                        }
                        break block15;
                    }
                    if (referring == null) break block16;
                    if (this.maybeRecordAlias(name, parent, referring, referringName)) break block15;
                    RefType depType = referring.onlyAffectsClassDef ? RefType.INHERITANCE : RefType.REGULAR;
                    NameAnalyzer.this.recordReference(referringName, name, depType);
                    break block15;
                }
                for (Node ancestor : n.getAncestors()) {
                    if (!NodeUtil.isAssignmentOp(ancestor) && !ancestor.isFunction()) continue;
                    NameAnalyzer.this.recordReference(NameAnalyzer.WINDOW, name, RefType.REGULAR);
                    break;
                }
            }
        }

        private boolean maybeHiddenAlias(String name, Node n) {
            Node parent = n.getParent();
            if (NodeUtil.isVarOrSimpleAssignLhs(n, parent)) {
                Node rhs = parent.isVar() ? n.getFirstChild() : parent.getLastChild();
                return rhs != null && !NodeUtil.evaluatesToLocalValue(rhs, (Predicate<Node>)NON_LOCAL_RESULT_PREDICATE);
            }
            return false;
        }

        private boolean maybeRecordAlias(String name, Node parent, NameInformation referring, String referringName) {
            if ((parent.isName() || parent.isAssign()) && referring != null && NameAnalyzer.this.scopes.get(parent) == referring) {
                NameAnalyzer.this.recordAlias(referringName, name);
                return true;
            }
            return false;
        }

        private class NodeAccumulator
        implements GatherSideEffectSubexpressionsCallback.SideEffectAccumulator {
            private NodeAccumulator() {
            }

            @Override
            public boolean classDefiningCallsHaveSideEffects() {
                return false;
            }

            @Override
            public void keepSubTree(Node original) {
                FindReferences.this.addAllChildren(original);
            }

            @Override
            public void keepSimplifiedShortCircuitExpression(Node original) {
                Node condition = original.getFirstChild();
                Node thenBranch = condition.getNext();
                FindReferences.this.addAllChildren(condition);
                FindReferences.this.addSimplifiedChildren(thenBranch);
            }

            @Override
            public void keepSimplifiedHookExpression(Node hook, boolean thenHasSideEffects, boolean elseHasSideEffects) {
                Node condition = hook.getFirstChild();
                Node thenBranch = condition.getNext();
                Node elseBranch = thenBranch.getNext();
                FindReferences.this.addAllChildren(condition);
                if (thenHasSideEffects) {
                    FindReferences.this.addSimplifiedChildren(thenBranch);
                }
                if (elseHasSideEffects) {
                    FindReferences.this.addSimplifiedChildren(elseBranch);
                }
            }
        }
    }

    private class FindDeclarationsAndSetters
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindDeclarationsAndSetters() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            NameInformation ns;
            Node nameNode;
            if (t.inGlobalScope()) {
                NameInformation ns2;
                if (NodeUtil.isVarDeclaration(n)) {
                    ns2 = NameAnalyzer.this.createNameInformation(t, n, parent);
                    Preconditions.checkNotNull((Object)ns2);
                    this.recordSet(ns2.name, n);
                } else if (NodeUtil.isFunctionDeclaration(n)) {
                    nameNode = n.getFirstChild();
                    ns = NameAnalyzer.this.createNameInformation(t, nameNode, n);
                    if (ns != null) {
                        JsName nameInfo = NameAnalyzer.this.getName(nameNode.getString(), true);
                        this.recordSet(nameInfo.name, nameNode);
                    }
                } else if (NodeUtil.isObjectLitKey(n, parent) && (ns2 = NameAnalyzer.this.createNameInformation(t, n, parent)) != null) {
                    this.recordSet(ns2.name, n);
                }
            }
            if (n.isAssign()) {
                nameNode = n.getFirstChild();
                ns = NameAnalyzer.this.createNameInformation(t, nameNode, n);
                if (ns != null) {
                    if (ns.isPrototype) {
                        this.recordPrototypeSet(ns.prototypeClass, ns.prototypeProperty, n);
                    } else {
                        this.recordSet(ns.name, nameNode);
                    }
                }
            } else if (n.isCall() && (ns = NameAnalyzer.this.createNameInformation(t, nameNode = n.getFirstChild(), n)) != null && ns.onlyAffectsClassDef) {
                JsName name = NameAnalyzer.this.getName(ns.name, true);
                NameAnalyzer.this.refNodes.add(new ClassDefiningFunctionNode(name, n, parent, parent.getParent()));
            }
        }

        private void recordSet(String name, Node node) {
            JsName jsn = NameAnalyzer.this.getName(name, true);
            JsNameRefNode nameRefNode = new JsNameRefNode(jsn, node);
            NameAnalyzer.this.refNodes.add(nameRefNode);
            if (node.isGetElem()) {
                this.recordWriteOnProperties(name);
            } else if (name.indexOf(46) != -1) {
                this.recordWriteOnProperties(name.substring(0, name.lastIndexOf(46)));
            }
        }

        private void recordPrototypeSet(String className, String prototypeProperty, Node node) {
            JsName name = NameAnalyzer.this.getName(className, true);
            name.prototypeNames.add(prototypeProperty);
            NameAnalyzer.this.refNodes.add(new PrototypeSetNode(name, node));
            this.recordWriteOnProperties(className);
        }

        private void recordWriteOnProperties(String parentName) {
            while (true) {
                JsName parent = NameAnalyzer.this.getName(parentName, true);
                if (parent.hasWrittenDescendants) {
                    return;
                }
                parent.hasWrittenDescendants = true;
                if (parentName.indexOf(46) == -1) {
                    return;
                }
                parentName = parentName.substring(0, parentName.lastIndexOf(46));
            }
        }
    }

    private class HoistVariableAndFunctionDeclarations
    extends NodeTraversal.AbstractShallowCallback {
        private HoistVariableAndFunctionDeclarations() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (NodeUtil.isVarDeclaration(n)) {
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, n, parent);
                Preconditions.checkNotNull((Object)ns, (Object)"NameInformation is null");
                NameAnalyzer.this.createName(ns.name);
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                Node nameNode = n.getFirstChild();
                NameInformation ns = NameAnalyzer.this.createNameInformation(t, nameNode, n);
                Preconditions.checkNotNull((Object)ns, (Object)"NameInformation is null");
                NameAnalyzer.this.createName(nameNode.getString());
            }
        }
    }

    private class FindDependencyScopes
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindDependencyScopes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Node callNode;
            Node nameNode;
            NameInformation ns;
            if (!t.inGlobalScope()) {
                return;
            }
            if (n.isAssign()) {
                Node nameNode2 = n.getFirstChild();
                NameInformation ns2 = NameAnalyzer.this.createNameInformation(t, nameNode2, n);
                if (ns2 != null) {
                    if (parent.isFor() && !NodeUtil.isForIn(parent)) {
                        if (parent.getFirstChild().getNext() != n) {
                            this.recordDepScope(n, ns2);
                        } else {
                            this.recordDepScope(nameNode2, ns2);
                        }
                    } else {
                        this.recordDepScope(n, ns2);
                    }
                }
            } else if (NodeUtil.isVarDeclaration(n)) {
                NameInformation ns3 = NameAnalyzer.this.createNameInformation(t, n, parent);
                this.recordDepScope(n, ns3);
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                NameInformation ns4 = NameAnalyzer.this.createNameInformation(t, n.getFirstChild(), n);
                this.recordDepScope(n, ns4);
            } else if (NodeUtil.isExprCall(n) && (ns = NameAnalyzer.this.createNameInformation(t, nameNode = (callNode = n.getFirstChild()).getFirstChild(), callNode)) != null && ns.onlyAffectsClassDef) {
                this.recordDepScope(n, ns);
            }
        }

        private void recordDepScope(Node node, NameInformation name) {
            NameAnalyzer.this.scopes.put(node, name);
        }
    }

    private class ProcessExternals
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExternals() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            NameInformation ns = null;
            if (NodeUtil.isVarDeclaration(n)) {
                ns = NameAnalyzer.this.createNameInformation(t, n, parent);
            } else if (NodeUtil.isFunctionDeclaration(n)) {
                ns = NameAnalyzer.this.createNameInformation(t, n.getFirstChild(), n);
            }
            if (ns != null) {
                JsName jsName = NameAnalyzer.this.getName(ns.name, true);
                jsName.externallyDefined = true;
                NameAnalyzer.this.externalNames.add(ns.name);
            }
        }
    }

    private class InstanceOfCheckNode
    extends SpecialReferenceNode {
        InstanceOfCheckNode(JsName name, Node node, Node parent, Node gramps) {
            super(name, node, parent, gramps);
            Preconditions.checkState((boolean)node.isQualifiedName());
            Preconditions.checkState((boolean)parent.isInstanceOf());
        }

        @Override
        public void remove() {
            NameAnalyzer.this.changeProxy.replaceWith(this.gramps, this.parent, IR.falseNode());
        }
    }

    private class ClassDefiningFunctionNode
    extends SpecialReferenceNode {
        ClassDefiningFunctionNode(JsName name, Node node, Node parent, Node gramps) {
            super(name, node, parent, gramps);
            Preconditions.checkState((boolean)node.isCall());
        }

        @Override
        public void remove() {
            Preconditions.checkState((boolean)this.node.isCall());
            if (this.parent.isExprResult()) {
                NameAnalyzer.this.changeProxy.removeChild(this.gramps, this.parent);
            } else {
                NameAnalyzer.this.changeProxy.replaceWith(this.parent, this.node, IR.voidNode(IR.number(0.0)));
            }
        }
    }

    private abstract class SpecialReferenceNode
    implements RefNode {
        JsName name;
        Node node;
        Node parent;
        Node gramps;

        SpecialReferenceNode(JsName name, Node node, Node parent, Node gramps) {
            this.name = name;
            this.node = node;
            this.parent = parent;
            this.gramps = gramps;
        }

        @Override
        public JsName name() {
            return this.name;
        }
    }

    private class PrototypeSetNode
    extends JsNameRefNode {
        PrototypeSetNode(JsName name, Node parent) {
            super(name, parent.getFirstChild());
            Preconditions.checkState((boolean)parent.isAssign());
        }

        @Override
        public void remove() {
            Node gramps = this.parent.getParent();
            if (gramps.isExprResult()) {
                NameAnalyzer.this.changeProxy.removeChild(gramps.getParent(), gramps);
            } else {
                NameAnalyzer.this.changeProxy.replaceWith(gramps, this.parent, this.parent.getLastChild().cloneTree());
            }
        }
    }

    private class JsNameRefNode
    implements RefNode {
        JsName name;
        Node node;
        Node parent;

        JsNameRefNode(JsName name, Node node) {
            this.name = name;
            this.node = node;
            this.parent = node.getParent();
        }

        @Override
        public JsName name() {
            return this.name;
        }

        @Override
        public void remove() {
            Node containingNode = this.parent.getParent();
            switch (this.parent.getType()) {
                case 118: {
                    Preconditions.checkState((boolean)this.parent.hasOneChild());
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
                case 105: {
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
                case 86: {
                    if (containingNode.isExprResult()) {
                        NameAnalyzer.this.replaceWithRhs(containingNode.getParent(), containingNode);
                        break;
                    }
                    NameAnalyzer.this.replaceWithRhs(containingNode, this.parent);
                    break;
                }
            }
        }
    }

    static interface RefNode {
        public JsName name();

        public void remove();
    }

    private static class JsName
    implements Comparable<JsName> {
        String name;
        List<String> prototypeNames = Lists.newArrayList();
        boolean externallyDefined = false;
        boolean referenced = false;
        boolean hasWrittenDescendants = false;
        boolean hasInstanceOfReference = false;

        private JsName() {
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append(this.name);
            if (this.prototypeNames.size() > 0) {
                out.append(" (CLASS)\n");
                out.append(" - FUNCTIONS: ");
                Iterator<String> pIter = this.prototypeNames.iterator();
                while (pIter.hasNext()) {
                    out.append(pIter.next());
                    if (!pIter.hasNext()) continue;
                    out.append(", ");
                }
            }
            return out.toString();
        }

        @Override
        public int compareTo(JsName rhs) {
            return this.name.compareTo(rhs.name);
        }
    }

    private static class NameInformation {
        String name;
        boolean isExternallyReferenceable = false;
        boolean isPrototype = false;
        String prototypeClass = null;
        String prototypeProperty = null;
        String superclass = null;
        boolean onlyAffectsClassDef = false;

        private NameInformation() {
        }
    }

    private static class ReferencePropagationCallback
    implements FixedPointGraphTraversal.EdgeCallback<JsName, RefType> {
        private ReferencePropagationCallback() {
        }

        @Override
        public boolean traverseEdge(JsName from, RefType callSite, JsName to) {
            if (from.referenced && !to.referenced) {
                to.referenced = true;
                return true;
            }
            return false;
        }
    }

    private static enum RefType {
        REGULAR,
        INHERITANCE;

    }

    private static class AliasSet {
        Set<String> names = Sets.newHashSet();

        AliasSet(String name1, String name2) {
            this.names.add(name1);
            this.names.add(name2);
        }
    }
}

