/*
 * Decompiled with CFR 0.152.
 */
package com.google.debugging.sourcemap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapSection;
import com.google.debugging.sourcemap.Util;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nullable;

public class SourceMapGeneratorV1
implements SourceMapGenerator {
    private static final int UNMAPPED = -1;
    private List<Mapping> mappings = Lists.newArrayList();
    private Mapping lastMapping;
    private FilePosition offsetPosition = new FilePosition(0, 0);
    private FilePosition prefixPosition = new FilePosition(0, 0);

    private static String escapeString(String string) {
        return Util.escapeString(string);
    }

    @Override
    public void addMapping(String string, @Nullable String string2, FilePosition filePosition, FilePosition filePosition2, FilePosition filePosition3) {
        int n;
        int n2;
        int n3;
        if (string == null || filePosition.getLine() < 0) {
            return;
        }
        Mapping mapping = new Mapping();
        mapping.sourceFile = string;
        mapping.originalPosition = filePosition;
        mapping.originalName = string2;
        if (this.offsetPosition.getLine() == 0 && this.offsetPosition.getColumn() == 0) {
            mapping.startPosition = filePosition2;
            mapping.endPosition = filePosition3;
        } else {
            n3 = this.offsetPosition.getLine();
            n2 = this.offsetPosition.getColumn();
            n = this.offsetPosition.getColumn();
            if (filePosition2.getLine() > 0) {
                n2 = 0;
            }
            if (filePosition3.getLine() > 0) {
                n = 0;
            }
            mapping.startPosition = new FilePosition(filePosition2.getLine() + n3, filePosition2.getColumn() + n2);
            mapping.endPosition = new FilePosition(filePosition3.getLine() + n3, filePosition3.getColumn() + n);
        }
        if (this.lastMapping != null) {
            n3 = this.lastMapping.startPosition.getLine();
            n2 = this.lastMapping.startPosition.getColumn();
            n = mapping.startPosition.getLine();
            int n4 = mapping.startPosition.getColumn();
            Preconditions.checkState((n > n3 || n == n3 && n4 >= n2 ? 1 : 0) != 0, (String)"Incorrect source mappings order, previous : (%s,%s)\nnew : (%s,%s)\nnode : %s", (Object[])new Object[]{n3, n2, n, n4});
        }
        this.lastMapping = mapping;
        this.mappings.add(mapping);
    }

    @Override
    public void setWrapperPrefix(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                ++n;
                n2 = 0;
                continue;
            }
            ++n2;
        }
        this.prefixPosition = new FilePosition(n, n2);
    }

    @Override
    public void setStartingPosition(int n, int n2) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0);
        this.offsetPosition = new FilePosition(n, n2);
    }

    @Override
    public void reset() {
        this.mappings = Lists.newArrayList();
        this.lastMapping = null;
        this.offsetPosition = new FilePosition(0, 0);
        this.prefixPosition = new FilePosition(0, 0);
    }

    @Override
    public void appendTo(Appendable appendable, String string) throws IOException {
        int n = this.prepMappings();
        appendable.append("/** Begin line maps. **/{ \"file\" : ");
        appendable.append(SourceMapGeneratorV1.escapeString(string));
        appendable.append(", \"count\": ");
        appendable.append(String.valueOf(n + 1));
        appendable.append(" }\n");
        new LineMapper(appendable).appendLineMappings();
        appendable.append("/** Begin file information. **/\n");
        for (int i = 0; i <= n; ++i) {
            appendable.append("[]\n");
        }
        appendable.append("/** Begin mapping definitions. **/\n");
        new MappingWriter().appendMappings(appendable);
    }

    private int prepMappings() throws IOException {
        new MappingTraversal().traverse(new UsedMappingCheck());
        int n = 0;
        int n2 = 0;
        for (Mapping mapping : this.mappings) {
            if (!mapping.used) continue;
            mapping.id = n++;
            int n3 = mapping.endPosition.getLine();
            n2 = Math.max(n2, n3);
        }
        return n2 + this.prefixPosition.getLine();
    }

    @Override
    public void validate(boolean bl) {
    }

    @Override
    public void writeMetaMap(Appendable appendable, String string, List<SourceMapSection> list) {
        throw new UnsupportedOperationException();
    }

    private class MappingTraversal {
        private int line;
        private int col;

        MappingTraversal() {
        }

        void traverse(MappingVisitor mappingVisitor) throws IOException {
            ArrayDeque<Mapping> arrayDeque = new ArrayDeque<Mapping>();
            for (Mapping mapping : SourceMapGeneratorV1.this.mappings) {
                Mapping mapping2;
                while (!arrayDeque.isEmpty() && !this.isOverlapped((Mapping)arrayDeque.peek(), mapping)) {
                    mapping2 = (Mapping)arrayDeque.pop();
                    this.maybeVisit(mappingVisitor, mapping2);
                }
                mapping2 = (Mapping)arrayDeque.peek();
                this.maybeVisitParent(mappingVisitor, mapping2, mapping);
                arrayDeque.push(mapping);
            }
            while (!arrayDeque.isEmpty()) {
                Mapping mapping = (Mapping)arrayDeque.pop();
                this.maybeVisit(mappingVisitor, mapping);
            }
        }

        private int getAdjustedLine(FilePosition filePosition) {
            return filePosition.getLine() + SourceMapGeneratorV1.this.prefixPosition.getLine();
        }

        private int getAdjustedCol(FilePosition filePosition) {
            int n = filePosition.getLine();
            int n2 = filePosition.getColumn();
            return n != 0 ? n2 : n2 + SourceMapGeneratorV1.this.prefixPosition.getColumn();
        }

        private boolean isOverlapped(Mapping mapping, Mapping mapping2) {
            int n = mapping.endPosition.getLine();
            int n2 = mapping2.startPosition.getLine();
            int n3 = mapping.endPosition.getColumn();
            int n4 = mapping2.startPosition.getColumn();
            return n == n2 && n3 >= n4 || n > n2;
        }

        private void maybeVisit(MappingVisitor mappingVisitor, Mapping mapping) throws IOException {
            int n = this.getAdjustedLine(mapping.endPosition);
            int n2 = this.getAdjustedCol(mapping.endPosition);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void maybeVisitParent(MappingVisitor mappingVisitor, Mapping mapping, Mapping mapping2) throws IOException {
            int n = this.getAdjustedLine(mapping2.startPosition);
            int n2 = this.getAdjustedCol(mapping2.startPosition);
            Preconditions.checkState((this.line < n || this.col <= n2 ? 1 : 0) != 0);
            if (this.line < n || this.line == n && this.col < n2) {
                this.visit(mappingVisitor, mapping, n, n2);
            }
        }

        private void visit(MappingVisitor mappingVisitor, Mapping mapping, int n, int n2) throws IOException {
            Preconditions.checkState((this.line <= n ? 1 : 0) != 0);
            Preconditions.checkState((this.line < n || this.col < n2 ? 1 : 0) != 0);
            if (this.line == n && this.col == n2) {
                Preconditions.checkState((boolean)false);
                return;
            }
            mappingVisitor.visit(mapping, this.line, this.col, n, n2);
            this.line = n;
            this.col = n2;
        }
    }

    private static interface MappingVisitor {
        public void visit(Mapping var1, int var2, int var3, int var4, int var5) throws IOException;
    }

    private class UsedMappingCheck
    implements MappingVisitor {
        private UsedMappingCheck() {
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            if (mapping != null) {
                mapping.used = true;
            }
        }
    }

    private class LineMapper
    implements MappingVisitor {
        private final Appendable out;
        private boolean firstChar = true;
        private static final String UNMAPPED_STRING = "-1";
        private int lastId = -1;
        private String lastIdString = "-1";

        LineMapper(Appendable appendable) {
            this.out = appendable;
        }

        @Override
        public void visit(Mapping mapping, int n, int n2, int n3, int n4) throws IOException {
            int n5;
            int n6 = n5 = mapping != null ? mapping.id : -1;
            if (this.lastId != n5) {
                this.lastIdString = n5 == -1 ? UNMAPPED_STRING : String.valueOf(n5);
                this.lastId = n5;
            }
            String string = this.lastIdString;
            for (int i = n; i <= n3; ++i) {
                if (i == n3) {
                    for (int j = n2; j < n4; ++j) {
                        this.addCharEntry(string);
                    }
                    break;
                }
                this.closeLine();
                this.openLine();
                n2 = 0;
            }
        }

        void appendLineMappings() throws IOException {
            this.openLine();
            new MappingTraversal().traverse(this);
            this.closeLine();
        }

        private void openLine() throws IOException {
            if (this.out != null) {
                this.out.append("[");
                this.firstChar = true;
            }
        }

        private void closeLine() throws IOException {
            if (this.out != null) {
                this.out.append("]\n");
            }
        }

        private void addCharEntry(String string) throws IOException {
            if (this.out != null) {
                if (this.firstChar) {
                    this.firstChar = false;
                } else {
                    this.out.append(",");
                }
                this.out.append(string);
            }
        }
    }

    private class MappingWriter {
        private String lastSourceFile = null;
        private String lastSourceFileEscaped = null;
        private int lastLine = 0;
        private String lastLineString = String.valueOf(0);

        private MappingWriter() {
        }

        private void appendMappingTo(Mapping mapping, Appendable appendable) throws IOException {
            appendable.append("[");
            String string = mapping.sourceFile;
            if (this.lastSourceFile != string) {
                this.lastSourceFile = string;
                this.lastSourceFileEscaped = SourceMapGeneratorV1.escapeString(string);
            }
            String string2 = this.lastSourceFileEscaped;
            appendable.append(string2);
            appendable.append(",");
            int n = mapping.originalPosition.getLine();
            if (n != this.lastLine) {
                this.lastLineString = String.valueOf(n);
            }
            String string3 = this.lastLineString;
            appendable.append(string3);
            appendable.append(",");
            appendable.append(String.valueOf(mapping.originalPosition.getColumn()));
            if (mapping.originalName != null) {
                appendable.append(",");
                appendable.append(SourceMapGeneratorV1.escapeString(mapping.originalName));
            }
            appendable.append("]\n");
        }

        void appendMappings(Appendable appendable) throws IOException {
            for (Mapping mapping : SourceMapGeneratorV1.this.mappings) {
                if (!mapping.used) continue;
                this.appendMappingTo(mapping, appendable);
            }
        }
    }

    static class Mapping {
        int id = -1;
        String sourceFile;
        FilePosition originalPosition;
        FilePosition startPosition;
        FilePosition endPosition;
        String originalName;
        boolean used = false;

        Mapping() {
        }
    }
}

