/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CheckMissingGetCssName
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final CheckLevel level;
    private final Matcher blacklist;
    static final String GET_CSS_NAME_FUNCTION = "goog.getCssName";
    static final String GET_UNIQUE_ID_FUNCTION = ".getUniqueId";
    static final DiagnosticType MISSING_GETCSSNAME = DiagnosticType.disabled("JSC_MISSING_GETCSSNAME", "missing goog.getCssName around literal ''{0}''");

    CheckMissingGetCssName(AbstractCompiler abstractCompiler, CheckLevel checkLevel, String string) {
        this.compiler = abstractCompiler;
        this.level = checkLevel;
        this.blacklist = Pattern.compile("\\b(?:" + string + ")").matcher("");
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() == 40 && node2.getType() != 33 && node2.getType() != 47 && !NodeUtil.isObjectLitKey(node, node2)) {
            String string = node.getString();
            this.blacklist.reset(string);
            while (this.blacklist.find()) {
                if (this.insideGetCssNameCall(node, node2) || this.insideGetUniqueIdCall(node, node2) || this.insideAssignmentToIdConstant(node, node2)) continue;
                this.compiler.report(nodeTraversal.makeError(node, this.level, MISSING_GETCSSNAME, this.blacklist.group()));
            }
        }
    }

    private boolean insideGetCssNameCall(Node node, Node node2) {
        return node2.getType() == 37 && GET_CSS_NAME_FUNCTION.equals(node2.getFirstChild().getQualifiedName());
    }

    private boolean insideGetUniqueIdCall(Node node, Node node2) {
        String string = node2.getType() == 37 ? node2.getFirstChild().getQualifiedName() : null;
        return string != null && string.endsWith(GET_UNIQUE_ID_FUNCTION);
    }

    private boolean insideAssignmentToIdConstant(Node node, Node node2) {
        if (node2.getType() == 86) {
            String string = node2.getFirstChild().getQualifiedName();
            return string != null && this.isIdName(string);
        }
        if (node2.getType() == 38) {
            Node node3 = node2.getParent();
            if (node3 != null && node3.getType() == 118) {
                String string = node2.getString();
                return this.isIdName(string);
            }
            return false;
        }
        return false;
    }

    private boolean isIdName(String string) {
        return string.endsWith("ID") || string.endsWith("ID_");
    }
}

