/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.rhino.Node;

abstract class CodeConsumer {
    boolean statementNeedsEnded = false;
    boolean statementStarted = false;
    boolean sawFunction = false;

    CodeConsumer() {
    }

    void startSourceMapping(Node node) {
    }

    void endSourceMapping(Node node) {
    }

    boolean continueProcessing() {
        return true;
    }

    abstract char getLastChar();

    void addIdentifier(String string) {
        this.add(string);
    }

    abstract void append(String var1);

    void appendBlockStart() {
        this.append("{");
    }

    void appendBlockEnd() {
        this.append("}");
    }

    void startNewLine() {
    }

    void maybeLineBreak() {
        this.maybeCutLine();
    }

    void maybeCutLine() {
    }

    void endLine() {
    }

    void notePreferredLineBreak() {
    }

    void beginBlock() {
        if (this.statementNeedsEnded) {
            this.append(";");
            this.maybeLineBreak();
        }
        this.appendBlockStart();
        this.endLine();
        this.statementNeedsEnded = false;
    }

    void endBlock() {
        this.endBlock(false);
    }

    void endBlock(boolean bl) {
        this.appendBlockEnd();
        if (bl) {
            this.endLine();
        }
        this.statementNeedsEnded = false;
    }

    void listSeparator() {
        this.add(",");
        this.maybeLineBreak();
    }

    void endStatement() {
        this.endStatement(false);
    }

    void endStatement(boolean bl) {
        if (bl) {
            this.append(";");
            this.maybeLineBreak();
            this.statementNeedsEnded = false;
        } else if (this.statementStarted) {
            this.statementNeedsEnded = true;
        }
    }

    void maybeEndStatement() {
        if (this.statementNeedsEnded) {
            this.append(";");
            this.maybeLineBreak();
            this.endLine();
            this.statementNeedsEnded = false;
        }
        this.statementStarted = true;
    }

    void endFunction() {
        this.endFunction(false);
    }

    void endFunction(boolean bl) {
        this.sawFunction = true;
        if (bl) {
            this.endLine();
        }
    }

    void beginCaseBody() {
        this.append(":");
    }

    void endCaseBody() {
    }

    void add(String string) {
        this.maybeEndStatement();
        if (string.length() == 0) {
            return;
        }
        char c = string.charAt(0);
        if ((CodeConsumer.isWordChar(c) || c == '\\') && CodeConsumer.isWordChar(this.getLastChar())) {
            this.append(" ");
        }
        this.append(string);
    }

    void appendOp(String string, boolean bl) {
        this.append(string);
    }

    void addOp(String string, boolean bl) {
        this.maybeEndStatement();
        char c = string.charAt(0);
        char c2 = this.getLastChar();
        if ((c == '+' || c == '-') && c2 == c) {
            this.append(" ");
        } else if (Character.isLetter(c) && CodeConsumer.isWordChar(c2)) {
            this.append(" ");
        } else if (c2 == '-' && c == '>') {
            this.append(" ");
        }
        this.appendOp(string, bl);
        if (bl) {
            this.maybeCutLine();
        }
    }

    void addNumber(double d) {
        char c = this.getLastChar();
        if (d < 0.0 && c == '-') {
            this.add(" ");
        }
        if ((double)((long)d) == d) {
            long l;
            long l2 = l = (long)d;
            int n = 0;
            if (Math.abs(d) >= 100.0) {
                while ((double)(l2 / 10L) * Math.pow(10.0, n + 1) == (double)l) {
                    l2 /= 10L;
                    ++n;
                }
            }
            if (n > 2) {
                this.add(Long.toString(l2) + "E" + Integer.toString(n));
            } else {
                this.add(Long.toString(l));
            }
        } else {
            this.add(String.valueOf(d));
        }
    }

    static boolean isWordChar(char c) {
        return c == '_' || c == '$' || Character.isLetterOrDigit(c);
    }

    boolean shouldPreserveExtraBlocks() {
        return false;
    }

    boolean breakAfterBlockFor(Node node, boolean bl) {
        return bl;
    }

    void endFile() {
    }
}

