/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.Set;

class CollapseVariableDeclarations
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final List<Collapse> collapses = Lists.newArrayList();
    private final Set<Node> nodesToCollapse = Sets.newHashSet();

    CollapseVariableDeclarations(AbstractCompiler abstractCompiler) {
        Preconditions.checkState((!abstractCompiler.getLifeCycleStage().isNormalized() ? 1 : 0) != 0);
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        this.collapses.clear();
        this.nodesToCollapse.clear();
        NodeTraversal.traverse(this.compiler, node2, new GatherCollapses());
        if (!this.collapses.isEmpty()) {
            this.applyCollapses();
            this.compiler.reportCodeChange();
        }
    }

    private void applyCollapses() {
        for (Collapse collapse : this.collapses) {
            Node node = collapse.firstVarNode;
            while (node.getNext() != null && node.getNext().getType() == 118) {
                Node node2 = collapse.parent.removeChildAfter(node);
                node.addChildrenToBack(node2.removeChildren());
            }
        }
    }

    private class GatherCollapses
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherCollapses() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 118) {
                return;
            }
            if (CollapseVariableDeclarations.this.nodesToCollapse.contains(node)) {
                return;
            }
            if (node2.getType() == 108) {
                return;
            }
            Node node3 = node;
            boolean bl = false;
            for (node = node.getNext(); node != null && node.getType() == 118; node = node.getNext()) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(node);
                bl = true;
            }
            if (bl) {
                CollapseVariableDeclarations.this.nodesToCollapse.add(node3);
                CollapseVariableDeclarations.this.collapses.add(new Collapse(node3, node2));
            }
        }
    }

    private static class Collapse {
        final Node firstVarNode;
        final Node parent;

        Collapse(Node node, Node node2) {
            this.firstVarNode = node;
            this.parent = node2;
        }
    }
}

