/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

class ConstCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType CONST_REASSIGNED_VALUE_ERROR = DiagnosticType.error("JSC_CONSTANT_REASSIGNED_VALUE_ERROR", "constant {0} assigned a value more than once");
    private final AbstractCompiler compiler;
    private final Set<Scope.Var> initializedConstants;

    public ConstCheck(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.initializedConstants = new HashSet<Scope.Var>();
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 38: {
                if (node2 == null || node2.getType() != 118 || !node.hasChildren()) break;
                String string = node.getString();
                Scope.Var var = nodeTraversal.getScope().getVar(string);
                if (!this.isConstant(var)) break;
                if (this.initializedConstants.contains(var)) {
                    this.reportError(nodeTraversal, node, string);
                    break;
                }
                this.initializedConstants.add(var);
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                Node node3 = node.getFirstChild();
                if (node3.getType() != 38) break;
                String string = node3.getString();
                Scope.Var var = nodeTraversal.getScope().getVar(string);
                if (!this.isConstant(var)) break;
                if (this.initializedConstants.contains(var)) {
                    this.reportError(nodeTraversal, node, string);
                    break;
                }
                this.initializedConstants.add(var);
                break;
            }
            case 102: 
            case 103: {
                Node node4 = node.getFirstChild();
                if (node4.getType() != 38) break;
                String string = node4.getString();
                Scope.Var var = nodeTraversal.getScope().getVar(string);
                if (!this.isConstant(var)) break;
                this.reportError(nodeTraversal, node, string);
                break;
            }
        }
    }

    private boolean isConstant(Scope.Var var) {
        return var != null && var.isConst();
    }

    void reportError(NodeTraversal nodeTraversal, Node node, String string) {
        this.compiler.report(nodeTraversal.makeError(node, CONST_REASSIGNED_VALUE_ERROR, string));
    }
}

