/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

class CrossModuleCodeMotion
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(CrossModuleCodeMotion.class.getName());
    private final AbstractCompiler compiler;
    private final JSModuleGraph graph;
    private final Map<JSModule, Node> moduleVarParentMap = new HashMap<JSModule, Node>();
    private final Map<Scope.Var, NamedInfo> namedInfo = new LinkedHashMap<Scope.Var, NamedInfo>();

    CrossModuleCodeMotion(AbstractCompiler abstractCompiler, JSModuleGraph jSModuleGraph) {
        this.compiler = abstractCompiler;
        this.graph = jSModuleGraph;
    }

    @Override
    public void process(Node node, Node node2) {
        logger.info("Moving functions + variable into deeper modules");
        if (this.graph != null && this.graph.getModuleCount() > 1) {
            NodeTraversal.traverse(this.compiler, node2, this);
            this.moveCode();
        }
    }

    private void moveCode() {
        for (NamedInfo namedInfo : this.namedInfo.values()) {
            JSModule jSModule = namedInfo.deepestModule;
            if (!namedInfo.allowMove || jSModule == null) continue;
            Iterator<Declaration> iterator = namedInfo.declarationIterator();
            JSModuleGraph jSModuleGraph = this.compiler.getModuleGraph();
            while (iterator.hasNext()) {
                Node node;
                Declaration declaration = iterator.next();
                if (declaration.module == null || !jSModuleGraph.dependsOn(jSModule, declaration.module)) continue;
                Node node2 = this.moduleVarParentMap.get(jSModule);
                if (node2 == null) {
                    node2 = this.compiler.getNodeForCodeInsertion(jSModule);
                    this.moduleVarParentMap.put(jSModule, node2);
                }
                Preconditions.checkState(((node = declaration.node.getParent()).getType() != 118 || node.hasOneChild() ? 1 : 0) != 0, (Object)"AST not normalized.");
                node.detachFromParent();
                node2.addChildToFront(node);
                this.compiler.reportCodeChange();
            }
        }
    }

    private boolean hasConditionalAncestor(Node node) {
        for (Node node2 : node.getAncestors()) {
            switch (node2.getType()) {
                case 98: 
                case 105: 
                case 108: 
                case 110: 
                case 113: 
                case 114: 
                case 115: {
                    return true;
                }
            }
        }
        return false;
    }

    private NamedInfo getNamedInfo(Scope.Var var) {
        NamedInfo namedInfo = this.namedInfo.get(var);
        if (namedInfo == null) {
            namedInfo = new NamedInfo();
            this.namedInfo.put(var, namedInfo);
        }
        return namedInfo;
    }

    private void processReference(NodeTraversal nodeTraversal, NamedInfo namedInfo, String string) {
        boolean bl = false;
        Node node = nodeTraversal.getScope().getRootNode();
        if (node.getType() == 105) {
            String string2 = node.getFirstChild().getString();
            Node node2 = node.getParent();
            if (string2.equals(string)) {
                bl = true;
            } else if (node2.getType() == 38 && node2.getString().equals(string)) {
                bl = true;
            } else {
                Scope scope = nodeTraversal.getScope();
                while (scope.getParent() != null) {
                    Node node3 = scope.getRootNode();
                    if (node3.getParent().getType() == 86) {
                        Node node4 = node3.getParent().getFirstChild();
                        while (node4.getType() == 33) {
                            node4 = node4.getFirstChild();
                        }
                        if (node4.getType() == 38 && node4.getString().equals(string)) {
                            bl = true;
                            break;
                        }
                    }
                    scope = scope.getParent();
                }
            }
        }
        if (!bl) {
            namedInfo.addUsedModule(nodeTraversal.getModule());
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getType() != 38) {
            return;
        }
        String string = node.getString();
        if (string.isEmpty() || this.compiler.getCodingConvention().isExported(string)) {
            return;
        }
        Scope.Var var = nodeTraversal.getScope().getVar(string);
        if (var == null || !var.isGlobal()) {
            return;
        }
        NamedInfo namedInfo = this.getNamedInfo(var);
        if (namedInfo.allowMove) {
            if (this.maybeProcessDeclaration(nodeTraversal, node, node2, namedInfo)) {
                if (this.hasConditionalAncestor(node2.getParent())) {
                    namedInfo.allowMove = false;
                }
            } else {
                this.processReference(nodeTraversal, namedInfo, string);
            }
        }
    }

    private boolean maybeProcessDeclaration(NodeTraversal nodeTraversal, Node node, Node node2, NamedInfo namedInfo) {
        Node node3 = node2.getParent();
        switch (node2.getType()) {
            case 118: {
                if (this.canMoveValue(node.getFirstChild())) {
                    return namedInfo.addDeclaration(new Declaration(nodeTraversal.getModule(), node, node2, node3));
                }
                return false;
            }
            case 105: {
                if (NodeUtil.isFunctionDeclaration(node2)) {
                    return namedInfo.addDeclaration(new Declaration(nodeTraversal.getModule(), node, node2, node3));
                }
                return false;
            }
            case 33: 
            case 86: {
                Node node4 = node;
                for (Node node5 : node.getAncestors()) {
                    if (node5.getType() != 33) {
                        if (node5.getType() == 86 && node5.getFirstChild() == node4) {
                            Node node6 = node5.getParent();
                            if (NodeUtil.isExpressionNode(node6) && this.canMoveValue(node5.getLastChild())) {
                                return namedInfo.addDeclaration(new Declaration(nodeTraversal.getModule(), node5, node6, node6.getParent()));
                            }
                        } else {
                            return false;
                        }
                    }
                    node4 = node5;
                }
                return false;
            }
            case 37: {
                CodingConvention.SubclassRelationship subclassRelationship;
                if (NodeUtil.isExprCall(node3) && (subclassRelationship = this.compiler.getCodingConvention().getClassesDefinedByCall(node2)) != null && node.getString().equals(subclassRelationship.subclassName)) {
                    return namedInfo.addDeclaration(new Declaration(nodeTraversal.getModule(), node2, node3, node3.getParent()));
                }
                return false;
            }
        }
        return false;
    }

    private boolean canMoveValue(Node node) {
        if (node == null || NodeUtil.isLiteralValue(node, true) || node.getType() == 105) {
            return true;
        }
        if (node.getType() == 37) {
            Node node2 = node.getFirstChild();
            return node2.getType() == 38 && (node2.getString().equals("JSCompiler_stubMethod") || node2.getString().equals("JSCompiler_unstubMethod"));
        }
        if (node.getType() == 63 || node.getType() == 64) {
            boolean bl = node.getType() == 64;
            for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
                if (this.canMoveValue(bl ? node3.getFirstChild() : node3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private class Declaration {
        final JSModule module;
        final Node node;

        Declaration(JSModule jSModule, Node node, Node node2, Node node3) {
            this.module = jSModule;
            this.node = node;
        }
    }

    private class NamedInfo {
        boolean allowMove = true;
        private JSModule deepestModule = null;
        private JSModule declModule = null;
        private final Deque<Declaration> declarations = new ArrayDeque<Declaration>();

        private NamedInfo() {
        }

        void addUsedModule(JSModule jSModule) {
            if (!this.allowMove) {
                return;
            }
            this.deepestModule = this.deepestModule == null ? jSModule : CrossModuleCodeMotion.this.graph.getDeepestCommonDependencyInclusive(jSModule, this.deepestModule);
        }

        boolean addDeclaration(Declaration declaration) {
            if (this.declModule != null && declaration.module != this.declModule) {
                return false;
            }
            this.declarations.push(declaration);
            this.declModule = declaration.module;
            return true;
        }

        Iterator<Declaration> declarationIterator() {
            return this.declarations.iterator();
        }
    }
}

