/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import java.text.MessageFormat;

public class DiagnosticType
implements Comparable<DiagnosticType> {
    public final String key;
    public final MessageFormat format;
    public final CheckLevel defaultLevel;
    public CheckLevel level;

    public static DiagnosticType error(String string, String string2) {
        return DiagnosticType.make(string, CheckLevel.ERROR, string2);
    }

    public static DiagnosticType warning(String string, String string2) {
        return DiagnosticType.make(string, CheckLevel.WARNING, string2);
    }

    public static DiagnosticType disabled(String string, String string2) {
        return DiagnosticType.make(string, CheckLevel.OFF, string2);
    }

    public static DiagnosticType make(String string, CheckLevel checkLevel, String string2) {
        return new DiagnosticType(string, checkLevel, new MessageFormat(string2));
    }

    private DiagnosticType(String string, CheckLevel checkLevel, MessageFormat messageFormat) {
        this.key = string;
        this.defaultLevel = checkLevel;
        this.format = messageFormat;
        this.level = this.defaultLevel;
    }

    String format(Object ... objectArray) {
        return this.format.format(objectArray);
    }

    @Override
    public int compareTo(DiagnosticType diagnosticType) {
        return this.key.compareTo(diagnosticType.key);
    }

    public String toString() {
        return this.key + ": " + this.format.toPattern();
    }
}

