/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.FunctionArgumentInjector;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class FunctionToBlockMutator {
    private AbstractCompiler compiler;
    private Supplier<String> safeNameIdSupplier;

    FunctionToBlockMutator(AbstractCompiler abstractCompiler, Supplier<String> supplier) {
        this.compiler = abstractCompiler;
        this.safeNameIdSupplier = supplier;
    }

    Node mutate(String string, Node node, Node node2, String string2, boolean bl, boolean bl2) {
        Node node3;
        Object object;
        boolean bl3;
        Node node4 = node.cloneTree();
        this.makeLocalNamesUnique(node4, bl2);
        Set<String> set = FunctionArgumentInjector.findModifiedParameters(node4);
        LinkedHashMap<String, Node> linkedHashMap = FunctionArgumentInjector.getFunctionCallParameterMap(node4, node2, this.safeNameIdSupplier);
        boolean bl4 = bl3 = !linkedHashMap.isEmpty();
        if (bl3) {
            FunctionArgumentInjector.maybeAddTempsForCallArguments(node4, linkedHashMap, set, this.compiler.getCodingConvention());
        }
        Node node5 = NodeUtil.getFunctionBody(node4);
        node5.detachFromParent();
        if (bl3) {
            object = this.aliasAndInlineArguments(node5, linkedHashMap, set);
            Preconditions.checkState((node5 == object ? 1 : 0) != 0);
        }
        if (bl2) {
            this.fixUnitializedVarDeclarations(node5);
        }
        Preconditions.checkState(((node3 = FunctionToBlockMutator.replaceReturns(node5, string2, (String)(object = this.getLabelNameForFunction(string)), bl)) != null ? 1 : 0) != 0);
        return node3;
    }

    private void fixUnitializedVarDeclarations(Node node) {
        if (NodeUtil.isLoopStructure(node)) {
            return;
        }
        if (NodeUtil.isVar(node)) {
            Node node2 = node.getFirstChild();
            if (!node2.hasChildren()) {
                Node node3 = node2;
                node2.addChildToBack(NodeUtil.newUndefinedNode(node3));
            }
            return;
        }
        for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
            this.fixUnitializedVarDeclarations(node4);
        }
    }

    private void makeLocalNamesUnique(Node node, boolean bl) {
        NodeTraversal.traverse(this.compiler, node, new MakeDeclaredNamesUnique(new MakeDeclaredNamesUnique.InlineRenamer(this.compiler.getUniqueNameIdSupplier(), "inline_", bl)));
    }

    private String getLabelNameForFunction(String string) {
        String string2 = string == null || string.isEmpty() ? "anon" : string;
        return "JSCompiler_inline_label_" + string2 + "_" + (String)this.safeNameIdSupplier.get();
    }

    private Node aliasAndInlineArguments(Node node, LinkedHashMap<String, Node> linkedHashMap, Set<String> set) {
        if (set == null || set.isEmpty()) {
            Node node2 = FunctionArgumentInjector.inject(node, null, linkedHashMap);
            Preconditions.checkState((node2 == node ? 1 : 0) != 0);
            return node2;
        }
        HashMap hashMap = Maps.newHashMap(linkedHashMap);
        LinkedList linkedList = Lists.newLinkedList();
        for (Map.Entry<String, Node> entry : linkedHashMap.entrySet()) {
            Object object = entry.getKey();
            if (!set.contains(object)) continue;
            Node node3 = entry.getValue().cloneTree();
            Node node4 = NodeUtil.newVarNode((String)object, node3).copyInformationFromForTree(node3);
            linkedList.add(0, node4);
            hashMap.remove(object);
        }
        Node node5 = FunctionArgumentInjector.inject(node, null, hashMap);
        Preconditions.checkState((node5 == node ? 1 : 0) != 0);
        for (Object object : linkedList) {
            node.addChildToFront((Node)object);
        }
        return node5;
    }

    private static Node replaceReturns(Node node, String string, String string2, boolean bl) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)string2);
        Node node2 = node;
        boolean bl2 = false;
        int n = NodeUtil.getNodeTypeReferenceCount(node, 4, new NodeUtil.MatchShallowStatement());
        if (n > 0) {
            bl2 = FunctionToBlockMutator.hasReturnAtExit(node);
            if (bl2) {
                FunctionToBlockMutator.convertLastReturnToStatement(node, string);
                --n;
            }
            if (n > 0) {
                FunctionToBlockMutator.replaceReturnWithBreak(node, null, string, string2);
                Node node3 = new Node(126).copyInformationFrom(node);
                Node node4 = Node.newString(153, string2).copyInformationFrom(node);
                node3.addChildToFront(node4);
                node3.addChildToBack(node);
                Node node5 = new Node(125).copyInformationFrom(node);
                node5.addChildrenToBack(node3);
                node2 = node5;
            }
        }
        if (bl && !bl2 && string != null) {
            FunctionToBlockMutator.addDummyAssignment(node, string);
        }
        return node2;
    }

    private static void addDummyAssignment(Node node, String string) {
        Preconditions.checkArgument((node.getType() == 125 ? 1 : 0) != 0);
        Node node2 = node;
        Node node3 = NodeUtil.newUndefinedNode(node2);
        Node node4 = FunctionToBlockMutator.createAssignStatementNode(string, node3);
        node4.copyInformationFromForTree(node);
        node.addChildrenToBack(node4);
    }

    private static void convertLastReturnToStatement(Node node, String string) {
        Node node2 = node.getLastChild();
        Preconditions.checkArgument((node2.getType() == 4 ? 1 : 0) != 0);
        Node node3 = FunctionToBlockMutator.getReplacementReturnStatement(node2, string);
        if (node3 == null) {
            node.removeChild(node2);
        } else {
            node3.copyInformationFromForTree(node2);
            node.replaceChild(node2, node3);
        }
    }

    private static Node createAssignStatementNode(String string, Node node) {
        Node node2 = Node.newString(38, string);
        Node node3 = new Node(86, node2, node);
        return NodeUtil.newExpr(node3);
    }

    private static Node getReplacementReturnStatement(Node node, String string) {
        Node node2 = null;
        Node node3 = null;
        if (node.hasChildren()) {
            node3 = node.getFirstChild().cloneTree();
        }
        if (string == null) {
            if (node3 != null) {
                node2 = NodeUtil.newExpr(node3);
            }
        } else {
            if (node3 == null) {
                Node node4 = node;
                node3 = NodeUtil.newUndefinedNode(node4);
            }
            node2 = FunctionToBlockMutator.createAssignStatementNode(string, node3);
        }
        return node2;
    }

    private static boolean hasReturnAtExit(Node node) {
        return node.getLastChild().getType() == 4;
    }

    private static Node replaceReturnWithBreak(Node node, Node node2, String string, String string2) {
        if (node.getType() == 105 || node.getType() == 130) {
            return node;
        }
        if (node.getType() == 4) {
            Preconditions.checkState((boolean)NodeUtil.isStatementBlock(node2));
            Node node3 = FunctionToBlockMutator.getReplacementReturnStatement(node, string);
            Node node4 = Node.newString(153, string2);
            Node node5 = new Node(116, node4);
            node5.copyInformationFromForTree(node);
            node2.replaceChild(node, node5);
            if (node3 != null) {
                node3.copyInformationFromForTree(node);
                node2.addChildBefore(node3, node5);
            }
            node = node5;
        } else {
            for (Node node6 = node.getFirstChild(); node6 != null; node6 = node6.getNext()) {
                node6 = FunctionToBlockMutator.replaceReturnWithBreak(node6, node, string, string2);
            }
        }
        return node;
    }
}

