/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.rhino.Node;

class InlineCostEstimator {
    private static final String ESTIMATED_IDENTIFIER = "ab";
    static final int ESTIMATED_IDENTIFIER_COST = "ab".length();

    private InlineCostEstimator() {
    }

    static int getCost(Node node) {
        return InlineCostEstimator.getCost(node, Integer.MAX_VALUE);
    }

    static int getCost(Node node, int n) {
        CompiledSizeEstimator compiledSizeEstimator = new CompiledSizeEstimator(n);
        compiledSizeEstimator.add(node);
        return compiledSizeEstimator.getCost();
    }

    private static class CompiledSizeEstimator
    extends CodeConsumer {
        private int maxCost;
        private int cost = 0;
        private char last = '\u0000';
        private boolean continueProcessing = true;

        CompiledSizeEstimator(int n) {
            this.maxCost = n;
        }

        void add(Node node) {
            CodeGenerator codeGenerator = new CodeGenerator(this);
            codeGenerator.add(node);
        }

        int getCost() {
            return this.cost;
        }

        @Override
        boolean continueProcessing() {
            return this.continueProcessing;
        }

        @Override
        char getLastChar() {
            return this.last;
        }

        @Override
        void append(String string) {
            this.last = string.charAt(string.length() - 1);
            this.cost += string.length();
            if (this.maxCost <= this.cost) {
                this.continueProcessing = false;
            }
        }

        @Override
        void addIdentifier(String string) {
            this.add(InlineCostEstimator.ESTIMATED_IDENTIFIER);
        }
    }
}

