/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

abstract class JsMessageVisitor
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private static final String MSG_FUNCTION_NAME = "goog.getMsg";
    static final DiagnosticType MESSAGE_HAS_NO_DESCRIPTION = DiagnosticType.warning("JSC_MSG_HAS_NO_DESCRIPTION", "Message {0} has no description. Add @desc JsDoc tag.");
    static final DiagnosticType MESSAGE_HAS_NO_TEXT = DiagnosticType.warning("JSC_MSG_HAS_NO_TEXT", "Message value of {0} is just an empty string. Empty messages are forbidden.");
    static final DiagnosticType MESSAGE_TREE_MALFORMED = DiagnosticType.error("JSC_MSG_TREE_MALFORMED", "Message parse tree malformed. {0}");
    static final DiagnosticType MESSAGE_HAS_NO_VALUE = DiagnosticType.error("JSC_MSG_HAS_NO_VALUE", "message node {0} has no value");
    static final DiagnosticType MESSAGE_DUPLICATE_KEY = DiagnosticType.error("JSC_MSG_KEY_DUPLICATED", "duplicate message variable name found for {0}, initial definition {1}:{2}");
    static final DiagnosticType MESSAGE_NODE_IS_ORPHANED = DiagnosticType.warning("JSC_MSG_ORPHANED_NODE", "goog.getMsg() function could be used only with MSG_* property or variable");
    static final DiagnosticType MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX = DiagnosticType.error("JSC_MSG_NOT_INITIALIZED_USING_NEW_SYNTAX", "message not initialized using goog.getMsg");
    private static final String PH_JS_PREFIX = "{$";
    private static final String PH_JS_SUFFIX = "}";
    static final String MSG_PREFIX = "MSG_";
    private static final Pattern MSG_UNNAMED_PATTERN = Pattern.compile("MSG_UNNAMED_\\d+");
    private static final Pattern CAMELCASE_PATTERN = Pattern.compile("[a-z][a-zA-Z\\d]*[_\\d]*");
    static final String HIDDEN_DESC_PREFIX = "@hidden";
    private static final String DESC_SUFFIX = "_HELP";
    private final boolean needToCheckDuplications;
    private final JsMessage.Style style;
    private final JsMessage.IdGenerator idGenerator;
    final AbstractCompiler compiler;
    private final Map<String, MessageLocation> messageNames = Maps.newHashMap();
    private final Map<Node, String> googMsgNodes = Maps.newHashMap();
    private final CheckLevel checkLevel;

    JsMessageVisitor(AbstractCompiler abstractCompiler, boolean bl, JsMessage.Style style, JsMessage.IdGenerator idGenerator) {
        this.compiler = abstractCompiler;
        this.needToCheckDuplications = bl;
        this.style = style;
        this.idGenerator = idGenerator;
        this.checkLevel = style == JsMessage.Style.CLOSURE ? CheckLevel.ERROR : CheckLevel.WARNING;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
        for (Map.Entry<Node, String> entry : this.googMsgNodes.entrySet()) {
            this.compiler.report(JSError.make(entry.getValue(), entry.getKey(), this.checkLevel, MESSAGE_NODE_IS_ORPHANED, new String[0]));
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        boolean bl;
        Node node3;
        Node node4;
        boolean bl2;
        String string;
        switch (node.getType()) {
            case 38: {
                if (node2 == null || node2.getType() != 118) {
                    return;
                }
                string = node.getString();
                bl2 = true;
                node4 = node.getFirstChild();
                node3 = node;
                break;
            }
            case 86: {
                bl2 = false;
                Node node5 = node.getFirstChild();
                if (node5.getType() != 33) {
                    return;
                }
                Node node6 = node5.getLastChild();
                string = node6.getString();
                node4 = node.getLastChild();
                node3 = node;
                break;
            }
            case 37: {
                if (MSG_FUNCTION_NAME.equals(node.getFirstChild().getQualifiedName())) {
                    this.googMsgNodes.put(node, nodeTraversal.getSourceName());
                }
                return;
            }
            default: {
                return;
            }
        }
        boolean bl3 = bl = node4 != null && node4.getType() == 37;
        if (!this.isMessageName(string, bl)) {
            return;
        }
        if (node4 == null) {
            this.compiler.report(nodeTraversal.makeError(node, MESSAGE_HAS_NO_VALUE, string));
            return;
        }
        if (bl) {
            this.googMsgNodes.remove(node4);
        } else if (this.style != JsMessage.Style.LEGACY) {
            this.compiler.report(nodeTraversal.makeError(node, this.checkLevel, MESSAGE_NOT_INITIALIZED_USING_NEW_SYNTAX, new String[0]));
        }
        boolean bl4 = JsMessageVisitor.isUnnamedMessageName(string);
        JsMessage.Builder builder = new JsMessage.Builder(bl4 ? null : string);
        builder.setSourceName(nodeTraversal.getSourceName());
        try {
            if (bl2) {
                this.extractMessageFromVariable(builder, node, node2, node2.getParent());
            } else {
                this.extractMessageFromProperty(builder, node.getFirstChild(), node);
            }
        }
        catch (MalformedException malformedException) {
            this.compiler.report(nodeTraversal.makeError(malformedException.getNode(), MESSAGE_TREE_MALFORMED, malformedException.getMessage()));
            return;
        }
        JsMessage jsMessage = builder.build(this.idGenerator);
        if (this.needToCheckDuplications && !bl4 && !jsMessage.isExternal()) {
            this.checkIfMessageDuplicated(nodeTraversal.getSourceName(), string, node4);
        }
        if (jsMessage.isEmpty()) {
            this.compiler.report(nodeTraversal.makeError(node, MESSAGE_HAS_NO_TEXT, string));
        }
        String string2 = jsMessage.getDesc();
        if (bl && (string2 == null || string2.trim().isEmpty()) && !jsMessage.isExternal()) {
            this.compiler.report(nodeTraversal.makeError(node, MESSAGE_HAS_NO_DESCRIPTION, string));
        }
        JsMessageDefinition jsMessageDefinition = new JsMessageDefinition(node, node4, node3);
        this.processJsMessage(jsMessage, jsMessageDefinition);
    }

    private void checkIfMessageDuplicated(String string, String string2, Node node) {
        if (this.messageNames.containsKey(string2)) {
            MessageLocation messageLocation = this.messageNames.get(string2);
            this.compiler.report(JSError.make(string, node, MESSAGE_DUPLICATE_KEY, string2, messageLocation.sourceName, Integer.toString(messageLocation.lineNo)));
        } else {
            MessageLocation messageLocation = new MessageLocation(string, node.getLineno());
            this.messageNames.put(string2, messageLocation);
        }
    }

    private void extractMessageFromVariable(JsMessage.Builder builder, Node node, Node node2, @Nullable Node node3) throws MalformedException {
        Node node4 = node.getFirstChild();
        switch (node4.getType()) {
            case 21: 
            case 40: {
                this.maybeInitMetaDataFromJsDocOrHelpVar(builder, node2, node3);
                builder.appendStringPart(JsMessageVisitor.extractStringFromStringExprNode(node4));
                break;
            }
            case 105: {
                this.maybeInitMetaDataFromJsDocOrHelpVar(builder, node2, node3);
                this.extractFromFunctionNode(builder, node4);
                break;
            }
            case 37: {
                this.maybeInitMetaDataFromJsDoc(builder, node2);
                this.extractFromCallNode(builder, node4);
                break;
            }
            default: {
                throw new MalformedException("Cannot parse value of message " + builder.getKey(), node4);
            }
        }
    }

    private void extractMessageFromProperty(JsMessage.Builder builder, Node node, Node node2) throws MalformedException {
        Node node3 = node.getNext();
        this.maybeInitMetaDataFromJsDoc(builder, node2);
        this.extractFromCallNode(builder, node3);
    }

    private void maybeInitMetaDataFromJsDocOrHelpVar(JsMessage.Builder builder, Node node, @Nullable Node node2) throws MalformedException {
        if (this.maybeInitMetaDataFromJsDoc(builder, node)) {
            return;
        }
        if (node2 != null && this.maybeInitMetaDataFromHelpVar(builder, node2.getChildBefore(node))) {
            return;
        }
        this.maybeInitMetaDataFromHelpVar(builder, node.getNext());
    }

    private boolean maybeInitMetaDataFromHelpVar(JsMessage.Builder builder, @Nullable Node node) throws MalformedException {
        Node node2;
        String string;
        if (node != null && node.getType() == 118 && (string = (node2 = node.getFirstChild()).getString()).equals(builder.getKey() + DESC_SUFFIX)) {
            Node node3 = node2.getFirstChild();
            String string2 = JsMessageVisitor.extractStringFromStringExprNode(node3);
            if (string2.startsWith(HIDDEN_DESC_PREFIX)) {
                builder.setDesc(string2.substring(HIDDEN_DESC_PREFIX.length()).trim());
                builder.setIsHidden(true);
            } else {
                builder.setDesc(string2);
            }
            return true;
        }
        return false;
    }

    private boolean maybeInitMetaDataFromJsDoc(JsMessage.Builder builder, Node node) {
        boolean bl = false;
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        if (jSDocInfo != null) {
            String string = jSDocInfo.getDescription();
            if (string != null) {
                builder.setDesc(string);
                bl = true;
            }
            if (jSDocInfo.isHidden()) {
                builder.setIsHidden(true);
            }
            if (jSDocInfo.getMeaning() != null) {
                builder.setMeaning(jSDocInfo.getMeaning());
            }
        }
        return bl;
    }

    private static String extractStringFromStringExprNode(Node node) throws MalformedException {
        switch (node.getType()) {
            case 40: {
                return node.getString();
            }
            case 21: {
                StringBuilder stringBuilder = new StringBuilder();
                for (Node node2 : node.children()) {
                    stringBuilder.append(JsMessageVisitor.extractStringFromStringExprNode(node2));
                }
                return stringBuilder.toString();
            }
        }
        throw new MalformedException("STRING or ADD node expected; found: " + JsMessageVisitor.getReadableTokenName(node), node);
    }

    private void extractFromFunctionNode(JsMessage.Builder builder, Node node) throws MalformedException {
        HashSet hashSet = Sets.newHashSet();
        block5: for (Node node2 : node.children()) {
            switch (node2.getType()) {
                case 38: {
                    break;
                }
                case 83: {
                    for (Node node3 : node2.children()) {
                        if (node3.getType() != 38) continue;
                        String string = node3.getString();
                        if (hashSet.contains(string)) {
                            throw new MalformedException("Duplicate placeholder name: " + string, node3);
                        }
                        hashSet.add(string);
                    }
                    continue block5;
                }
                case 125: {
                    Node node3 = node2.getFirstChild();
                    if (node3.getType() != 4) {
                        throw new MalformedException("RETURN node expected; found: " + JsMessageVisitor.getReadableTokenName(node3), node3);
                    }
                    for (Node node4 : node3.children()) {
                        this.extractFromReturnDescendant(builder, node4);
                    }
                    for (String string : builder.getPlaceholders()) {
                        if (hashSet.contains(string)) continue;
                        throw new MalformedException("Unrecognized message placeholder referenced: " + string, node3);
                    }
                    continue block5;
                }
                default: {
                    throw new MalformedException("NAME, LP, or BLOCK node expected; found: " + JsMessageVisitor.getReadableTokenName(node), node2);
                }
            }
        }
    }

    private void extractFromReturnDescendant(JsMessage.Builder builder, Node node) throws MalformedException {
        switch (node.getType()) {
            case 40: {
                builder.appendStringPart(node.getString());
                break;
            }
            case 38: {
                builder.appendPlaceholderReference(node.getString());
                break;
            }
            case 21: {
                for (Node node2 : node.children()) {
                    this.extractFromReturnDescendant(builder, node2);
                }
                break;
            }
            default: {
                throw new MalformedException("STRING, NAME, or ADD node expected; found: " + JsMessageVisitor.getReadableTokenName(node), node);
            }
        }
    }

    private void extractFromCallNode(JsMessage.Builder builder, Node node) throws MalformedException {
        Object object;
        Object object2;
        if (node.getType() != 37) {
            throw new MalformedException("Message must be initialized using goog.getMsg function.", node);
        }
        Node node2 = node.getFirstChild();
        if (!MSG_FUNCTION_NAME.equals(node2.getQualifiedName())) {
            throw new MalformedException("Message initialized using unrecognized function. Please use goog.getMsg() instead.", node2);
        }
        Node node3 = node2.getNext();
        if (node3 == null) {
            throw new MalformedException("Message string literal expected", node3);
        }
        this.parseMessageTextNode(builder, node3);
        Node node4 = node3.getNext();
        HashSet hashSet = Sets.newHashSet();
        if (node4 != null) {
            if (node4.getType() != 64) {
                throw new MalformedException("OBJLIT node expected", node4);
            }
            for (object2 = node4.getFirstChild(); object2 != null; object2 = ((Node)object2).getNext()) {
                if (((Node)object2).getType() != 40) {
                    throw new MalformedException("STRING node expected as OBJLIT key", (Node)object2);
                }
                object = ((Node)object2).getString();
                if (!JsMessageVisitor.isLowerCamelCaseWithNumericSuffixes((String)object)) {
                    throw new MalformedException("Placeholder name not in lowerCamelCase: " + (String)object, (Node)object2);
                }
                if (hashSet.contains(object)) {
                    throw new MalformedException("Duplicate placeholder name: " + (String)object, (Node)object2);
                }
                hashSet.add(object);
            }
        }
        object2 = builder.getPlaceholders();
        object = object2.iterator();
        while (object.hasNext()) {
            String string = object.next();
            if (hashSet.contains(string)) continue;
            throw new MalformedException("Unrecognized message placeholder referenced: " + string, node4);
        }
        for (String string : hashSet) {
            if (object2.contains(string)) continue;
            throw new MalformedException("Unused message placeholder: " + string, node4);
        }
    }

    private void parseMessageTextNode(JsMessage.Builder builder, Node node) throws MalformedException {
        String string = JsMessageVisitor.extractStringFromStringExprNode(node);
        while (true) {
            int n;
            int n2;
            if ((n2 = string.indexOf(PH_JS_PREFIX)) < 0) {
                builder.appendStringPart(string);
                return;
            }
            if (n2 > 0) {
                builder.appendStringPart(string.substring(0, n2));
            }
            if ((n = string.indexOf(PH_JS_SUFFIX, n2)) < 0) {
                throw new MalformedException("Placeholder incorrectly formatted in: " + builder.getKey(), node);
            }
            String string2 = string.substring(n2 + PH_JS_PREFIX.length(), n);
            builder.appendPlaceholderReference(string2);
            int n3 = n + PH_JS_SUFFIX.length();
            if (n3 >= string.length()) break;
            string = string.substring(n3);
        }
    }

    abstract void processJsMessage(JsMessage var1, JsMessageDefinition var2);

    boolean isMessageName(String string, boolean bl) {
        return string.startsWith(MSG_PREFIX) && (this.style == JsMessage.Style.CLOSURE || bl || !string.endsWith(DESC_SUFFIX));
    }

    private static boolean isUnnamedMessageName(String string) {
        return MSG_UNNAMED_PATTERN.matcher(string).matches();
    }

    static boolean isLowerCamelCaseWithNumericSuffixes(String string) {
        return CAMELCASE_PATTERN.matcher(string).matches();
    }

    private static String getReadableTokenName(Node node) {
        return Node.tokenToName(node.getType()).toUpperCase();
    }

    static String toLowerCamelCaseWithNumericSuffixes(String string) {
        int n = string.length();
        while (n > 0) {
            int n2;
            char c = '\u0000';
            for (n2 = n; n2 > 0 && Character.isDigit(c = string.charAt(n2 - 1)); --n2) {
            }
            if (n2 <= 0 || n2 >= n || c != '_') break;
            n = n2 - 1;
        }
        if (n == string.length()) {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string);
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, string.substring(0, n)) + string.substring(n);
    }

    private static class MessageLocation {
        private final String sourceName;
        private final int lineNo;

        private MessageLocation(String string, int n) {
            this.sourceName = string;
            this.lineNo = n;
        }
    }

    static class MalformedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Node node;

        MalformedException(String string, Node node) {
            super(string);
            this.node = node;
        }

        Node getNode() {
            return this.node;
        }
    }
}

