/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class MustBeReachingVariableDef
extends DataFlowAnalysis<Node, MustDef> {
    private final Scope jsScope;
    private final AbstractCompiler compiler;
    private final Set<Scope.Var> escaped;

    MustBeReachingVariableDef(ControlFlowGraph<Node> controlFlowGraph, Scope scope, AbstractCompiler abstractCompiler) {
        super(controlFlowGraph, new MustDefJoin());
        this.jsScope = scope;
        this.compiler = abstractCompiler;
        this.escaped = Sets.newHashSet();
        MustBeReachingVariableDef.computeEscaped(scope, this.escaped, abstractCompiler);
    }

    @Override
    boolean isForward() {
        return true;
    }

    @Override
    MustDef createEntryLattice() {
        return new MustDef(this.jsScope.getVars());
    }

    @Override
    MustDef createInitialEstimateLattice() {
        return new MustDef();
    }

    @Override
    MustDef flowThrough(Node node, MustDef mustDef) {
        MustDef mustDef2 = new MustDef(mustDef);
        this.computeMustDef(node, node, mustDef2, false);
        return mustDef2;
    }

    private void computeMustDef(Node node, Node node2, MustDef mustDef, boolean bl) {
        Node node3;
        switch (node.getType()) {
            case 105: 
            case 125: {
                return;
            }
            case 108: 
            case 113: 
            case 114: {
                this.computeMustDef(NodeUtil.getConditionExpression(node), node2, mustDef, bl);
                return;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.computeMustDef(NodeUtil.getConditionExpression(node), node2, mustDef, bl);
                } else {
                    Node node4 = node.getFirstChild();
                    Node node5 = node4.getNext();
                    if (NodeUtil.isVar(node4)) {
                        node4 = node4.getLastChild();
                    }
                    if (NodeUtil.isName(node4)) {
                        this.addToDefIfLocal(node4.getString(), node2, node5, mustDef);
                    }
                }
                return;
            }
            case 100: 
            case 101: {
                this.computeMustDef(node.getFirstChild(), node2, mustDef, bl);
                this.computeMustDef(node.getLastChild(), node2, mustDef, true);
                return;
            }
            case 98: {
                this.computeMustDef(node.getFirstChild(), node2, mustDef, bl);
                this.computeMustDef(node.getFirstChild().getNext(), node2, mustDef, true);
                this.computeMustDef(node.getLastChild(), node2, mustDef, true);
                return;
            }
            case 118: {
                for (Node node6 = node.getFirstChild(); node6 != null; node6 = node6.getNext()) {
                    if (!node6.hasChildren()) continue;
                    this.computeMustDef(node6.getFirstChild(), node2, mustDef, bl);
                    this.addToDefIfLocal(node6.getString(), bl ? null : node2, node6.getFirstChild(), mustDef);
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(node)) {
            if (NodeUtil.isName(node.getFirstChild())) {
                Node node7 = node.getFirstChild();
                this.computeMustDef(node7.getNext(), node2, mustDef, bl);
                this.addToDefIfLocal(node7.getString(), bl ? null : node2, node.getLastChild(), mustDef);
                return;
            }
            if (NodeUtil.isGet(node.getFirstChild()) && NodeUtil.isName(node3 = node.getFirstChild().getFirstChild()) && "arguments".equals(node3.getString())) {
                this.escapeParameters(mustDef);
            }
        }
        if (NodeUtil.isName(node) && "arguments".equals(node.getString())) {
            this.escapeParameters(mustDef);
        }
        if ((node.getType() == 103 || node.getType() == 102) && NodeUtil.isName(node3 = node.getFirstChild())) {
            this.addToDefIfLocal(node3.getString(), bl ? null : node2, null, mustDef);
            return;
        }
        for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            this.computeMustDef(node3, node2, mustDef, bl);
        }
    }

    private void addToDefIfLocal(String string, @Nullable Node node, @Nullable Node node2, MustDef mustDef) {
        Scope.Var var = this.jsScope.getVar(string);
        if (var == null || var.scope != this.jsScope) {
            return;
        }
        for (Scope.Var var2 : mustDef.reachingDef.keySet()) {
            Definition definition = mustDef.reachingDef.get(var2);
            if (definition == null || !definition.depends.contains(var)) continue;
            mustDef.reachingDef.put(var2, null);
        }
        if (!this.escaped.contains(var)) {
            if (node == null) {
                mustDef.reachingDef.put(var, null);
            } else {
                Definition definition = new Definition(node);
                if (node2 != null) {
                    this.computeDependence(definition, node2);
                }
                mustDef.reachingDef.put(var, definition);
            }
        }
    }

    private void escapeParameters(MustDef mustDef) {
        Iterator<Scope.Var> iterator = this.jsScope.getVars();
        while (iterator.hasNext()) {
            Scope.Var var = iterator.next();
            if (var.getParentNode().getType() != 83) continue;
            mustDef.reachingDef.put(var, null);
        }
    }

    private void computeDependence(final Definition definition, Node node) {
        NodeTraversal.traverse(this.compiler, node, new ControlFlowGraph.AbstractCfgNodeTraversalCallback(){

            @Override
            public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
                if (NodeUtil.isName(node) && MustBeReachingVariableDef.this.jsScope.isDeclared(node.getString(), true)) {
                    definition.depends.add(MustBeReachingVariableDef.this.jsScope.getVar(node.getString()));
                }
            }
        });
    }

    Node getDef(String string, Node node) {
        Preconditions.checkArgument((boolean)this.getCfg().hasNode(node));
        GraphNode graphNode = this.getCfg().getNode(node);
        DataFlowAnalysis.FlowState flowState = (DataFlowAnalysis.FlowState)graphNode.getAnnotation();
        Definition definition = ((MustDef)flowState.getIn()).reachingDef.get(this.jsScope.getVar(string));
        if (definition == null) {
            return null;
        }
        return definition.node;
    }

    boolean dependsOnOuterScopeVars(String string, Node node) {
        Preconditions.checkArgument((boolean)this.getCfg().hasNode(node));
        GraphNode graphNode = this.getCfg().getNode(node);
        DataFlowAnalysis.FlowState flowState = (DataFlowAnalysis.FlowState)graphNode.getAnnotation();
        Definition definition = ((MustDef)flowState.getIn()).reachingDef.get(this.jsScope.getVar(string));
        for (Scope.Var var : definition.depends) {
            if (var.scope == this.jsScope) continue;
            return true;
        }
        return false;
    }

    private static class MustDefJoin
    extends JoinOp.BinaryJoinOp<MustDef> {
        private MustDefJoin() {
        }

        @Override
        public MustDef apply(MustDef mustDef, MustDef mustDef2) {
            MustDef mustDef3 = new MustDef();
            Map<Scope.Var, Definition> map = mustDef3.reachingDef;
            for (Scope.Var var : mustDef.reachingDef.keySet()) {
                Definition definition = mustDef.reachingDef.get(var);
                if (definition == null) {
                    map.put(var, null);
                    continue;
                }
                Node node = definition.node;
                if (mustDef2.reachingDef.containsKey(var)) {
                    Definition definition2 = mustDef2.reachingDef.get(var);
                    if (definition.equals(definition2)) {
                        map.put(var, definition);
                        continue;
                    }
                    map.put(var, null);
                    continue;
                }
                map.put(var, definition);
            }
            for (Scope.Var var : mustDef2.reachingDef.keySet()) {
                if (mustDef.reachingDef.containsKey(var)) continue;
                map.put(var, mustDef2.reachingDef.get(var));
            }
            return mustDef3;
        }
    }

    static final class MustDef
    implements LatticeElement {
        final Map<Scope.Var, Definition> reachingDef;

        public MustDef() {
            this.reachingDef = Maps.newHashMap();
        }

        public MustDef(Iterator<Scope.Var> iterator) {
            this();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                this.reachingDef.put(var, new Definition(var.scope.getRootNode()));
            }
        }

        public MustDef(MustDef mustDef) {
            this.reachingDef = Maps.newHashMap(mustDef.reachingDef);
        }

        public boolean equals(Object object) {
            return object instanceof MustDef && ((Object)((MustDef)object).reachingDef).equals(this.reachingDef);
        }
    }

    private static class Definition {
        final Node node;
        final Set<Scope.Var> depends = Sets.newHashSet();

        Definition(Node node) {
            this.node = node;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Definition)) {
                return false;
            }
            Definition definition = (Definition)object;
            return definition.node == this.node;
        }
    }
}

