/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;

class NameReferenceGraphConstruction
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final NameReferenceGraph graph;
    private final Multimap<String, NameUse> unknownNameUse = HashMultimap.create();
    private static final boolean CONSERVATIVE = false;
    private final ArrayList<NameReferenceGraph.Name> currentFunctionStack = new ArrayList();

    NameReferenceGraphConstruction(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.graph = new NameReferenceGraph(abstractCompiler);
    }

    NameReferenceGraph getNameReferenceGraph() {
        return this.graph;
    }

    @Override
    public void process(Node node, Node node2) {
        ScopeCreator scopeCreator = this.compiler.getTypedScopeCreator();
        if (scopeCreator == null) {
            scopeCreator = new MemoizedScopeCreator(new TypedScopeCreator(this.compiler));
        }
        NodeTraversal nodeTraversal = new NodeTraversal(this.compiler, new Traversal(true), scopeCreator);
        NodeTraversal nodeTraversal2 = new NodeTraversal(this.compiler, new Traversal(false), scopeCreator);
        Scope scope = this.compiler.getTopScope();
        if (scope != null) {
            nodeTraversal.traverseWithScope(node, scope);
            nodeTraversal2.traverseWithScope(node2, scope);
        } else {
            nodeTraversal.traverse(node);
            nodeTraversal2.traverse(node2);
        }
        this.connectUnknowns();
    }

    private void connectUnknowns() {
        for (GraphNode graphNode : this.graph.getNodes()) {
            Collection collection;
            NameReferenceGraph.Name name = (NameReferenceGraph.Name)graphNode.getValue();
            String string = name.getPropertyName();
            if (string == null || (collection = this.unknownNameUse.get((Object)string)) == null) continue;
            for (NameUse nameUse : collection) {
                this.graph.connect(nameUse.name, nameUse.reference, name);
            }
        }
    }

    private JSType getType(Node node) {
        JSType jSType = node.getJSType();
        if (jSType == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jSType.restrictByNotNullOrUndefined();
    }

    private void pushContainingFunction(NameReferenceGraph.Name name) {
        this.currentFunctionStack.add(name);
    }

    private void popContainingFunction() {
        this.currentFunctionStack.remove(this.currentFunctionStack.size() - 1);
    }

    private NameReferenceGraph.Name getNamedContainingFunction() {
        NameReferenceGraph.Name name = null;
        for (int i = this.currentFunctionStack.size() - 1; i >= 0; --i) {
            NameReferenceGraph.Name name2 = this.currentFunctionStack.get(i);
            if (name2 == this.graph.UNKNOWN) continue;
            name = name2;
            break;
        }
        Preconditions.checkNotNull(name);
        return name;
    }

    private static class NameUse {
        private final NameReferenceGraph.Name name;
        private final NameReferenceGraph.Reference reference;

        private NameUse(NameReferenceGraph.Name name, NameReferenceGraph.Reference reference) {
            this.name = name;
            this.reference = reference;
        }
    }

    private class Traversal
    implements NodeTraversal.ScopedCallback {
        final boolean isExtern;

        private Traversal(boolean bl) {
            this.isExtern = bl;
            NameReferenceGraphConstruction.this.pushContainingFunction(((NameReferenceGraphConstruction)NameReferenceGraphConstruction.this).graph.MAIN);
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            Node node = nodeTraversal.getScopeRoot();
            Node node2 = node.getParent();
            if (!nodeTraversal.inGlobalScope()) {
                String string = NodeUtil.getFunctionName(node);
                if (string == null) {
                    NameReferenceGraphConstruction.this.pushContainingFunction(((NameReferenceGraphConstruction)NameReferenceGraphConstruction.this).graph.UNKNOWN);
                    return;
                }
                JSType jSType = NameReferenceGraphConstruction.this.getType(node);
                Node node3 = node2.getParent();
                Node node4 = node3.getParent();
                if (NodeUtil.isAssign(node2) && NodeUtil.isPrototypeProperty(node2.getFirstChild())) {
                    NameReferenceGraphConstruction.this.pushContainingFunction(this.recordPrototypePropDefinition(nodeTraversal, node2.getFirstChild(), jSType, node2, node3, node4));
                } else {
                    NameReferenceGraphConstruction.this.pushContainingFunction(this.recordStaticNameDefinition(nodeTraversal, string, jSType, node, node2, node3, node.getLastChild()));
                }
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            if (!nodeTraversal.inGlobalScope()) {
                NameReferenceGraphConstruction.this.popContainingFunction();
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: 
                case 38: {
                    if (NodeUtil.isGetProp(node2) || node2.getType() == 69) {
                        return;
                    }
                    if (NodeUtil.isFunction(node2)) {
                        return;
                    }
                    if (NodeUtil.isAssign(node2)) {
                        return;
                    }
                    if (this.isLocalNameReference(nodeTraversal, node)) {
                        return;
                    }
                    if (this.isPrototypeNameReference(node)) {
                        this.recordPrototypePropUse(nodeTraversal, node, node2);
                        break;
                    }
                    if (this.isStaticNameReference(node, nodeTraversal.getScope())) {
                        this.recordStaticNameUse(nodeTraversal, node, node2);
                        break;
                    }
                    this.recordUnknownUse(nodeTraversal, node, node2);
                    break;
                }
                case 86: {
                    Node node3 = node.getFirstChild();
                    Node node4 = node.getLastChild();
                    if (NodeUtil.isFunction(node4)) {
                        return;
                    }
                    if ((NodeUtil.isName(node3) || NodeUtil.isGetProp(node3) || NodeUtil.isGetProp(node4)) && NodeUtil.isPrototypeProperty(node3)) {
                        NameReferenceGraph.Name name = this.recordPrototypePropDefinition(nodeTraversal, node3, NameReferenceGraphConstruction.this.getType(node4), node, node2, node2.getParent());
                        name.setAliased(true);
                    }
                    this.maybeAliasNamesOnAssign(node3, node4);
                    break;
                }
                case 118: {
                    Node node5 = node.getFirstChild();
                    Node node6 = node5.getFirstChild();
                    if (node6 == null) {
                        return;
                    }
                    this.maybeAliasNamesOnAssign(node5, node6);
                    break;
                }
                case 37: {
                    Node node7 = node.getFirstChild();
                    while ((node7 = node7.getNext()) != null) {
                        if (!NodeUtil.isName(node7) && !NodeUtil.isGetProp(node7)) continue;
                        this.safeAlias(node7);
                    }
                    this.maybeRecordExport(node);
                }
            }
        }

        private boolean containsName(Node node) {
            return NodeUtil.containsType(node, 38) || NodeUtil.containsType(node, 35) || NodeUtil.containsType(node, 33);
        }

        private void safeAlias(Node node) {
            Object object;
            if ((NodeUtil.isName(node) || NodeUtil.isGetProp(node)) && (object = node.getQualifiedName()) != null) {
                this.defineAndAlias((String)object);
                return;
            }
            if (NodeUtil.isGetProp(node)) {
                this.defineAndAlias(node.getLastChild().getString());
            } else if (NodeUtil.isAssign(node)) {
                this.safeAlias(node.getFirstChild());
            } else if (node.hasChildren()) {
                object = node.getFirstChild();
                do {
                    this.safeAlias((Node)object);
                } while ((object = ((Node)object).getNext()) != null);
            }
        }

        private void maybeAliasNamesOnAssign(Node node, Node node2) {
            if ((NodeUtil.isName(node) || NodeUtil.isGetProp(node)) && this.containsName(node2) && !NodeUtil.isFunction(node2) && !NodeUtil.isNew(node2)) {
                this.safeAlias(node);
                this.safeAlias(node2);
            }
        }

        private void defineAndAlias(String string) {
            NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(string, this.isExtern).setAliased(true);
        }

        private void maybeRecordExport(Node node) {
            Preconditions.checkArgument((boolean)NodeUtil.isCall(node));
            Node node2 = node.getFirstChild();
            if (!NodeUtil.isGetProp(node2)) {
                return;
            }
            String string = node2.getQualifiedName();
            if (string == null) {
                return;
            }
            if (string.endsWith(".call") || string.endsWith(".apply")) {
                NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(node2.getFirstChild().getQualifiedName(), this.isExtern).markExposedToCallOrApply();
            }
            if (!"goog.exportSymbol".equals(string)) {
                return;
            }
            Node node3 = node2.getNext();
            if (!NodeUtil.isString(node3)) {
                return;
            }
            Node node4 = node3.getNext();
            String string2 = node4.getQualifiedName();
            if (string2 == null || node4.getNext() != null) {
                return;
            }
            NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(string2, false).markExported();
        }

        private boolean isLocalNameReference(NodeTraversal nodeTraversal, Node node) {
            if (NodeUtil.isName(node)) {
                Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
                return var != null && var.isLocal();
            }
            return false;
        }

        private boolean isStaticNameReference(Node node, Scope scope) {
            Preconditions.checkArgument((NodeUtil.isName(node) || NodeUtil.isGetProp(node) ? 1 : 0) != 0);
            if (NodeUtil.isName(node)) {
                return true;
            }
            String string = node.getQualifiedName();
            if (string == null) {
                return false;
            }
            return scope.isDeclared(string, true);
        }

        private boolean isPrototypeNameReference(Node node) {
            if (!NodeUtil.isGetProp(node)) {
                return false;
            }
            JSType jSType = NameReferenceGraphConstruction.this.getType(node.getFirstChild());
            if (jSType.isUnknownType() || jSType.isUnionType()) {
                return false;
            }
            return jSType instanceof InstanceObjectType || jSType.autoboxesTo() != null;
        }

        private NameReferenceGraph.Name recordStaticNameDefinition(NodeTraversal nodeTraversal, String string, JSType jSType, Node node, Node node2, Node node3, Node node4) {
            if (NameReferenceGraphConstruction.this.getNamedContainingFunction() != ((NameReferenceGraphConstruction)NameReferenceGraphConstruction.this).graph.MAIN) {
                // empty if block
            }
            if (jSType.isFunctionType() && jSType.isConstructor()) {
                return this.recordClassConstructorOrInterface(string, (FunctionType)jSType, node, node2, node2.getParent(), node4);
            }
            NameReferenceGraph.Name name = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(string, this.isExtern);
            name.setType(jSType);
            if (NodeUtil.isAssign(node)) {
                name.addAssignmentDeclaration(node);
            } else {
                name.addFunctionDeclaration(node);
            }
            return name;
        }

        private NameReferenceGraph.Name recordPrototypePropDefinition(NodeTraversal nodeTraversal, Node node, JSType jSType, @Nullable Node node2, @Nullable Node node3, @Nullable Node node4) {
            JSType jSType2 = NameReferenceGraphConstruction.this.getType(NodeUtil.getPrototypeClassName(node));
            FunctionType functionType = null;
            String string = null;
            if (jSType2 instanceof FunctionType && jSType2.isConstructor()) {
                functionType = (FunctionType)jSType2;
                string = functionType.getReferenceName();
            } else {
                functionType = NameReferenceGraphConstruction.this.compiler.getTypeRegistry().getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
                string = NodeUtil.getPrototypeClassName(node).getQualifiedName();
            }
            this.recordClassConstructorOrInterface(string, functionType, null, null, null, null);
            String string2 = string + ".prototype." + NodeUtil.getPrototypePropertyName(node);
            NameReferenceGraph.Name name = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(string2, this.isExtern);
            Preconditions.checkNotNull((Object)name, (Object)(string2 + " should be in the name graph as a node."));
            if (node2 != null) {
                name.addAssignmentDeclaration(node2);
            }
            name.setType(jSType);
            return name;
        }

        private NameReferenceGraph.Reference recordStaticNameUse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (this.isExtern) {
                return null;
            }
            NameReferenceGraph.Reference reference = new NameReferenceGraph.Reference(node, node2);
            NameReferenceGraph.Name name = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(node.getQualifiedName(), this.isExtern);
            name.setType(NameReferenceGraphConstruction.this.getType(node));
            NameReferenceGraphConstruction.this.graph.connect(NameReferenceGraphConstruction.this.getNamedContainingFunction(), reference, name);
            return reference;
        }

        private void recordPrototypePropUse(NodeTraversal nodeTraversal, Node node, Node node2) {
            Preconditions.checkArgument((boolean)NodeUtil.isGetProp(node));
            Node node3 = node.getFirstChild();
            JSType jSType = NameReferenceGraphConstruction.this.getType(node3);
            JSType jSType2 = jSType.autoboxesTo();
            jSType = jSType2 != null ? jSType2 : jSType;
            ObjectType objectType = jSType.toObjectType();
            Preconditions.checkState((objectType != null ? 1 : 0) != 0);
            if (!this.isExtern) {
                NameReferenceGraph.Reference reference = new NameReferenceGraph.Reference(node, node2);
                FunctionType functionType = objectType.getConstructor();
                if (functionType != null) {
                    String string = node.getLastChild().getString();
                    if (!functionType.getPrototype().hasOwnProperty(string)) {
                        this.recordSuperClassPrototypePropUse(functionType, string, reference);
                    }
                    this.recordSubclassPrototypePropUse(functionType, string, reference);
                } else {
                    this.recordUnknownUse(nodeTraversal, node, node2);
                }
            }
        }

        private void recordSuperClassPrototypePropUse(FunctionType functionType, String string, NameReferenceGraph.Reference reference) {
            for (FunctionType functionType2 = functionType.getSuperClassConstructor(); functionType2 != null; functionType2 = functionType2.getSuperClassConstructor()) {
                if (!functionType2.getPrototype().hasOwnProperty(string)) continue;
                NameReferenceGraphConstruction.this.graph.connect(NameReferenceGraphConstruction.this.getNamedContainingFunction(), reference, NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(functionType2.getReferenceName() + ".prototype." + string, false));
                return;
            }
        }

        private void recordSubclassPrototypePropUse(FunctionType functionType, String string, NameReferenceGraph.Reference reference) {
            if (functionType.getPrototype().hasOwnProperty(string)) {
                NameReferenceGraphConstruction.this.graph.connect(NameReferenceGraphConstruction.this.getNamedContainingFunction(), reference, NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(functionType.getReferenceName() + ".prototype." + string, false));
            }
            if (functionType.getSubTypes() != null) {
                for (FunctionType functionType2 : functionType.getSubTypes()) {
                    this.recordSubclassPrototypePropUse(functionType2, string, reference);
                }
            }
        }

        private void recordUnknownUse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (this.isExtern) {
                return;
            }
            Preconditions.checkArgument((boolean)NodeUtil.isGetProp(node));
            NameReferenceGraph.Reference reference = new NameReferenceGraph.Reference(node, node2);
            reference.setUnknown(true);
            NameReferenceGraphConstruction.this.unknownNameUse.put((Object)node.getLastChild().getString(), (Object)new NameUse(NameReferenceGraphConstruction.this.getNamedContainingFunction(), reference));
        }

        private NameReferenceGraph.Name recordClassConstructorOrInterface(String string, FunctionType functionType, @Nullable Node node, @Nullable Node node2, @Nullable Node node3, @Nullable Node node4) {
            Preconditions.checkArgument((functionType.isConstructor() || functionType.isInterface() ? 1 : 0) != 0);
            NameReferenceGraph.Name name = NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(string, this.isExtern);
            if (node4 != null) {
                name.setType(NameReferenceGraphConstruction.this.getType(node4));
                if (NodeUtil.isAssign(node)) {
                    name.addAssignmentDeclaration(node);
                } else {
                    name.addFunctionDeclaration(node);
                }
            }
            FunctionPrototypeType functionPrototypeType = functionType.getPrototype();
            for (String string2 : ((ObjectType)functionPrototypeType).getOwnPropertyNames()) {
                NameReferenceGraphConstruction.this.graph.defineNameIfNotExists(string + ".prototype." + string2, this.isExtern);
            }
            return name;
        }
    }
}

