/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.CodeGenerator;
import com.google.javascript.rhino.Node;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class PerformanceTracker {
    private final Node jsRoot;
    private final boolean trackGzippedSize;
    private final CodeChangeHandler.RecentChange codeChange = new CodeChangeHandler.RecentChange();
    private int curCodeSizeEstimate = -1;
    private int curZippedCodeSizeEstimate = -1;
    private Deque<String> currentRunningPass = new ArrayDeque<String>();
    private final Map<String, Long> runtimeRecord = Maps.newHashMap();
    private final Map<String, Integer> codeSizeRecord = Maps.newHashMap();
    private final Map<String, Integer> zippedCodeSizeRecord = Maps.newHashMap();

    PerformanceTracker(Node node, boolean bl) {
        this.jsRoot = node;
        this.trackGzippedSize = bl;
    }

    CodeChangeHandler getCodeChangeHandler() {
        return this.codeChange;
    }

    void recordPassStart(String string) {
        this.currentRunningPass.push(string);
        this.codeChange.reset();
    }

    void recordPassStop(String string, long l) {
        String string2 = this.currentRunningPass.pop();
        if (!string.equals(string2)) {
            throw new RuntimeException(string + " is not running.");
        }
        Long l2 = this.runtimeRecord.get(string);
        if (l2 == null) {
            l2 = 0L;
        }
        l2 = l2 + l;
        this.runtimeRecord.put(string, l2);
        if (this.codeChange.hasCodeChanged()) {
            CodeSizeEstimatePrinter codeSizeEstimatePrinter = this.estimateCodeSize(this.jsRoot);
            this.curCodeSizeEstimate = PerformanceTracker.recordSizeChange(this.curCodeSizeEstimate, codeSizeEstimatePrinter.calcSize(), string, this.codeSizeRecord);
            this.curZippedCodeSizeEstimate = PerformanceTracker.recordSizeChange(this.curZippedCodeSizeEstimate, codeSizeEstimatePrinter.calcZippedSize(), string, this.zippedCodeSizeRecord);
        }
    }

    private static int recordSizeChange(int n, int n2, String string, Map<String, Integer> map) {
        if (n != -1) {
            int n3 = n - n2;
            Integer n4 = map.get(string);
            if (n3 > 0) {
                n4 = n4 == null ? Integer.valueOf(n3) : Integer.valueOf(n4 + n3);
                map.put(string, n4);
            }
        }
        return n2;
    }

    public ImmutableMap<String, Long> getRuntimeRecord() {
        return ImmutableMap.copyOf(this.runtimeRecord);
    }

    public ImmutableMap<String, Integer> getCodeSizeRecord() {
        return ImmutableMap.copyOf(this.codeSizeRecord);
    }

    public ImmutableMap<String, Integer> getZippedCodeSizeRecord() {
        return ImmutableMap.copyOf(this.zippedCodeSizeRecord);
    }

    private final CodeSizeEstimatePrinter estimateCodeSize(Node node) {
        CodeSizeEstimatePrinter codeSizeEstimatePrinter = new CodeSizeEstimatePrinter(this.trackGzippedSize);
        CodeGenerator codeGenerator = new CodeGenerator(codeSizeEstimatePrinter);
        codeGenerator.add(node);
        return codeSizeEstimatePrinter;
    }

    private static final class CodeSizeEstimatePrinter
    extends CodeConsumer {
        private final boolean trackGzippedSize;
        private int size = 0;
        private char lastChar = '\u0000';
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();
        private final GZIPOutputStream stream;

        private CodeSizeEstimatePrinter(boolean bl) {
            this.trackGzippedSize = bl;
            try {
                this.stream = new GZIPOutputStream(this.output);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        void append(String string) {
            int n = string.length();
            if (n > 0) {
                this.size += n;
                this.lastChar = string.charAt(n - 1);
                if (this.trackGzippedSize) {
                    try {
                        this.stream.write(string.getBytes());
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
        }

        @Override
        char getLastChar() {
            return this.lastChar;
        }

        private int calcSize() {
            return this.size;
        }

        private int calcZippedSize() {
            if (this.trackGzippedSize) {
                try {
                    this.stream.finish();
                    this.stream.flush();
                    this.stream.close();
                    return this.output.size();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            return -1;
        }
    }
}

