/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzeNameReferences;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameReferenceGraph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.rhino.Node;
import java.util.logging.Logger;

class RemoveUnusedNames
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(RemoveUnusedNames.class.getName());
    private final AbstractCompiler compiler;
    private final boolean canModifyExterns;

    RemoveUnusedNames(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.canModifyExterns = bl;
    }

    @Override
    public void process(Node node, Node node2) {
        AnalyzeNameReferences analyzeNameReferences = new AnalyzeNameReferences(this.compiler);
        analyzeNameReferences.process(node, node2);
        this.removeUnusedProperties(analyzeNameReferences.getGraph());
    }

    private void removeUnusedProperties(NameReferenceGraph nameReferenceGraph) {
        for (GraphNode graphNode : nameReferenceGraph.getNodes()) {
            NameReferenceGraph.Name name = (NameReferenceGraph.Name)graphNode.getValue();
            AnalyzeNameReferences.NameInfo nameInfo = (AnalyzeNameReferences.NameInfo)graphNode.getAnnotation();
            if (nameInfo != null && nameInfo.isReferenced() || !this.canModifyExterns && name.isExtern()) continue;
            name.remove();
            this.compiler.reportCodeChange();
            logger.fine("Removed unused name" + name);
        }
    }
}

