/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class RenameLabels
implements CompilerPass {
    private final AbstractCompiler compiler;

    RenameLabels(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new ProcessLabels());
    }

    private static class LabelNamespace {
        final Map<String, LabelInfo> renameMap = new HashMap<String, LabelInfo>();

        private LabelNamespace() {
        }
    }

    private static class LabelInfo {
        boolean referenced = false;
        final int id;

        LabelInfo(int n) {
            this.id = n;
        }
    }

    class ProcessLabels
    implements NodeTraversal.ScopedCallback {
        final Deque<LabelNamespace> namespaceStack = Lists.newLinkedList();
        final NameGenerator nameGenerator = new NameGenerator(new HashSet<String>(), "", null);
        final ArrayList<String> names = new ArrayList();

        ProcessLabels() {
            this.namespaceStack.push(new LabelNamespace());
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            this.namespaceStack.push(new LabelNamespace());
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            this.namespaceStack.pop();
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 126) {
                LabelNamespace labelNamespace = this.namespaceStack.peek();
                int n = labelNamespace.renameMap.size() + 1;
                String string = node.getFirstChild().getString();
                LabelInfo labelInfo = new LabelInfo(n);
                Preconditions.checkState((!labelNamespace.renameMap.containsKey(string) ? 1 : 0) != 0);
                labelNamespace.renameMap.put(string, labelInfo);
                if (this.names.size() < n) {
                    this.names.add(this.nameGenerator.generateNextName());
                }
                String string2 = this.getNameForId(n);
                RenameLabels.this.compiler.addToDebugLog("label renamed: " + string + " => " + string2);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 126: {
                    this.visitLabel(node, node2);
                    break;
                }
                case 116: 
                case 117: {
                    this.visitBreakOrContinue(node);
                }
            }
        }

        private void visitBreakOrContinue(Node node) {
            Node node2 = node.getFirstChild();
            if (node2 != null) {
                String string = node2.getString();
                Preconditions.checkState((string.length() != 0 ? 1 : 0) != 0);
                LabelInfo labelInfo = this.getLabelInfo(string);
                if (labelInfo != null) {
                    String string2 = this.getNameForId(labelInfo.id);
                    labelInfo.referenced = true;
                    if (!string.equals(string2)) {
                        node2.setString(string2);
                        RenameLabels.this.compiler.reportCodeChange();
                    }
                }
            }
        }

        private void visitLabel(Node node, Node node2) {
            Node node3 = node.getFirstChild();
            Preconditions.checkState((node3 != null ? 1 : 0) != 0);
            String string = node3.getString();
            LabelInfo labelInfo = this.getLabelInfo(string);
            if (labelInfo.referenced) {
                String string2 = this.getNameForId(labelInfo.id);
                if (!string.equals(string2)) {
                    node3.setString(string2);
                    RenameLabels.this.compiler.reportCodeChange();
                }
            } else {
                Node node4 = node.getLastChild();
                node.removeChild(node4);
                node2.replaceChild(node, node4);
                if (node4.getType() == 125) {
                    NodeUtil.tryMergeBlock(node4);
                }
                RenameLabels.this.compiler.reportCodeChange();
            }
            this.namespaceStack.peek().renameMap.remove(string);
        }

        String getNameForId(int n) {
            return this.names.get(n - 1);
        }

        LabelInfo getLabelInfo(String string) {
            return this.namespaceStack.peek().renameMap.get(string);
        }
    }
}

