/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

class ShadowVariables
implements CompilerPass {
    private final Multimap<Node, String> scopeUpRefMap = HashMultimap.create();
    private final Multimap<Scope.Var, Node> varToNameUsage = HashMultimap.create();
    private final AbstractCompiler compiler;
    private final SortedSet<RenameVars.Assignment> varsByFrequency;
    private final SortedMap<String, RenameVars.Assignment> assignments;
    private final Map<Node, String> pseudoNameMap;

    ShadowVariables(AbstractCompiler abstractCompiler, SortedMap<String, RenameVars.Assignment> sortedMap, SortedSet<RenameVars.Assignment> sortedSet, Map<Node, String> map) {
        this.compiler = abstractCompiler;
        this.assignments = sortedMap;
        this.varsByFrequency = sortedSet;
        this.pseudoNameMap = map;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new GatherReferenceInfo());
        NodeTraversal.traverse(this.compiler, node2, new DoShadowVariables());
    }

    private class DoShadowVariables
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private DoShadowVariables() {
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            Scope scope = nodeTraversal.getScope();
            if (!scope.isLocal()) {
                return;
            }
            if (scope.getParent().isGlobal()) {
                return;
            }
            Iterator<Scope.Var> iterator = scope.getVars();
            while (iterator.hasNext()) {
                RenameVars.Assignment assignment;
                Scope.Var var = iterator.next();
                if (var.isBleedingFunction() || ShadowVariables.this.compiler.getCodingConvention().isExported(var.name, scope.isLocal()) || (assignment = this.findBestShadow(scope, var)) == null) continue;
                RenameVars.Assignment assignment2 = (RenameVars.Assignment)ShadowVariables.this.assignments.get(var.getName());
                if (assignment.count < assignment2.count) continue;
                this.doShadow(assignment2, assignment, var);
                if (ShadowVariables.this.pseudoNameMap == null) continue;
                String string = (String)ShadowVariables.this.pseudoNameMap.get(scope.getVar((String)assignment.oldName).nameNode);
                for (Node node : ShadowVariables.this.varToNameUsage.get((Object)var)) {
                    ShadowVariables.this.pseudoNameMap.put(node, string);
                }
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }

        private RenameVars.Assignment findBestShadow(Scope scope, Scope.Var var) {
            for (RenameVars.Assignment assignment : ShadowVariables.this.varsByFrequency) {
                if (!assignment.oldName.startsWith("L ") || ShadowVariables.this.scopeUpRefMap.get((Object)scope.getRootNode()).contains(assignment.oldName) || !scope.isDeclared(assignment.oldName, true)) continue;
                return assignment;
            }
            return null;
        }

        private void doShadow(RenameVars.Assignment assignment, RenameVars.Assignment assignment2, Scope.Var var) {
            Scope scope = var.getScope();
            Collection collection = ShadowVariables.this.varToNameUsage.get((Object)var);
            ShadowVariables.this.varsByFrequency.remove(assignment);
            ShadowVariables.this.varsByFrequency.remove(assignment2);
            assignment.count -= collection.size();
            assignment2.count += collection.size();
            ShadowVariables.this.varsByFrequency.add(assignment);
            ShadowVariables.this.varsByFrequency.add(assignment2);
            Scope.Var var2 = scope.getVar(assignment2.oldName);
            if (var2 != null) {
                for (Object object = scope; object != var2.scope; object = ((Scope)object).getParent()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)((Scope)object).getRootNode(), (Object)assignment2.oldName);
                }
            }
            for (Node node : collection) {
                node.setString(assignment2.oldName);
                Node node2 = node;
                while (node2 != scope.getRootNode()) {
                    if (!NodeUtil.isFunction(node2 = node2.getParent())) continue;
                    ShadowVariables.this.scopeUpRefMap.put((Object)node2, (Object)assignment2.oldName);
                }
            }
        }
    }

    private class GatherReferenceInfo
    extends NodeTraversal.AbstractPostOrderCallback {
        private GatherReferenceInfo() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (!NodeUtil.isReferenceName(node)) {
                return;
            }
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
            if (var == null) {
                return;
            }
            if (var.getScope().isGlobal()) {
                return;
            }
            if (var.getScope() != nodeTraversal.getScope()) {
                for (Scope scope = nodeTraversal.getScope(); scope != var.getScope() && scope.isLocal(); scope = scope.getParent()) {
                    ShadowVariables.this.scopeUpRefMap.put((Object)scope.getRootNode(), (Object)var.name);
                }
            }
            if (var.getScope() == nodeTraversal.getScope()) {
                ShadowVariables.this.scopeUpRefMap.put((Object)nodeTraversal.getScopeRoot(), (Object)var.name);
            }
            ShadowVariables.this.varToNameUsage.put((Object)var, (Object)node);
        }
    }
}

