/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

public class StatementFusion
extends AbstractPeepholeOptimization {
    @Override
    Node optimizeSubtree(Node node) {
        if (!NodeUtil.isFunction(node.getParent()) && StatementFusion.canFuseIntoOneStatement(node)) {
            this.fuseIntoOneStatement(node);
            this.reportCodeChange();
        }
        return node;
    }

    private static boolean canFuseIntoOneStatement(Node node) {
        if (node.getType() != 125) {
            return false;
        }
        if (!node.hasChildren() || node.hasOneChild()) {
            return false;
        }
        Node node2 = node.getLastChild();
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNext()) {
            if (NodeUtil.isExpressionNode(node3) || node3 == node2) continue;
            return false;
        }
        switch (node2.getType()) {
            case 49: 
            case 108: 
            case 110: 
            case 130: {
                return true;
            }
            case 4: {
                return node2.hasChildren();
            }
            case 115: {
                return NodeUtil.isForIn(node2);
            }
        }
        return false;
    }

    private void fuseIntoOneStatement(Node node) {
        Node node2;
        Node node3 = node.removeFirstChild();
        Node node4 = node3.removeFirstChild();
        while (node.hasMoreThanOneChild()) {
            node2 = node.removeFirstChild().removeFirstChild();
            node4 = StatementFusion.fuseExpressionIntoExpression(node4, node2);
        }
        Preconditions.checkState((boolean)node.hasOneChild());
        node2 = node.getLastChild();
        switch (node2.getType()) {
            case 4: 
            case 49: 
            case 108: 
            case 110: 
            case 130: {
                StatementFusion.fuseExpresssonIntoFirstChild(node4, node2);
                return;
            }
            case 115: {
                if (NodeUtil.isForIn(node2)) {
                    StatementFusion.fuseExpresssonIntoSecondChild(node4, node2);
                }
                return;
            }
        }
        throw new IllegalStateException("Statement fusion missing.");
    }

    private static Node fuseExpressionIntoExpression(Node node, Node node2) {
        Node node3 = new Node(85, node);
        node3.copyInformationFrom(node2);
        if (node2.getType() == 85) {
            Node node4 = node2;
            while (node4.getType() == 85) {
                node4 = node4.getFirstChild();
            }
            Node node5 = node4.getParent();
            node3.addChildToBack(node4.detachFromParent());
            node5.addChildToFront(node3);
            return node2;
        }
        node3.addChildToBack(node2);
        return node3;
    }

    private static void fuseExpresssonIntoFirstChild(Node node, Node node2) {
        Node node3 = node2.removeFirstChild();
        Node node4 = StatementFusion.fuseExpressionIntoExpression(node, node3);
        node2.addChildToFront(node4);
    }

    private static void fuseExpresssonIntoSecondChild(Node node, Node node2) {
        Node node3 = node2.removeChildAfter(node2.getFirstChild());
        Node node4 = StatementFusion.fuseExpressionIntoExpression(node, node3);
        node2.addChildAfter(node4, node2.getFirstChild());
    }
}

