/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.parsing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.mozilla.rhino.ErrorReporter;
import com.google.javascript.jscomp.mozilla.rhino.ast.Comment;
import com.google.javascript.jscomp.parsing.Annotation;
import com.google.javascript.jscomp.parsing.Config;
import com.google.javascript.jscomp.parsing.JsDocToken;
import com.google.javascript.jscomp.parsing.JsDocTokenStream;
import com.google.javascript.jscomp.parsing.NullErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ScriptRuntime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class JsDocInfoParser {
    private final JsDocTokenStream stream;
    private final JSDocInfoBuilder jsdocBuilder;
    private final String sourceName;
    private final ErrorReporter errorReporter;
    private final ErrorReporterParser parser = new ErrorReporterParser();
    private final Node templateNode;
    private JSDocInfo fileOverviewJSDocInfo = null;
    private State state;
    private final Map<String, Annotation> annotationNames;
    private final Set<String> suppressionNames;
    private static final Set<String> modifiesAnnotationKeywords = ImmutableSet.of((Object)"this", (Object)"arguments");
    private Node.FileLevelJsDocBuilder fileLevelJsDocBuilder;
    private static final JsDocToken NO_UNREAD_TOKEN = null;
    private JsDocToken unreadToken = NO_UNREAD_TOKEN;

    void setFileLevelJsDocBuilder(Node.FileLevelJsDocBuilder fileLevelJsDocBuilder) {
        this.fileLevelJsDocBuilder = fileLevelJsDocBuilder;
    }

    void setFileOverviewJSDocInfo(JSDocInfo jSDocInfo) {
        this.fileOverviewJSDocInfo = jSDocInfo;
    }

    JsDocInfoParser(JsDocTokenStream jsDocTokenStream, Comment comment, String string, Config config, ErrorReporter errorReporter) {
        this.stream = jsDocTokenStream;
        this.sourceName = string;
        this.jsdocBuilder = new JSDocInfoBuilder(config.parseJsDocDocumentation);
        if (comment != null) {
            this.jsdocBuilder.recordOriginalCommentString(comment.getValue());
        }
        this.annotationNames = config.annotationNames;
        this.suppressionNames = config.suppressionNames;
        this.errorReporter = errorReporter;
        this.templateNode = this.createTemplateNode();
    }

    public static Node parseTypeString(String string) {
        Config config = new Config(Sets.newHashSet(), Sets.newHashSet(), false, Config.LanguageMode.ECMASCRIPT3, false);
        JsDocInfoParser jsDocInfoParser = new JsDocInfoParser(new JsDocTokenStream(string), null, "typeparsing", config, NullErrorReporter.forNewRhino());
        return jsDocInfoParser.parseTopLevelTypeExpression(jsDocInfoParser.next());
    }

    boolean parse() {
        Object object;
        this.state = State.SEARCHING_ANNOTATION;
        this.skipEOLs();
        JsDocToken jsDocToken = this.next();
        if (this.jsdocBuilder.shouldParseDocumentation()) {
            object = this.extractBlockComment(jsDocToken);
            jsDocToken = ((ExtractionInfo)object).token;
            if (!((ExtractionInfo)object).string.isEmpty()) {
                this.jsdocBuilder.recordBlockDescription(((ExtractionInfo)object).string);
            }
        } else if (jsDocToken != JsDocToken.ANNOTATION && jsDocToken != JsDocToken.EOC) {
            this.jsdocBuilder.recordBlockDescription("");
        }
        block51: while (true) {
            switch (jsDocToken) {
                case ANNOTATION: {
                    if (this.state != State.SEARCHING_ANNOTATION) break;
                    this.state = State.SEARCHING_NEWLINE;
                    int n = this.stream.getLineno();
                    int n2 = this.stream.getCharno();
                    object = this.stream.getString();
                    Annotation annotation = this.annotationNames.get(object);
                    if (annotation == null) {
                        this.parser.addParserWarning("msg.bad.jsdoc.tag", (String)object, this.stream.getLineno(), this.stream.getCharno());
                        break;
                    }
                    this.jsdocBuilder.markAnnotation((String)object, n, n2);
                    switch (annotation) {
                        case AUTHOR: {
                            String string;
                            ExtractionInfo extractionInfo;
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                extractionInfo = this.extractSingleLineBlock();
                                string = extractionInfo.string;
                                if (string.length() == 0) {
                                    this.parser.addParserWarning("msg.jsdoc.authormissing", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.jsdocBuilder.addAuthor(string);
                                }
                                jsDocToken = extractionInfo.token;
                                continue block51;
                            }
                            jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            continue block51;
                        }
                        case CONSTANT: {
                            if (!this.jsdocBuilder.recordConstancy()) {
                                this.parser.addParserWarning("msg.jsdoc.const", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case CONSTRUCTOR: {
                            if (!this.jsdocBuilder.recordConstructor()) {
                                if (this.jsdocBuilder.isInterfaceRecorded()) {
                                    this.parser.addTypeWarning("msg.jsdoc.interface.constructor", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                                }
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case DEPRECATED: {
                            String string;
                            ExtractionInfo extractionInfo;
                            if (!this.jsdocBuilder.recordDeprecated()) {
                                this.parser.addParserWarning("msg.jsdoc.deprecated", this.stream.getLineno(), this.stream.getCharno());
                            }
                            if ((string = (extractionInfo = this.extractMultilineTextualBlock(jsDocToken)).string).length() > 0) {
                                this.jsdocBuilder.recordDeprecationReason(string);
                            }
                            jsDocToken = extractionInfo.token;
                            continue block51;
                        }
                        case INTERFACE: {
                            if (!this.jsdocBuilder.recordInterface()) {
                                if (this.jsdocBuilder.isConstructorRecorded()) {
                                    this.parser.addTypeWarning("msg.jsdoc.interface.constructor", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", this.stream.getLineno(), this.stream.getCharno());
                                }
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case DESC: {
                            if (this.jsdocBuilder.isDescriptionRecorded()) {
                                this.parser.addParserWarning("msg.jsdoc.desc.extra", this.stream.getLineno(), this.stream.getCharno());
                                jsDocToken = this.eatTokensUntilEOL();
                                continue block51;
                            }
                            Object object2 = this.extractMultilineTextualBlock(jsDocToken);
                            Object object3 = ((ExtractionInfo)object2).string;
                            this.jsdocBuilder.recordDescription((String)object3);
                            jsDocToken = ((ExtractionInfo)object2).token;
                            continue block51;
                        }
                        case FILE_OVERVIEW: {
                            Object object3;
                            Object object2 = "";
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                object3 = this.extractMultilineTextualBlock(jsDocToken, WhitespaceOption.TRIM);
                                object2 = ((ExtractionInfo)object3).string;
                                jsDocToken = ((ExtractionInfo)object3).token;
                            } else {
                                jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            }
                            if (this.jsdocBuilder.recordFileOverview((String)object2) && this.fileOverviewJSDocInfo == null) continue block51;
                            this.parser.addParserWarning("msg.jsdoc.fileoverview.extra", this.stream.getLineno(), this.stream.getCharno());
                            continue block51;
                        }
                        case LICENSE: 
                        case PRESERVE: {
                            Object object3 = this.extractMultilineTextualBlock(jsDocToken, WhitespaceOption.PRESERVE);
                            String string = ((ExtractionInfo)object3).string;
                            if (string.length() > 0 && this.fileLevelJsDocBuilder != null) {
                                this.fileLevelJsDocBuilder.append(string);
                            }
                            jsDocToken = ((ExtractionInfo)object3).token;
                            continue block51;
                        }
                        case ENUM: {
                            jsDocToken = this.next();
                            n = this.stream.getLineno();
                            n2 = this.stream.getCharno();
                            JSTypeExpression jSTypeExpression = null;
                            if (jsDocToken != JsDocToken.EOL && jsDocToken != JsDocToken.EOC) {
                                jSTypeExpression = this.createJSTypeExpression(this.parseAndRecordTypeNode(jsDocToken));
                            }
                            if (jSTypeExpression == null) {
                                jSTypeExpression = this.createJSTypeExpression(this.newStringNode("number"));
                            }
                            if (!this.jsdocBuilder.recordEnumParameterType(jSTypeExpression)) {
                                this.parser.addTypeWarning("msg.jsdoc.incompat.type", n, n2);
                            }
                            jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            continue block51;
                        }
                        case EXPORT: {
                            if (!this.jsdocBuilder.recordExport()) {
                                this.parser.addParserWarning("msg.jsdoc.export", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case EXTERNS: {
                            if (!this.jsdocBuilder.recordExterns()) {
                                this.parser.addParserWarning("msg.jsdoc.externs", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case JAVA_DISPATCH: {
                            if (!this.jsdocBuilder.recordJavaDispatch()) {
                                this.parser.addParserWarning("msg.jsdoc.javadispatch", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case EXTENDS: 
                        case IMPLEMENTS: {
                            Object object4;
                            JSTypeExpression jSTypeExpression;
                            this.skipEOLs();
                            jsDocToken = this.next();
                            n = this.stream.getLineno();
                            n2 = this.stream.getCharno();
                            boolean bl = false;
                            if (jsDocToken == JsDocToken.LC) {
                                jsDocToken = this.next();
                                bl = true;
                            }
                            if (jsDocToken == JsDocToken.STRING) {
                                object4 = this.parseAndRecordTypeNameNode(jsDocToken, n, n2, bl);
                                n = this.stream.getLineno();
                                n2 = this.stream.getCharno();
                                if ((object4 = this.wrapNode(306, (Node)object4)) != null && !bl) {
                                    ((Node)object4).putBooleanProp(40, true);
                                }
                                jSTypeExpression = this.createJSTypeExpression((Node)object4);
                                if (annotation == Annotation.EXTENDS) {
                                    if (!this.jsdocBuilder.recordBaseType(jSTypeExpression)) {
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", n, n2);
                                    }
                                } else {
                                    Preconditions.checkState((annotation == Annotation.IMPLEMENTS ? 1 : 0) != 0);
                                    if (!this.jsdocBuilder.recordImplementedInterface(jSTypeExpression)) {
                                        this.parser.addTypeWarning("msg.jsdoc.implements.duplicate", n, n2);
                                    }
                                }
                                jsDocToken = this.next();
                                if (bl) {
                                    if (jsDocToken != JsDocToken.RC) {
                                        this.parser.addTypeWarning("msg.jsdoc.missing.rc", this.stream.getLineno(), this.stream.getCharno());
                                    }
                                } else if (jsDocToken != JsDocToken.EOL && jsDocToken != JsDocToken.EOF && jsDocToken != JsDocToken.EOC) {
                                    this.parser.addTypeWarning("msg.end.annotation.expected", this.stream.getLineno(), this.stream.getCharno());
                                }
                            } else {
                                this.parser.addTypeWarning("msg.no.type.name", n, n2);
                            }
                            jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            continue block51;
                        }
                        case HIDDEN: {
                            if (!this.jsdocBuilder.recordHiddenness()) {
                                this.parser.addParserWarning("msg.jsdoc.hidden", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case LENDS: {
                            this.skipEOLs();
                            boolean bl = false;
                            if (this.match(JsDocToken.LC)) {
                                jsDocToken = this.next();
                                bl = true;
                            }
                            if (this.match(JsDocToken.STRING)) {
                                jsDocToken = this.next();
                                if (!this.jsdocBuilder.recordLends(this.stream.getString())) {
                                    this.parser.addTypeWarning("msg.jsdoc.lends.incompatible", this.stream.getLineno(), this.stream.getCharno());
                                }
                            } else {
                                this.parser.addTypeWarning("msg.jsdoc.lends.missing", this.stream.getLineno(), this.stream.getCharno());
                            }
                            if (bl && !this.match(JsDocToken.RC)) {
                                this.parser.addTypeWarning("msg.jsdoc.missing.rc", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case MEANING: {
                            Object object4 = this.extractMultilineTextualBlock(jsDocToken);
                            String string = ((ExtractionInfo)object4).string;
                            jsDocToken = ((ExtractionInfo)object4).token;
                            if (this.jsdocBuilder.recordMeaning(string)) continue block51;
                            this.parser.addParserWarning("msg.jsdoc.meaning.extra", this.stream.getLineno(), this.stream.getCharno());
                            continue block51;
                        }
                        case NO_ALIAS: {
                            if (!this.jsdocBuilder.recordNoAlias()) {
                                this.parser.addParserWarning("msg.jsdoc.noalias", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case NO_COMPILE: {
                            if (!this.jsdocBuilder.recordNoCompile()) {
                                this.parser.addParserWarning("msg.jsdoc.nocompile", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case NO_TYPE_CHECK: {
                            if (!this.jsdocBuilder.recordNoTypeCheck()) {
                                this.parser.addParserWarning("msg.jsdoc.nocheck", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case NOT_IMPLEMENTED: {
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case INHERIT_DOC: 
                        case OVERRIDE: {
                            if (!this.jsdocBuilder.recordOverride()) {
                                this.parser.addTypeWarning("msg.jsdoc.override", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case THROWS: {
                            Object object5;
                            this.skipEOLs();
                            jsDocToken = this.next();
                            n = this.stream.getLineno();
                            n2 = this.stream.getCharno();
                            JSTypeExpression jSTypeExpression = null;
                            if (jsDocToken == JsDocToken.LC && (jSTypeExpression = this.createJSTypeExpression(this.parseAndRecordTypeNode(jsDocToken))) == null) {
                                jsDocToken = this.eatTokensUntilEOL();
                                continue block51;
                            }
                            jsDocToken = this.current();
                            this.jsdocBuilder.recordThrowType(jSTypeExpression);
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                object5 = this.extractMultilineTextualBlock(jsDocToken);
                                String string = ((ExtractionInfo)object5).string;
                                if (string.length() > 0) {
                                    this.jsdocBuilder.recordThrowDescription(jSTypeExpression, string);
                                }
                                jsDocToken = ((ExtractionInfo)object5).token;
                                continue block51;
                            }
                            jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            continue block51;
                        }
                        case PARAM: {
                            String string;
                            ExtractionInfo extractionInfo;
                            boolean bl;
                            this.skipEOLs();
                            jsDocToken = this.next();
                            n = this.stream.getLineno();
                            n2 = this.stream.getCharno();
                            JSTypeExpression jSTypeExpression = null;
                            if (jsDocToken == JsDocToken.LC) {
                                jSTypeExpression = this.createJSTypeExpression(this.parseAndRecordParamTypeNode(jsDocToken));
                                if (jSTypeExpression == null) {
                                    jsDocToken = this.eatTokensUntilEOL();
                                    continue block51;
                                }
                                this.skipEOLs();
                                jsDocToken = this.next();
                                n = this.stream.getLineno();
                                n2 = this.stream.getCharno();
                            }
                            Object object5 = null;
                            boolean bl2 = bl = JsDocToken.LB == jsDocToken;
                            if (bl) {
                                jsDocToken = this.next();
                            }
                            if (JsDocToken.STRING != jsDocToken) {
                                this.parser.addTypeWarning("msg.missing.variable.name", n, n2);
                            } else {
                                object5 = this.stream.getString();
                                if (bl) {
                                    jsDocToken = this.next();
                                    if (JsDocToken.EQUALS == jsDocToken && JsDocToken.STRING == (jsDocToken = this.next())) {
                                        jsDocToken = this.next();
                                    }
                                    if (JsDocToken.RB != jsDocToken) {
                                        this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
                                    } else if (jSTypeExpression != null) {
                                        jSTypeExpression = JSTypeExpression.makeOptionalArg(jSTypeExpression);
                                    }
                                }
                                if (((String)object5).indexOf(46) > -1) {
                                    object5 = null;
                                } else if (!this.jsdocBuilder.recordParameter((String)object5, jSTypeExpression)) {
                                    if (this.jsdocBuilder.hasParameter((String)object5)) {
                                        this.parser.addTypeWarning("msg.dup.variable.name", (String)object5, n, n2);
                                    } else {
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", (String)object5, n, n2);
                                    }
                                }
                            }
                            if (object5 == null) {
                                jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                                continue block51;
                            }
                            this.jsdocBuilder.markName((String)object5, n, n2);
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                extractionInfo = this.extractMultilineTextualBlock(jsDocToken);
                                string = extractionInfo.string;
                                if (string.length() > 0) {
                                    this.jsdocBuilder.recordParameterDescription((String)object5, string);
                                }
                                jsDocToken = extractionInfo.token;
                                continue block51;
                            }
                            jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            continue block51;
                        }
                        case PRESERVE_TRY: {
                            if (!this.jsdocBuilder.recordPreserveTry()) {
                                this.parser.addParserWarning("msg.jsdoc.preservertry", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case PRIVATE: {
                            if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PRIVATE)) {
                                this.parser.addParserWarning("msg.jsdoc.visibility.private", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case PROTECTED: {
                            if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PROTECTED)) {
                                this.parser.addParserWarning("msg.jsdoc.visibility.protected", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case PUBLIC: {
                            if (!this.jsdocBuilder.recordVisibility(JSDocInfo.Visibility.PUBLIC)) {
                                this.parser.addParserWarning("msg.jsdoc.visibility.public", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case NO_SHADOW: {
                            if (!this.jsdocBuilder.recordNoShadow()) {
                                this.parser.addParserWarning("msg.jsdoc.noshadow", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case NO_SIDE_EFFECTS: {
                            if (!this.jsdocBuilder.recordNoSideEffects()) {
                                this.parser.addParserWarning("msg.jsdoc.nosideeffects", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case MODIFIES: {
                            jsDocToken = this.parseModifiesTag(this.next());
                            continue block51;
                        }
                        case IMPLICIT_CAST: {
                            if (!this.jsdocBuilder.recordImplicitCast()) {
                                this.parser.addTypeWarning("msg.jsdoc.implicitcast", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                        case SEE: {
                            String string;
                            ExtractionInfo extractionInfo;
                            if (this.jsdocBuilder.shouldParseDocumentation()) {
                                extractionInfo = this.extractSingleLineBlock();
                                string = extractionInfo.string;
                                if (string.length() == 0) {
                                    this.parser.addParserWarning("msg.jsdoc.seemissing", this.stream.getLineno(), this.stream.getCharno());
                                } else {
                                    this.jsdocBuilder.addReference(string);
                                }
                                jsDocToken = extractionInfo.token;
                                continue block51;
                            }
                            jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                            continue block51;
                        }
                        case SUPPRESS: {
                            jsDocToken = this.parseSuppressTag(this.next());
                            continue block51;
                        }
                        case TEMPLATE: {
                            ExtractionInfo extractionInfo = this.extractSingleLineBlock();
                            String string = extractionInfo.string;
                            if (string.length() == 0) {
                                this.parser.addTypeWarning("msg.jsdoc.templatemissing", this.stream.getLineno(), this.stream.getCharno());
                            } else if (!this.jsdocBuilder.recordTemplateTypeName(string)) {
                                this.parser.addTypeWarning("msg.jsdoc.template.at.most.once", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = extractionInfo.token;
                            continue block51;
                        }
                        case VERSION: {
                            ExtractionInfo extractionInfo = this.extractSingleLineBlock();
                            String string = extractionInfo.string;
                            if (string.length() == 0) {
                                this.parser.addParserWarning("msg.jsdoc.versionmissing", this.stream.getLineno(), this.stream.getCharno());
                            } else if (!this.jsdocBuilder.recordVersion(string)) {
                                this.parser.addParserWarning("msg.jsdoc.extraversion", this.stream.getLineno(), this.stream.getCharno());
                            }
                            jsDocToken = extractionInfo.token;
                            continue block51;
                        }
                        case DEFINE: 
                        case RETURN: 
                        case THIS: 
                        case TYPE: 
                        case TYPEDEF: {
                            JSTypeExpression jSTypeExpression;
                            this.skipEOLs();
                            n = this.stream.getLineno();
                            n2 = this.stream.getCharno();
                            jsDocToken = this.next();
                            Node node = null;
                            node = annotation == Annotation.RETURN && jsDocToken != JsDocToken.LC ? this.newNode(304) : this.parseAndRecordTypeNode(jsDocToken, n, n2);
                            if (annotation == Annotation.THIS && (node = this.wrapNode(306, node)) != null && jsDocToken != JsDocToken.LC) {
                                node.putBooleanProp(40, true);
                            }
                            if ((jSTypeExpression = this.createJSTypeExpression(node)) == null) continue block51;
                            switch (annotation) {
                                case DEFINE: {
                                    if (this.jsdocBuilder.recordDefineType(jSTypeExpression)) break;
                                    this.parser.addParserWarning("msg.jsdoc.define", n, n2);
                                    break;
                                }
                                case RETURN: {
                                    if (!this.jsdocBuilder.recordReturnType(jSTypeExpression)) {
                                        this.parser.addTypeWarning("msg.jsdoc.incompat.type", n, n2);
                                        break;
                                    }
                                    jsDocToken = this.current();
                                    if (this.jsdocBuilder.shouldParseDocumentation()) {
                                        ExtractionInfo extractionInfo = this.extractMultilineTextualBlock(jsDocToken);
                                        String string = extractionInfo.string;
                                        if (string.length() > 0) {
                                            this.jsdocBuilder.recordReturnDescription(string);
                                        }
                                        jsDocToken = extractionInfo.token;
                                        continue block51;
                                    }
                                    jsDocToken = this.eatTokensUntilEOL(jsDocToken);
                                    continue block51;
                                }
                                case THIS: {
                                    if (this.jsdocBuilder.recordThisType(jSTypeExpression)) break;
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", n, n2);
                                    break;
                                }
                                case TYPE: {
                                    if (this.jsdocBuilder.recordType(jSTypeExpression)) break;
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", n, n2);
                                    break;
                                }
                                case TYPEDEF: {
                                    if (this.jsdocBuilder.recordTypedef(jSTypeExpression)) break;
                                    this.parser.addTypeWarning("msg.jsdoc.incompat.type", n, n2);
                                }
                            }
                            jsDocToken = this.eatTokensUntilEOL();
                            continue block51;
                        }
                    }
                    break;
                }
                case EOC: {
                    if (this.hasParsedFileOverviewDocInfo()) {
                        this.fileOverviewJSDocInfo = this.retrieveAndResetParsedJSDocInfo();
                    }
                    return true;
                }
                case EOF: {
                    this.jsdocBuilder.build(null);
                    this.parser.addParserWarning("msg.unexpected.eof", this.stream.getLineno(), this.stream.getCharno());
                    return false;
                }
                case EOL: {
                    if (this.state == State.SEARCHING_NEWLINE) {
                        this.state = State.SEARCHING_ANNOTATION;
                    }
                    jsDocToken = this.next();
                    continue block51;
                }
                default: {
                    if (jsDocToken == JsDocToken.STAR && this.state == State.SEARCHING_ANNOTATION) {
                        jsDocToken = this.next();
                        continue block51;
                    }
                    this.state = State.SEARCHING_NEWLINE;
                    jsDocToken = this.eatTokensUntilEOL();
                    continue block51;
                }
            }
            jsDocToken = this.next();
        }
    }

    private JsDocToken parseSuppressTag(JsDocToken jsDocToken) {
        if (jsDocToken == JsDocToken.LC) {
            HashSet<String> hashSet = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String string = this.stream.getString();
                    if (!this.suppressionNames.contains(string)) {
                        this.parser.addParserWarning("msg.jsdoc.suppress.unknown", string, this.stream.getLineno(), this.stream.getCharno());
                    }
                } else {
                    this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
                    return jsDocToken;
                }
                hashSet.add(this.stream.getString());
                jsDocToken = this.next();
                if (!this.match(JsDocToken.PIPE)) break;
                jsDocToken = this.next();
            }
            if (!this.match(JsDocToken.RC)) {
                this.parser.addParserWarning("msg.jsdoc.suppress", this.stream.getLineno(), this.stream.getCharno());
            } else {
                jsDocToken = this.next();
                if (!this.jsdocBuilder.recordSuppressions(hashSet)) {
                    this.parser.addParserWarning("msg.jsdoc.suppress.duplicate", this.stream.getLineno(), this.stream.getCharno());
                }
            }
        }
        return jsDocToken;
    }

    private JsDocToken parseModifiesTag(JsDocToken jsDocToken) {
        if (jsDocToken == JsDocToken.LC) {
            HashSet<String> hashSet = new HashSet<String>();
            while (true) {
                if (this.match(JsDocToken.STRING)) {
                    String string = this.stream.getString();
                    if (!modifiesAnnotationKeywords.contains(string) && !this.jsdocBuilder.hasParameter(string)) {
                        this.parser.addParserWarning("msg.jsdoc.modifies.unknown", string, this.stream.getLineno(), this.stream.getCharno());
                    }
                } else {
                    this.parser.addParserWarning("msg.jsdoc.modifies", this.stream.getLineno(), this.stream.getCharno());
                    return jsDocToken;
                }
                hashSet.add(this.stream.getString());
                jsDocToken = this.next();
                if (!this.match(JsDocToken.PIPE)) break;
                jsDocToken = this.next();
            }
            if (!this.match(JsDocToken.RC)) {
                this.parser.addParserWarning("msg.jsdoc.modifies", this.stream.getLineno(), this.stream.getCharno());
            } else {
                jsDocToken = this.next();
                if (!this.jsdocBuilder.recordModifies(hashSet)) {
                    this.parser.addParserWarning("msg.jsdoc.modifies.duplicate", this.stream.getLineno(), this.stream.getCharno());
                }
            }
        }
        return jsDocToken;
    }

    private Node parseAndRecordTypeNode(JsDocToken jsDocToken) {
        return this.parseAndRecordTypeNode(jsDocToken, jsDocToken == JsDocToken.LC);
    }

    private Node parseAndRecordTypeNode(JsDocToken jsDocToken, boolean bl) {
        return this.parseAndRecordTypeNode(jsDocToken, this.stream.getLineno(), this.stream.getCharno(), bl, false);
    }

    private Node parseAndRecordTypeNode(JsDocToken jsDocToken, int n, int n2) {
        return this.parseAndRecordTypeNode(jsDocToken, n, n2, jsDocToken == JsDocToken.LC, false);
    }

    private Node parseAndRecordTypeNameNode(JsDocToken jsDocToken, int n, int n2, boolean bl) {
        return this.parseAndRecordTypeNode(jsDocToken, n, n2, bl, true);
    }

    private Node parseAndRecordParamTypeNode(JsDocToken jsDocToken) {
        Preconditions.checkArgument((jsDocToken == JsDocToken.LC ? 1 : 0) != 0);
        int n = this.stream.getLineno();
        int n2 = this.stream.getCharno();
        Node node = this.parseParamTypeExpressionAnnotation(jsDocToken);
        int n3 = this.stream.getCharno();
        this.jsdocBuilder.markTypeNode(node, n, n2, n3, true);
        return node;
    }

    private Node parseAndRecordTypeNode(JsDocToken jsDocToken, int n, int n2, boolean bl, boolean bl2) {
        Node node = null;
        node = bl2 ? this.parseTypeNameAnnotation(jsDocToken) : this.parseTypeExpressionAnnotation(jsDocToken);
        if (node != null && !bl) {
            node.putBooleanProp(40, true);
        }
        int n3 = this.stream.getCharno();
        this.jsdocBuilder.markTypeNode(node, n, n2, n3, bl);
        return node;
    }

    private String toString(JsDocToken jsDocToken) {
        switch (jsDocToken) {
            case ANNOTATION: {
                return "@" + this.stream.getString();
            }
            case BANG: {
                return "!";
            }
            case COMMA: {
                return ",";
            }
            case COLON: {
                return ":";
            }
            case GT: {
                return ">";
            }
            case LB: {
                return "[";
            }
            case LC: {
                return "{";
            }
            case LP: {
                return "(";
            }
            case LT: {
                return ".<";
            }
            case QMARK: {
                return "?";
            }
            case PIPE: {
                return "|";
            }
            case RB: {
                return "]";
            }
            case RC: {
                return "}";
            }
            case RP: {
                return ")";
            }
            case STAR: {
                return "*";
            }
            case ELLIPSIS: {
                return "...";
            }
            case EQUALS: {
                return "=";
            }
            case STRING: {
                return this.stream.getString();
            }
        }
        throw new IllegalStateException(jsDocToken.toString());
    }

    private JSTypeExpression createJSTypeExpression(Node node) {
        return node == null ? null : new JSTypeExpression(node, this.sourceName);
    }

    private ExtractionInfo extractSingleLineBlock() {
        this.stream.update();
        int n = this.stream.getLineno();
        int n2 = this.stream.getCharno() + 1;
        String string = this.stream.getRemainingJSDocLine().trim();
        if (string.length() > 0) {
            this.jsdocBuilder.markText(string, n, n2, n, n2 + string.length());
        }
        return new ExtractionInfo(string, this.next());
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken jsDocToken) {
        return this.extractMultilineTextualBlock(jsDocToken, WhitespaceOption.SINGLE_LINE);
    }

    private ExtractionInfo extractMultilineTextualBlock(JsDocToken jsDocToken, WhitespaceOption whitespaceOption) {
        if (jsDocToken == JsDocToken.EOC || jsDocToken == JsDocToken.EOL || jsDocToken == JsDocToken.EOF) {
            return new ExtractionInfo("", jsDocToken);
        }
        this.stream.update();
        int n = this.stream.getLineno();
        int n2 = this.stream.getCharno() + 1;
        String string = this.stream.getRemainingJSDocLine();
        if (whitespaceOption != WhitespaceOption.PRESERVE) {
            string = string.trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        this.state = State.SEARCHING_ANNOTATION;
        jsDocToken = this.next();
        boolean bl = false;
        block5: while (true) {
            switch (jsDocToken) {
                case STAR: {
                    if (!bl) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append('*');
                    }
                    jsDocToken = this.next();
                    continue block5;
                }
                case EOL: {
                    if (whitespaceOption != WhitespaceOption.SINGLE_LINE) {
                        stringBuilder.append("\n");
                    }
                    bl = true;
                    jsDocToken = this.next();
                    continue block5;
                }
                case ANNOTATION: 
                case EOC: 
                case EOF: {
                    if (whitespaceOption == WhitespaceOption.PRESERVE && jsDocToken == JsDocToken.ANNOTATION) break;
                    String string2 = stringBuilder.toString();
                    if (whitespaceOption != WhitespaceOption.PRESERVE) {
                        string2 = string2.trim();
                    }
                    int n3 = this.stream.getLineno();
                    int n4 = this.stream.getCharno();
                    if (string2.length() > 0) {
                        this.jsdocBuilder.markText(string2, n, n2, n3, n4);
                    }
                    return new ExtractionInfo(string2, jsDocToken);
                }
            }
            bl = false;
            this.state = State.SEARCHING_ANNOTATION;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.toString(jsDocToken));
            string = this.stream.getRemainingJSDocLine();
            if (whitespaceOption != WhitespaceOption.PRESERVE) {
                string = JsDocInfoParser.trimEnd(string);
            }
            stringBuilder.append(string);
            jsDocToken = this.next();
        }
    }

    private ExtractionInfo extractBlockComment(JsDocToken jsDocToken) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        block5: while (true) {
            switch (jsDocToken) {
                case ANNOTATION: 
                case EOC: 
                case EOF: {
                    return new ExtractionInfo(stringBuilder.toString().trim(), jsDocToken);
                }
                case STAR: {
                    if (!bl) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append('*');
                    }
                    jsDocToken = this.next();
                    continue block5;
                }
                case EOL: {
                    bl = true;
                    stringBuilder.append('\n');
                    jsDocToken = this.next();
                    continue block5;
                }
            }
            if (!bl && stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            bl = false;
            stringBuilder.append(this.toString(jsDocToken));
            String string = this.stream.getRemainingJSDocLine();
            string = JsDocInfoParser.trimEnd(string);
            stringBuilder.append(string);
            jsDocToken = this.next();
        }
    }

    private static String trimEnd(String string) {
        char c;
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(c = string.charAt(string.length() - n - 1)); ++n) {
        }
        if (n == 0) {
            return string;
        }
        return string.substring(0, string.length() - n);
    }

    private Node parseTypeExpressionAnnotation(JsDocToken jsDocToken) {
        if (jsDocToken == JsDocToken.LC) {
            this.skipEOLs();
            Node node = this.parseTopLevelTypeExpression(this.next());
            if (node != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RC)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return node;
        }
        return this.parseTypeExpression(jsDocToken);
    }

    private Node parseParamTypeExpressionAnnotation(JsDocToken jsDocToken) {
        Node node;
        Preconditions.checkArgument((jsDocToken == JsDocToken.LC ? 1 : 0) != 0);
        this.skipEOLs();
        boolean bl = false;
        jsDocToken = this.next();
        if (jsDocToken == JsDocToken.ELLIPSIS) {
            jsDocToken = this.next();
            if (jsDocToken == JsDocToken.RC) {
                return this.wrapNode(305, new Node(124));
            }
            bl = true;
        }
        if ((node = this.parseTopLevelTypeExpression(jsDocToken)) != null) {
            this.skipEOLs();
            if (bl) {
                node = this.wrapNode(305, node);
            } else if (this.match(JsDocToken.EQUALS)) {
                this.next();
                this.skipEOLs();
                node = this.wrapNode(307, node);
            }
            if (!this.match(JsDocToken.RC)) {
                this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
            } else {
                this.next();
            }
        }
        return node;
    }

    private Node parseTypeNameAnnotation(JsDocToken jsDocToken) {
        if (jsDocToken == JsDocToken.LC) {
            this.skipEOLs();
            Node node = this.parseTypeName(this.next());
            if (node != null) {
                this.skipEOLs();
                if (!this.match(JsDocToken.RC)) {
                    this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
                } else {
                    this.next();
                }
            }
            return node;
        }
        return this.parseTypeName(jsDocToken);
    }

    private Node parseTopLevelTypeExpression(JsDocToken jsDocToken) {
        Node node = this.parseTypeExpression(jsDocToken);
        if (node != null && this.match(JsDocToken.PIPE)) {
            this.next();
            if (this.match(JsDocToken.PIPE)) {
                this.next();
            }
            this.skipEOLs();
            jsDocToken = this.next();
            return this.parseUnionTypeWithAlternate(jsDocToken, node);
        }
        return node;
    }

    private Node parseTypeExpressionList(JsDocToken jsDocToken) {
        Node node = this.parseTopLevelTypeExpression(jsDocToken);
        if (node == null) {
            return null;
        }
        Node node2 = new Node(125);
        node2.addChildToBack(node);
        while (this.match(JsDocToken.COMMA)) {
            this.next();
            this.skipEOLs();
            node = this.parseTopLevelTypeExpression(this.next());
            if (node == null) {
                return null;
            }
            node2.addChildToBack(node);
        }
        return node2;
    }

    private Node parseTypeExpression(JsDocToken jsDocToken) {
        if (jsDocToken == JsDocToken.QMARK) {
            jsDocToken = this.next();
            if (jsDocToken == JsDocToken.COMMA || jsDocToken == JsDocToken.EQUALS || jsDocToken == JsDocToken.RC || jsDocToken == JsDocToken.RP || jsDocToken == JsDocToken.PIPE) {
                this.restoreLookAhead(jsDocToken);
                return this.newNode(304);
            }
            return this.wrapNode(304, this.parseBasicTypeExpression(jsDocToken));
        }
        if (jsDocToken == JsDocToken.BANG) {
            return this.wrapNode(306, this.parseBasicTypeExpression(this.next()));
        }
        Node node = this.parseBasicTypeExpression(jsDocToken);
        if (node != null) {
            if (this.match(JsDocToken.QMARK)) {
                this.next();
                return this.wrapNode(304, node);
            }
            if (this.match(JsDocToken.BANG)) {
                this.next();
                return this.wrapNode(306, node);
            }
        }
        return node;
    }

    private Node parseBasicTypeExpression(JsDocToken jsDocToken) {
        if (jsDocToken == JsDocToken.STAR) {
            return this.newNode(302);
        }
        if (jsDocToken == JsDocToken.LB) {
            this.skipEOLs();
            return this.parseArrayType(this.next());
        }
        if (jsDocToken == JsDocToken.LC) {
            this.skipEOLs();
            return this.parseRecordType(this.next());
        }
        if (jsDocToken == JsDocToken.LP) {
            this.skipEOLs();
            return this.parseUnionType(this.next());
        }
        if (jsDocToken == JsDocToken.STRING) {
            String string = this.stream.getString();
            if ("function".equals(string)) {
                this.skipEOLs();
                return this.parseFunctionType(this.next());
            }
            if ("null".equals(string) || "undefined".equals(string)) {
                return this.newStringNode(string);
            }
            return this.parseTypeName(jsDocToken);
        }
        return this.reportGenericTypeSyntaxWarning();
    }

    private Node parseTypeName(JsDocToken jsDocToken) {
        if (jsDocToken != JsDocToken.STRING) {
            return this.reportGenericTypeSyntaxWarning();
        }
        String string = this.stream.getString();
        while (this.match(JsDocToken.EOL) && string.charAt(string.length() - 1) == '.') {
            this.skipEOLs();
            if (!this.match(JsDocToken.STRING)) continue;
            this.next();
            string = string + this.stream.getString();
        }
        Node node = this.newStringNode(string);
        if (this.match(JsDocToken.LT)) {
            this.next();
            this.skipEOLs();
            Node node2 = this.parseTypeExpressionList(this.next());
            if (node2 != null) {
                node.addChildToFront(node2);
                this.skipEOLs();
                if (!this.match(JsDocToken.GT)) {
                    return this.reportTypeSyntaxWarning("msg.jsdoc.missing.gt");
                }
                this.next();
            }
        }
        return node;
    }

    private Node parseFunctionType(JsDocToken jsDocToken) {
        if (jsDocToken != JsDocToken.LP) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.lp");
        }
        Node node = this.newNode(105);
        Node node2 = null;
        this.skipEOLs();
        if (!this.match(JsDocToken.RP)) {
            jsDocToken = this.next();
            boolean bl = true;
            if (jsDocToken == JsDocToken.STRING) {
                String string = this.stream.getString();
                boolean bl2 = "this".equals(string);
                boolean bl3 = "new".equals(string);
                if (bl2 || bl3) {
                    Node node3;
                    if (this.match(JsDocToken.COLON)) {
                        this.next();
                        this.skipEOLs();
                        node3 = this.wrapNode(bl2 ? 42 : 30, this.parseTypeName(this.next()));
                        if (node3 == null) {
                            return null;
                        }
                    } else {
                        return this.reportTypeSyntaxWarning("msg.jsdoc.missing.colon");
                    }
                    node.addChildToFront(node3);
                    if (this.match(JsDocToken.COMMA)) {
                        this.next();
                        this.skipEOLs();
                        jsDocToken = this.next();
                    } else {
                        bl = false;
                    }
                }
            }
            if (bl && (node2 = this.parseParametersType(jsDocToken)) == null) {
                return null;
            }
        }
        if (node2 != null) {
            node.addChildToBack(node2);
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RP)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
        }
        this.skipEOLs();
        Node node4 = this.parseResultType(this.next());
        if (node4 == null) {
            return null;
        }
        node.addChildToBack(node4);
        return node;
    }

    private Node parseParametersType(JsDocToken jsDocToken) {
        Node node = this.newNode(83);
        boolean bl = false;
        Node node2 = null;
        if (jsDocToken != JsDocToken.RP) {
            do {
                if (node2 != null) {
                    this.next();
                    this.skipEOLs();
                    jsDocToken = this.next();
                }
                if (jsDocToken == JsDocToken.ELLIPSIS) {
                    this.skipEOLs();
                    if (this.match(JsDocToken.RP)) {
                        node2 = this.newNode(305);
                    } else {
                        this.skipEOLs();
                        if (!this.match(JsDocToken.LB)) {
                            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.lb");
                        }
                        this.next();
                        this.skipEOLs();
                        node2 = this.wrapNode(305, this.parseTypeExpression(this.next()));
                        this.skipEOLs();
                        if (!this.match(JsDocToken.RB)) {
                            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
                        }
                        this.skipEOLs();
                        this.next();
                    }
                    bl = true;
                } else {
                    node2 = this.parseTypeExpression(jsDocToken);
                    if (this.match(JsDocToken.EQUALS)) {
                        this.skipEOLs();
                        this.next();
                        node2 = this.wrapNode(307, node2);
                    }
                }
                if (node2 == null) {
                    return null;
                }
                node.addChildToBack(node2);
            } while (!bl && this.match(JsDocToken.COMMA));
        }
        if (bl && this.match(JsDocToken.COMMA)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.function.varargs");
        }
        return node;
    }

    private Node parseResultType(JsDocToken jsDocToken) {
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return this.newNode(124);
        }
        jsDocToken = this.next();
        this.skipEOLs();
        if (this.match(JsDocToken.STRING) && "void".equals(this.stream.getString())) {
            this.next();
            return this.newNode(122);
        }
        return this.parseTypeExpression(this.next());
    }

    private Node parseUnionType(JsDocToken jsDocToken) {
        return this.parseUnionTypeWithAlternate(jsDocToken, null);
    }

    private Node parseUnionTypeWithAlternate(JsDocToken jsDocToken, Node node) {
        Node node2 = this.newNode(301);
        if (node != null) {
            node2.addChildToBack(node);
        }
        Node node3 = null;
        do {
            if (node3 != null) {
                boolean bl;
                this.skipEOLs();
                jsDocToken = this.next();
                Preconditions.checkState((jsDocToken == JsDocToken.PIPE || jsDocToken == JsDocToken.COMMA ? 1 : 0) != 0);
                boolean bl2 = bl = jsDocToken == JsDocToken.PIPE;
                if (bl && this.match(JsDocToken.PIPE)) {
                    this.next();
                }
                this.skipEOLs();
                jsDocToken = this.next();
            }
            if ((node3 = this.parseTypeExpression(jsDocToken)) == null) {
                return null;
            }
            node2.addChildToBack(node3);
        } while (this.match(JsDocToken.PIPE, JsDocToken.COMMA));
        if (node == null) {
            this.skipEOLs();
            if (!this.match(JsDocToken.RP)) {
                return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rp");
            }
            this.next();
        }
        return node2;
    }

    private Node parseArrayType(JsDocToken jsDocToken) {
        Node node = this.newNode(79);
        Node node2 = null;
        boolean bl = false;
        do {
            if (node2 != null) {
                this.next();
                this.skipEOLs();
                jsDocToken = this.next();
            }
            if (jsDocToken == JsDocToken.ELLIPSIS) {
                node2 = this.wrapNode(305, this.parseTypeExpression(this.next()));
                bl = true;
            } else {
                node2 = this.parseTypeExpression(jsDocToken);
            }
            if (node2 == null) {
                return null;
            }
            node.addChildToBack(node2);
            if (bl) break;
            this.skipEOLs();
        } while (this.match(JsDocToken.COMMA));
        if (!this.match(JsDocToken.RB)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rb");
        }
        this.next();
        return node;
    }

    private Node parseRecordType(JsDocToken jsDocToken) {
        Node node = this.newNode(81);
        Node node2 = this.parseFieldTypeList(jsDocToken);
        if (node2 == null) {
            return this.reportGenericTypeSyntaxWarning();
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.RC)) {
            return this.reportTypeSyntaxWarning("msg.jsdoc.missing.rc");
        }
        this.next();
        node.addChildToBack(node2);
        return node;
    }

    private Node parseFieldTypeList(JsDocToken jsDocToken) {
        Node node = this.newNode(79);
        while (true) {
            Node node2;
            if ((node2 = this.parseFieldType(jsDocToken)) == null) {
                return null;
            }
            node.addChildToBack(node2);
            this.skipEOLs();
            if (!this.match(JsDocToken.COMMA)) break;
            this.next();
            this.skipEOLs();
            jsDocToken = this.next();
        }
        return node;
    }

    private Node parseFieldType(JsDocToken jsDocToken) {
        Node node = this.parseFieldName(jsDocToken);
        if (node == null) {
            return null;
        }
        this.skipEOLs();
        if (!this.match(JsDocToken.COLON)) {
            return node;
        }
        this.next();
        this.skipEOLs();
        Node node2 = this.parseTypeExpression(this.next());
        if (node2 == null) {
            return null;
        }
        Node node3 = this.newNode(99);
        node3.addChildToBack(node);
        node3.addChildToBack(node2);
        return node3;
    }

    private Node parseFieldName(JsDocToken jsDocToken) {
        switch (jsDocToken) {
            case STRING: {
                String string = this.stream.getString();
                return this.newStringNode(string);
            }
        }
        return null;
    }

    private Node wrapNode(int n, Node node) {
        return node == null ? null : new Node(n, node, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newNode(int n) {
        return new Node(n, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node newStringNode(String string) {
        return Node.newString(string, this.stream.getLineno(), this.stream.getCharno()).clonePropsFrom(this.templateNode);
    }

    private Node createTemplateNode() {
        Node node = new Node(132);
        node.putProp(16, this.sourceName);
        return node;
    }

    private Node reportTypeSyntaxWarning(String string) {
        this.parser.addTypeWarning(string, this.stream.getLineno(), this.stream.getCharno());
        return null;
    }

    private Node reportGenericTypeSyntaxWarning() {
        return this.reportTypeSyntaxWarning("msg.jsdoc.type.syntax");
    }

    private JsDocToken eatTokensUntilEOL() {
        return this.eatTokensUntilEOL(this.next());
    }

    private JsDocToken eatTokensUntilEOL(JsDocToken jsDocToken) {
        while (true) {
            if (jsDocToken == JsDocToken.EOL || jsDocToken == JsDocToken.EOC || jsDocToken == JsDocToken.EOF) {
                this.state = State.SEARCHING_ANNOTATION;
                return jsDocToken;
            }
            jsDocToken = this.next();
        }
    }

    private void restoreLookAhead(JsDocToken jsDocToken) {
        this.unreadToken = jsDocToken;
    }

    private boolean match(JsDocToken jsDocToken) {
        this.unreadToken = this.next();
        return this.unreadToken == jsDocToken;
    }

    private boolean match(JsDocToken jsDocToken, JsDocToken jsDocToken2) {
        this.unreadToken = this.next();
        return this.unreadToken == jsDocToken || this.unreadToken == jsDocToken2;
    }

    private JsDocToken next() {
        if (this.unreadToken == NO_UNREAD_TOKEN) {
            return this.stream.getJsDocToken();
        }
        return this.current();
    }

    private JsDocToken current() {
        JsDocToken jsDocToken = this.unreadToken;
        this.unreadToken = NO_UNREAD_TOKEN;
        return jsDocToken;
    }

    private void skipEOLs() {
        while (this.match(JsDocToken.EOL)) {
            this.next();
            if (!this.match(JsDocToken.STAR)) continue;
            this.next();
        }
    }

    private boolean hasParsedFileOverviewDocInfo() {
        return this.jsdocBuilder.isPopulatedWithFileOverview();
    }

    boolean hasParsedJSDocInfo() {
        return this.jsdocBuilder.isPopulated();
    }

    JSDocInfo retrieveAndResetParsedJSDocInfo() {
        return this.jsdocBuilder.build(this.sourceName);
    }

    JSDocInfo getFileOverviewJSDocInfo() {
        return this.fileOverviewJSDocInfo;
    }

    private static enum WhitespaceOption {
        PRESERVE,
        TRIM,
        SINGLE_LINE;

    }

    private static class ExtractionInfo {
        private final String string;
        private final JsDocToken token;

        public ExtractionInfo(String string, JsDocToken jsDocToken) {
            this.string = string;
            this.token = jsDocToken;
        }
    }

    private static enum State {
        SEARCHING_ANNOTATION,
        SEARCHING_NEWLINE,
        NEXT_IS_ANNOTATION;

    }

    private class ErrorReporterParser {
        private ErrorReporterParser() {
        }

        void addParserWarning(String string, String string2, int n, int n2) {
            JsDocInfoParser.this.errorReporter.warning(ScriptRuntime.getMessage1(string, string2), JsDocInfoParser.this.sourceName, n, null, n2);
        }

        void addParserWarning(String string, int n, int n2) {
            JsDocInfoParser.this.errorReporter.warning(ScriptRuntime.getMessage0(string), JsDocInfoParser.this.sourceName, n, null, n2);
        }

        void addTypeWarning(String string, String string2, int n, int n2) {
            JsDocInfoParser.this.errorReporter.warning("Bad type annotation. " + ScriptRuntime.getMessage1(string, string2), JsDocInfoParser.this.sourceName, n, null, n2);
        }

        void addTypeWarning(String string, int n, int n2) {
            JsDocInfoParser.this.errorReporter.warning("Bad type annotation. " + ScriptRuntime.getMessage0(string), JsDocInfoParser.this.sourceName, n, null, n2);
        }
    }
}

