/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Predicate;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.TernaryValue;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.UnionTypeBuilder;
import com.google.javascript.rhino.jstype.Visitor;
import java.io.Serializable;
import java.util.Comparator;

public abstract class JSType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean resolved = false;
    private JSType resolveResult = null;
    public static final String UNKNOWN_NAME = "Unknown class name";
    public static final String NOT_A_CLASS = "Not declared as a constructor";
    public static final String NOT_A_TYPE = "Not declared as a type name";
    public static final String EMPTY_TYPE_COMPONENT = "Named type with empty name component";
    static final Comparator<JSType> ALPHA = new Comparator<JSType>(){

        @Override
        public int compare(JSType jSType, JSType jSType2) {
            return jSType.toString().compareTo(jSType2.toString());
        }
    };
    public static final int ENUMDECL = 1;
    public static final int NOT_ENUMDECL = 0;
    final JSTypeRegistry registry;

    JSType(JSTypeRegistry jSTypeRegistry) {
        this.registry = jSTypeRegistry;
    }

    JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.registry.getNativeType(jSTypeNative);
    }

    public JSDocInfo getJSDocInfo() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public boolean hasDisplayName() {
        String string = this.getDisplayName();
        return string != null && !string.isEmpty();
    }

    public boolean isNoType() {
        return false;
    }

    public boolean isNoResolvedType() {
        return false;
    }

    public boolean isNoObjectType() {
        return false;
    }

    public final boolean isEmptyType() {
        return this.isNoType() || this.isNoObjectType() || this.isNoResolvedType() || this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE) == this;
    }

    public boolean isNumberObjectType() {
        return false;
    }

    public boolean isNumberValueType() {
        return false;
    }

    public boolean isFunctionPrototypeType() {
        return false;
    }

    public boolean isStringObjectType() {
        return false;
    }

    boolean isTheObjectType() {
        return false;
    }

    public boolean isStringValueType() {
        return false;
    }

    public final boolean isString() {
        return this.isSubtype(this.getNativeType(JSTypeNative.STRING_VALUE_OR_OBJECT_TYPE));
    }

    public final boolean isNumber() {
        return this.isSubtype(this.getNativeType(JSTypeNative.NUMBER_VALUE_OR_OBJECT_TYPE));
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isBooleanObjectType() {
        return false;
    }

    public boolean isBooleanValueType() {
        return false;
    }

    public boolean isRegexpType() {
        return false;
    }

    public boolean isDateType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isVoidType() {
        return false;
    }

    public boolean isAllType() {
        return false;
    }

    public boolean isUnknownType() {
        return false;
    }

    public boolean isCheckedUnknownType() {
        return false;
    }

    public boolean isUnionType() {
        return false;
    }

    public boolean isFunctionType() {
        return false;
    }

    public boolean isEnumElementType() {
        return false;
    }

    public boolean isEnumType() {
        return false;
    }

    boolean isNamedType() {
        return false;
    }

    public boolean isRecordType() {
        return false;
    }

    public boolean isTemplateType() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isNominalType() {
        return false;
    }

    public boolean isInstanceType() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isOrdinaryFunction() {
        return false;
    }

    public boolean isEquivalentTo(JSType jSType) {
        if (jSType instanceof ProxyObjectType) {
            return jSType.isEquivalentTo(this);
        }
        return this == jSType;
    }

    public static boolean isEquivalent(JSType jSType, JSType jSType2) {
        return jSType == null || jSType2 == null ? jSType == jSType2 : jSType.isEquivalentTo(jSType2);
    }

    public boolean equals(Object object) {
        return object instanceof JSType ? this.isEquivalentTo((JSType)object) : false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean matchesInt32Context() {
        return this.matchesNumberContext();
    }

    public final boolean matchesUint32Context() {
        return this.matchesNumberContext();
    }

    public boolean matchesNumberContext() {
        return false;
    }

    public boolean matchesStringContext() {
        return false;
    }

    public boolean matchesObjectContext() {
        return false;
    }

    public JSType findPropertyType(String string) {
        ObjectType objectType = ObjectType.cast(this.autoboxesTo());
        if (objectType != null) {
            return objectType.findPropertyType(string);
        }
        return null;
    }

    public boolean canBeCalled() {
        return false;
    }

    public boolean canAssignTo(JSType jSType) {
        return this.isSubtype(jSType);
    }

    public JSType autoboxesTo() {
        return null;
    }

    public JSType unboxesTo() {
        return null;
    }

    public ObjectType toObjectType() {
        return this instanceof ObjectType ? (ObjectType)this : null;
    }

    public final ObjectType dereference() {
        JSType jSType = this.restrictByNotNullOrUndefined();
        JSType jSType2 = jSType.autoboxesTo();
        return ObjectType.cast(jSType2 == null ? jSType : jSType2);
    }

    public final boolean canTestForEqualityWith(JSType jSType) {
        return this.testForEquality(jSType).equals((Object)TernaryValue.UNKNOWN);
    }

    public TernaryValue testForEquality(JSType jSType) {
        return this.testForEqualityHelper(this, jSType);
    }

    TernaryValue testForEqualityHelper(JSType jSType, JSType jSType2) {
        if (jSType2.isAllType() || jSType2.isUnknownType() || jSType2.isNoResolvedType() || jSType.isAllType() || jSType.isUnknownType() || jSType.isNoResolvedType()) {
            return TernaryValue.UNKNOWN;
        }
        boolean bl = jSType.isEmptyType();
        boolean bl2 = jSType2.isEmptyType();
        if (bl || bl2) {
            if (bl && bl2) {
                return TernaryValue.TRUE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (jSType.isFunctionType() || jSType2.isFunctionType()) {
            JSType jSType3 = jSType.isFunctionType() ? jSType2 : jSType;
            JSType jSType4 = jSType3.getGreatestSubtype(this.getNativeType(JSTypeNative.OBJECT_TYPE));
            if (jSType4.isNoType() || jSType4.isNoObjectType()) {
                return TernaryValue.FALSE;
            }
            return TernaryValue.UNKNOWN;
        }
        if (jSType2.isEnumElementType() || jSType2.isUnionType()) {
            return jSType2.testForEquality(jSType);
        }
        return null;
    }

    public final boolean canTestForShallowEqualityWith(JSType jSType) {
        return this.isSubtype(jSType) || jSType.isSubtype(this);
    }

    public boolean isNullable() {
        return this.isSubtype(this.getNativeType(JSTypeNative.NULL_TYPE));
    }

    public JSType getLeastSupertype(JSType jSType) {
        if (jSType.isUnionType()) {
            return jSType.getLeastSupertype(this);
        }
        return JSType.getLeastSupertype(this, jSType);
    }

    static JSType getLeastSupertype(JSType jSType, JSType jSType2) {
        boolean bl = jSType.isEquivalentTo(jSType2);
        return bl ? jSType : JSType.filterNoResolvedType(jSType.registry.createUnionType(jSType, jSType2));
    }

    public JSType getGreatestSubtype(JSType jSType) {
        if (jSType.isRecordType()) {
            return jSType.getGreatestSubtype(this);
        }
        return JSType.getGreatestSubtype(this, jSType);
    }

    static JSType getGreatestSubtype(JSType jSType, JSType jSType2) {
        if (jSType.isEquivalentTo(jSType2)) {
            return jSType;
        }
        if (jSType.isUnknownType() || jSType2.isUnknownType()) {
            return jSType.isEquivalentTo(jSType2) ? jSType : jSType.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        if (jSType.isSubtype(jSType2)) {
            return JSType.filterNoResolvedType(jSType);
        }
        if (jSType2.isSubtype(jSType)) {
            return JSType.filterNoResolvedType(jSType2);
        }
        if (jSType.isUnionType()) {
            return ((UnionType)jSType).meet(jSType2);
        }
        if (jSType2.isUnionType()) {
            return ((UnionType)jSType2).meet(jSType);
        }
        if (jSType.isObject() && jSType2.isObject()) {
            return jSType.getNativeType(JSTypeNative.NO_OBJECT_TYPE);
        }
        return jSType.getNativeType(JSTypeNative.NO_TYPE);
    }

    static JSType filterNoResolvedType(JSType jSType) {
        if (jSType.isNoResolvedType()) {
            return jSType.getNativeType(JSTypeNative.NO_RESOLVED_TYPE);
        }
        if (jSType instanceof UnionType) {
            UnionType unionType = (UnionType)jSType;
            boolean bl = false;
            for (JSType object : unionType.getAlternates()) {
                if (!object.isNoResolvedType()) continue;
                bl = true;
                break;
            }
            if (bl) {
                UnionTypeBuilder unionTypeBuilder = new UnionTypeBuilder(jSType.registry);
                for (JSType jSType2 : unionType.getAlternates()) {
                    if (jSType2.isNoResolvedType()) continue;
                    unionTypeBuilder.addAlternate(jSType2);
                }
                return unionTypeBuilder.build();
            }
        }
        return jSType;
    }

    public JSType getRestrictedTypeGivenToBooleanOutcome(boolean bl) {
        BooleanLiteralSet booleanLiteralSet = this.getPossibleToBooleanOutcomes();
        if (booleanLiteralSet.contains(bl)) {
            return this;
        }
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    public abstract BooleanLiteralSet getPossibleToBooleanOutcomes();

    public TypePair getTypesUnderEquality(JSType jSType) {
        if (jSType instanceof UnionType) {
            TypePair typePair = jSType.getTypesUnderEquality(this);
            return new TypePair(typePair.typeB, typePair.typeA);
        }
        switch (this.testForEquality(jSType)) {
            case FALSE: {
                return new TypePair(null, null);
            }
            case TRUE: 
            case UNKNOWN: {
                return new TypePair(this, jSType);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderInequality(JSType jSType) {
        if (jSType instanceof UnionType) {
            TypePair typePair = jSType.getTypesUnderInequality(this);
            return new TypePair(typePair.typeB, typePair.typeA);
        }
        switch (this.testForEquality(jSType)) {
            case TRUE: {
                JSType jSType2 = this.getNativeType(JSTypeNative.NO_TYPE);
                return new TypePair(jSType2, jSType2);
            }
            case FALSE: 
            case UNKNOWN: {
                return new TypePair(this, jSType);
            }
        }
        throw new IllegalStateException();
    }

    public TypePair getTypesUnderShallowEquality(JSType jSType) {
        JSType jSType2 = this.getGreatestSubtype(jSType);
        return new TypePair(jSType2, jSType2);
    }

    public TypePair getTypesUnderShallowInequality(JSType jSType) {
        if (jSType instanceof UnionType) {
            TypePair typePair = jSType.getTypesUnderShallowInequality(this);
            return new TypePair(typePair.typeB, typePair.typeA);
        }
        if (this.isNullType() && jSType.isNullType() || this.isVoidType() && jSType.isVoidType()) {
            return new TypePair(null, null);
        }
        return new TypePair(this, jSType);
    }

    public JSType restrictByNotNullOrUndefined() {
        return this;
    }

    public abstract boolean isSubtype(JSType var1);

    public boolean differsFrom(JSType jSType) {
        if (!this.isUnknownType() && !jSType.isUnknownType()) {
            return !this.isEquivalentTo(jSType);
        }
        return this.isUnknownType() ^ jSType.isUnknownType();
    }

    static boolean isSubtype(JSType jSType, JSType jSType2) {
        if (jSType2.isUnknownType()) {
            return true;
        }
        if (jSType.isEquivalentTo(jSType2)) {
            return true;
        }
        if (jSType2.isAllType()) {
            return true;
        }
        if (jSType2 instanceof UnionType) {
            UnionType unionType = (UnionType)jSType2;
            for (JSType jSType3 : unionType.alternates) {
                if (!jSType.isSubtype(jSType3)) continue;
                return true;
            }
        }
        if (jSType2 instanceof NamedType) {
            return jSType.isSubtype(((NamedType)jSType2).getReferencedType());
        }
        return false;
    }

    public abstract <T> T visit(Visitor<T> var1);

    public final JSType forceResolve(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        JSTypeRegistry.ResolveMode resolveMode = this.registry.getResolveMode();
        this.registry.setResolveMode(JSTypeRegistry.ResolveMode.IMMEDIATE);
        JSType jSType = this.resolve(errorReporter, staticScope);
        this.registry.setResolveMode(resolveMode);
        return jSType;
    }

    public final JSType resolve(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        if (this.resolved) {
            if (this.resolveResult == null) {
                return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            }
            return this.resolveResult;
        }
        this.resolved = true;
        this.resolveResult = this.resolveInternal(errorReporter, staticScope);
        this.resolveResult.setResolvedTypeInternal(this.resolveResult);
        return this.resolveResult;
    }

    abstract JSType resolveInternal(ErrorReporter var1, StaticScope<JSType> var2);

    void setResolvedTypeInternal(JSType jSType) {
        this.resolveResult = jSType;
        this.resolved = true;
    }

    public final boolean isResolved() {
        return this.resolved;
    }

    public final void clearResolved() {
        this.resolved = false;
        this.resolveResult = null;
    }

    static final JSType safeResolve(JSType jSType, ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        return jSType == null ? null : jSType.resolve(errorReporter, staticScope);
    }

    public boolean setValidator(Predicate<JSType> predicate) {
        return predicate.apply((Object)this);
    }

    public String toDebugHashCodeString() {
        return "{" + this.hashCode() + "}";
    }

    public static class TypePair {
        public final JSType typeA;
        public final JSType typeB;

        public TypePair(JSType jSType, JSType jSType2) {
            this.typeA = jSType;
            this.typeB = jSType2;
        }
    }
}

