/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;

class DisambiguatePrivateProperties
implements NodeTraversal.Callback,
CompilerPass {
    private final AbstractCompiler compiler;
    private String fileid;
    private int id = 0;

    DisambiguatePrivateProperties(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (n.isScript()) {
            this.fileid = "$" + this.id++;
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 33: {
                this.maybeRename(n.getLastChild());
                break;
            }
            case 147: 
            case 148: 
            case 154: {
                this.maybeRename(n);
            }
        }
    }

    private void maybeRename(Node n) {
        CodingConvention convention = this.compiler.getCodingConvention();
        String prop = n.getString();
        if (!n.getBooleanProp(36) && convention.isPrivate(prop)) {
            n.setString(prop + this.fileid);
            this.compiler.reportCodeChange();
        }
    }
}

