/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.MinimizedCondition;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;

class PeepholeMinimizeConditions
extends AbstractPeepholeOptimization {
    private static final int AND_PRECEDENCE = NodeUtil.precedence(101);
    private static final int NOT_PRECEDENCE = NodeUtil.precedence(26);
    private static final boolean DEFAULT_AGGRESSIVE_MINIMIZE_CONDITIONS = true;
    private final boolean late;
    private final boolean aggressiveMinimization;
    static final Predicate<Node> DONT_TRAVERSE_FUNCTIONS_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return !input.isFunction();
        }
    };

    PeepholeMinimizeConditions(boolean late) {
        this(late, true);
    }

    PeepholeMinimizeConditions(boolean late, boolean aggressive) {
        this.late = late;
        this.aggressiveMinimization = aggressive;
    }

    @Override
    public Node optimizeSubtree(Node node) {
        switch (node.getType()) {
            case 4: 
            case 49: {
                Node result = this.tryRemoveRedundantExit(node);
                if (result != node) {
                    return result;
                }
                return this.tryReplaceExitWithBreak(node);
            }
            case 26: {
                this.tryMinimizeCondition(node.getFirstChild());
                return this.tryMinimizeNot(node);
            }
            case 108: {
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeIf(node);
            }
            case 130: {
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeExprResult(node);
            }
            case 98: {
                this.performConditionSubstitutions(node.getFirstChild());
                return this.tryMinimizeHook(node);
            }
            case 113: 
            case 114: {
                this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                return node;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.tryJoinForCondition(node);
                    this.tryMinimizeCondition(NodeUtil.getConditionExpression(node));
                }
                return node;
            }
            case 125: {
                return this.tryReplaceIf(node);
            }
        }
        return node;
    }

    private void tryJoinForCondition(Node n) {
        Node maybeBreak;
        if (!this.late) {
            return;
        }
        Node block = n.getLastChild();
        Node maybeIf = block.getFirstChild();
        if (maybeIf != null && maybeIf.isIf() && (maybeBreak = maybeIf.getChildAtIndex(1).getFirstChild()) != null && maybeBreak.isBreak() && !maybeBreak.hasChildren()) {
            if (maybeIf.getChildCount() == 3) {
                block.replaceChild(maybeIf, maybeIf.getLastChild().detachFromParent());
            } else {
                block.removeFirstChild();
            }
            Node ifCondition = maybeIf.removeFirstChild();
            Node fixedIfCondition = IR.not(ifCondition).srcref(ifCondition);
            Node forCondition = NodeUtil.getConditionExpression(n);
            if (forCondition.isEmpty()) {
                n.replaceChild(forCondition, fixedIfCondition);
            } else {
                Node replacement = new Node(101);
                n.replaceChild(forCondition, replacement);
                replacement.addChildToBack(forCondition);
                replacement.addChildToBack(fixedIfCondition);
            }
            this.reportCodeChange();
        }
    }

    private Node tryReplaceIf(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isIf()) continue;
            Node cond = child.getFirstChild();
            Node thenBranch = cond.getNext();
            Node elseBranch = thenBranch.getNext();
            Node nextNode = child.getNext();
            if (nextNode != null && elseBranch == null && PeepholeMinimizeConditions.isReturnBlock(thenBranch) && nextNode.isIf()) {
                Node newCond;
                Node nextCond = nextNode.getFirstChild();
                Node nextThen = nextCond.getNext();
                Node nextElse = nextThen.getNext();
                if (thenBranch.isEquivalentToTyped(nextThen)) {
                    child.detachFromParent();
                    child.detachChildren();
                    newCond = new Node(100, cond);
                    nextNode.replaceChild(nextCond, newCond);
                    newCond.addChildToBack(nextCond);
                    this.reportCodeChange();
                    continue;
                }
                if (nextElse == null || !thenBranch.isEquivalentToTyped(nextElse)) continue;
                child.detachFromParent();
                child.detachChildren();
                newCond = new Node(101, IR.not(cond).srcref(cond));
                nextNode.replaceChild(nextCond, newCond);
                newCond.addChildToBack(nextCond);
                this.reportCodeChange();
                continue;
            }
            if (nextNode != null && elseBranch == null && PeepholeMinimizeConditions.isReturnBlock(thenBranch) && PeepholeMinimizeConditions.isReturnExpression(nextNode)) {
                Node thenExpr = null;
                if (PeepholeMinimizeConditions.isReturnExpressBlock(thenBranch)) {
                    thenExpr = PeepholeMinimizeConditions.getBlockReturnExpression(thenBranch);
                    thenExpr.detachFromParent();
                } else {
                    thenExpr = NodeUtil.newUndefinedNode(child);
                }
                Node elseExpr = nextNode.getFirstChild();
                cond.detachFromParent();
                elseExpr.detachFromParent();
                Node returnNode = IR.returnNode(IR.hook(cond, thenExpr, elseExpr).srcref(child));
                n.replaceChild(child, returnNode);
                n.removeChild(nextNode);
                this.reportCodeChange();
                continue;
            }
            if (elseBranch == null || !this.statementMustExitParent(thenBranch)) continue;
            child.removeChild(elseBranch);
            n.addChildAfter(elseBranch, child);
            this.reportCodeChange();
        }
        return n;
    }

    private boolean statementMustExitParent(Node n) {
        switch (n.getType()) {
            case 4: 
            case 49: {
                return true;
            }
            case 125: {
                if (n.hasChildren()) {
                    Node child = n.getLastChild();
                    return this.statementMustExitParent(child);
                }
                return false;
            }
        }
        return false;
    }

    private Node tryReplaceExitWithBreak(Node n) {
        Node result = n.getFirstChild();
        Node breakTarget = n;
        while (!ControlFlowAnalysis.isBreakTarget(breakTarget, null)) {
            if (breakTarget.isFunction() || breakTarget.isScript()) {
                return n;
            }
            breakTarget = breakTarget.getParent();
        }
        Node follow = ControlFlowAnalysis.computeFollowNode(breakTarget);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = this.skipFinallyNodes(follow)) && !this.isPure(result)) {
            return n;
        }
        if (follow == null && (n.isThrow() || result != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            Node replacement = IR.breakNode();
            n.getParent().replaceChild(n, replacement);
            this.reportCodeChange();
            return replacement;
        }
        return n;
    }

    private Node tryRemoveRedundantExit(Node n) {
        Node exitExpr = n.getFirstChild();
        Node follow = ControlFlowAnalysis.computeFollowNode(n);
        Node prefinallyFollows = follow;
        if (prefinallyFollows != (follow = this.skipFinallyNodes(follow)) && !this.isPure(exitExpr)) {
            return n;
        }
        if (follow == null && (n.isThrow() || exitExpr != null)) {
            return n;
        }
        if (follow == null || this.areMatchingExits(n, follow)) {
            n.detachFromParent();
            this.reportCodeChange();
            return null;
        }
        return n;
    }

    boolean isPure(Node n) {
        return n == null || !NodeUtil.canBeSideEffected(n) && !this.mayHaveSideEffects(n);
    }

    Node skipFinallyNodes(Node n) {
        while (n != null && NodeUtil.isTryFinallyNode(n.getParent(), n)) {
            n = ControlFlowAnalysis.computeFollowNode(n);
        }
        return n;
    }

    boolean areMatchingExits(Node nodeThis, Node nodeThat) {
        return nodeThis.isEquivalentTo(nodeThat) && (!this.isExceptionPossible(nodeThis) || this.getExceptionHandler(nodeThis) == this.getExceptionHandler(nodeThat));
    }

    boolean isExceptionPossible(Node n) {
        Preconditions.checkState((n.isReturn() || n.isThrow() ? 1 : 0) != 0);
        return n.isThrow() || n.hasChildren() && !NodeUtil.isLiteralValue(n.getLastChild(), true);
    }

    Node getExceptionHandler(Node n) {
        return ControlFlowAnalysis.getExceptionHandler(n);
    }

    private Node tryMinimizeNot(Node n) {
        int complementOperator;
        Preconditions.checkArgument((boolean)n.isNot());
        Node parent = n.getParent();
        Node notChild = n.getFirstChild();
        switch (notChild.getType()) {
            case 12: {
                complementOperator = 13;
                break;
            }
            case 13: {
                complementOperator = 12;
                break;
            }
            case 45: {
                complementOperator = 46;
                break;
            }
            case 46: {
                complementOperator = 45;
                break;
            }
            default: {
                return n;
            }
        }
        Node newOperator = n.removeFirstChild();
        newOperator.setType(complementOperator);
        parent.replaceChild(n, newOperator);
        this.reportCodeChange();
        return newOperator;
    }

    private Node tryMinimizeExprResult(Node n) {
        MinimizedCondition minCond = this.aggressiveMinimization ? MinimizedCondition.fromConditionNode(n.getFirstChild()) : MinimizedCondition.unoptimized(n.getFirstChild());
        MinimizedCondition.MeasuredNode mNode = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        Node placeholder = minCond.getPlaceholder();
        if (mNode.getNode().isNot()) {
            n.replaceChild(placeholder, mNode.getNode().removeFirstChild());
            this.reportCodeChange();
        } else {
            this.replaceNode(placeholder, mNode);
        }
        return n;
    }

    private Node tryMinimizeHook(Node n) {
        MinimizedCondition minCond = this.aggressiveMinimization ? MinimizedCondition.fromConditionNode(n.getFirstChild()) : MinimizedCondition.unoptimized(n.getFirstChild());
        MinimizedCondition.MeasuredNode mNode = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        Node placeholder = minCond.getPlaceholder();
        if (mNode.getNode().isNot()) {
            Node thenBranch = n.getFirstChild().getNext();
            n.replaceChild(placeholder, mNode.getNode().removeFirstChild());
            n.removeChild(thenBranch);
            n.addChildToBack(thenBranch);
            this.reportCodeChange();
        } else {
            this.replaceNode(placeholder, mNode);
        }
        return n;
    }

    private Node tryMinimizeIf(Node n) {
        Node parent = n.getParent();
        Node originalCond = n.getFirstChild();
        if (NodeUtil.isLiteralValue(originalCond, true)) {
            return n;
        }
        Node thenBranch = originalCond.getNext();
        Node elseBranch = thenBranch.getNext();
        MinimizedCondition minCond = this.aggressiveMinimization ? MinimizedCondition.fromConditionNode(originalCond) : MinimizedCondition.unoptimized(originalCond);
        originalCond = null;
        Node placeholder = minCond.getPlaceholder();
        MinimizedCondition.MeasuredNode unnegatedCond = minCond.getMinimized(MinimizedCondition.MinimizationStyle.PREFER_UNNEGATED);
        MinimizedCondition.MeasuredNode shortCond = minCond.getMinimized(MinimizedCondition.MinimizationStyle.ALLOW_LEADING_NOT);
        if (elseBranch == null) {
            Node innerCond;
            Node innerThenBranch;
            Node innerElseBranch;
            Node innerIf;
            if (PeepholeMinimizeConditions.isFoldableExpressBlock(thenBranch)) {
                Node expr = PeepholeMinimizeConditions.getBlockExpression(thenBranch);
                if (!this.late && PeepholeMinimizeConditions.isPropertyAssignmentInExpression(expr)) {
                    this.replaceNode(placeholder, unnegatedCond);
                    return n;
                }
                if (shortCond.getNode().isNot()) {
                    Node or = IR.or(shortCond.getNode().removeFirstChild(), expr.removeFirstChild()).srcref(n);
                    Node newExpr = NodeUtil.newExpr(or);
                    parent.replaceChild(n, newExpr);
                    this.reportCodeChange();
                    return newExpr;
                }
                if (PeepholeMinimizeConditions.isLowerPrecedence(shortCond.getNode(), AND_PRECEDENCE) && PeepholeMinimizeConditions.isLowerPrecedence(expr.getFirstChild(), AND_PRECEDENCE)) {
                    this.replaceNode(placeholder, shortCond);
                    return n;
                }
                n.removeChild(placeholder);
                Node and = IR.and(shortCond.getNode(), expr.removeFirstChild()).srcref(n);
                Node newExpr = NodeUtil.newExpr(and);
                parent.replaceChild(n, newExpr);
                this.reportCodeChange();
                return newExpr;
            }
            if (NodeUtil.isStatementBlock(thenBranch) && thenBranch.hasOneChild() && (innerIf = thenBranch.getFirstChild()).isIf() && (innerElseBranch = (innerThenBranch = (innerCond = innerIf.getFirstChild()).getNext()).getNext()) == null && (!PeepholeMinimizeConditions.isLowerPrecedence(unnegatedCond.getNode(), AND_PRECEDENCE) || !PeepholeMinimizeConditions.isLowerPrecedence(innerCond, AND_PRECEDENCE))) {
                n.detachChildren();
                n.addChildToBack(IR.and(unnegatedCond.getNode(), innerCond.detachFromParent()).srcref(placeholder));
                n.addChildrenToBack(innerThenBranch.detachFromParent());
                this.reportCodeChange();
                return n;
            }
            this.replaceNode(placeholder, unnegatedCond);
            return n;
        }
        this.tryRemoveRepeatedStatements(n);
        if (shortCond.getNode().isNot() && !PeepholeMinimizeConditions.consumesDanglingElse(elseBranch)) {
            n.replaceChild(placeholder, shortCond.getNode().removeFirstChild());
            n.removeChild(thenBranch);
            n.addChildToBack(thenBranch);
            this.reportCodeChange();
            return n;
        }
        if (PeepholeMinimizeConditions.isReturnExpressBlock(thenBranch) && PeepholeMinimizeConditions.isReturnExpressBlock(elseBranch)) {
            Node thenExpr = PeepholeMinimizeConditions.getBlockReturnExpression(thenBranch);
            Node elseExpr = PeepholeMinimizeConditions.getBlockReturnExpression(elseBranch);
            n.removeChild(placeholder);
            thenExpr.detachFromParent();
            elseExpr.detachFromParent();
            Node returnNode = IR.returnNode(IR.hook(shortCond.getNode(), thenExpr, elseExpr).srcref(n));
            parent.replaceChild(n, returnNode);
            this.reportCodeChange();
            return returnNode;
        }
        boolean thenBranchIsExpressionBlock = PeepholeMinimizeConditions.isFoldableExpressBlock(thenBranch);
        boolean elseBranchIsExpressionBlock = PeepholeMinimizeConditions.isFoldableExpressBlock(elseBranch);
        if (thenBranchIsExpressionBlock && elseBranchIsExpressionBlock) {
            Node lhs;
            Node thenOp = PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild();
            Node elseOp = PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild();
            if (thenOp.getType() == elseOp.getType() && NodeUtil.isAssignmentOp(thenOp) && this.areNodesEqualForInlining(lhs = thenOp.getFirstChild(), elseOp.getFirstChild()) && !this.mayEffectMutableState(lhs) && (!this.mayHaveSideEffects(unnegatedCond.getNode()) || thenOp.isAssign() && thenOp.getFirstChild().isName())) {
                n.removeChild(placeholder);
                Node assignName = thenOp.removeFirstChild();
                Node thenExpr = thenOp.removeFirstChild();
                Node elseExpr = elseOp.getLastChild();
                elseOp.removeChild(elseExpr);
                Node hookNode = IR.hook(shortCond.getNode(), thenExpr, elseExpr).srcref(n);
                Node assign = new Node(thenOp.getType(), assignName, hookNode).srcref(thenOp);
                Node expr = NodeUtil.newExpr(assign);
                parent.replaceChild(n, expr);
                this.reportCodeChange();
                return expr;
            }
            n.removeChild(placeholder);
            thenOp.detachFromParent();
            elseOp.detachFromParent();
            Node expr = IR.exprResult(IR.hook(shortCond.getNode(), thenOp, elseOp).srcref(n));
            parent.replaceChild(n, expr);
            this.reportCodeChange();
            return expr;
        }
        boolean thenBranchIsVar = PeepholeMinimizeConditions.isVarBlock(thenBranch);
        boolean elseBranchIsVar = PeepholeMinimizeConditions.isVarBlock(elseBranch);
        if (thenBranchIsVar && elseBranchIsExpressionBlock && PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild().isAssign()) {
            Node var = PeepholeMinimizeConditions.getBlockVar(thenBranch);
            Node elseAssign = PeepholeMinimizeConditions.getBlockExpression(elseBranch).getFirstChild();
            Node name1 = var.getFirstChild();
            Node maybeName2 = elseAssign.getFirstChild();
            if (name1.hasChildren() && maybeName2.isName() && name1.getString().equals(maybeName2.getString())) {
                Node thenExpr = name1.removeChildren();
                Node elseExpr = elseAssign.getLastChild().detachFromParent();
                placeholder.detachFromParent();
                Node hookNode = IR.hook(shortCond.getNode(), thenExpr, elseExpr).srcref(n);
                var.detachFromParent();
                name1.addChildrenToBack(hookNode);
                parent.replaceChild(n, var);
                this.reportCodeChange();
                return var;
            }
        } else if (elseBranchIsVar && thenBranchIsExpressionBlock && PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild().isAssign()) {
            Node var = PeepholeMinimizeConditions.getBlockVar(elseBranch);
            Node thenAssign = PeepholeMinimizeConditions.getBlockExpression(thenBranch).getFirstChild();
            Node maybeName1 = thenAssign.getFirstChild();
            Node name2 = var.getFirstChild();
            if (name2.hasChildren() && maybeName1.isName() && maybeName1.getString().equals(name2.getString())) {
                Node thenExpr = thenAssign.getLastChild().detachFromParent();
                Node elseExpr = name2.removeChildren();
                placeholder.detachFromParent();
                Node hookNode = IR.hook(shortCond.getNode(), thenExpr, elseExpr).srcref(n);
                var.detachFromParent();
                name2.addChildrenToBack(hookNode);
                parent.replaceChild(n, var);
                this.reportCodeChange();
                return var;
            }
        }
        this.replaceNode(placeholder, unnegatedCond);
        return n;
    }

    private void tryRemoveRepeatedStatements(Node n) {
        Preconditions.checkState((boolean)n.isIf());
        Node parent = n.getParent();
        if (!NodeUtil.isStatementBlock(parent)) {
            return;
        }
        Node cond = n.getFirstChild();
        Node trueBranch = cond.getNext();
        Node falseBranch = trueBranch.getNext();
        Preconditions.checkNotNull((Object)trueBranch);
        Preconditions.checkNotNull((Object)falseBranch);
        while (true) {
            Node lastTrue = trueBranch.getLastChild();
            Node lastFalse = falseBranch.getLastChild();
            if (lastTrue == null || lastFalse == null || !this.areNodesEqualForInlining(lastTrue, lastFalse)) break;
            lastTrue.detachFromParent();
            lastFalse.detachFromParent();
            parent.addChildAfter(lastTrue, n);
            this.reportCodeChange();
        }
    }

    private static boolean isFoldableExpressBlock(Node n) {
        if (n.isBlock() && n.hasOneChild()) {
            Node maybeExpr = n.getFirstChild();
            if (maybeExpr.isExprResult()) {
                if (maybeExpr.getFirstChild().isCall()) {
                    Node calledFn = maybeExpr.getFirstChild().getFirstChild();
                    if (calledFn.isGetElem()) {
                        return false;
                    }
                    if (calledFn.isGetProp() && calledFn.getLastChild().getString().startsWith("on")) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static Node getBlockExpression(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isFoldableExpressBlock(n));
        return n.getFirstChild();
    }

    private static boolean isReturnBlock(Node n) {
        if (n.isBlock() && n.hasOneChild()) {
            Node first = n.getFirstChild();
            return first.isReturn();
        }
        return false;
    }

    private static boolean isReturnExpressBlock(Node n) {
        Node first;
        if (n.isBlock() && n.hasOneChild() && (first = n.getFirstChild()).isReturn()) {
            return first.hasOneChild();
        }
        return false;
    }

    private static boolean isReturnExpression(Node n) {
        if (n.isReturn()) {
            return n.hasOneChild();
        }
        return false;
    }

    private static Node getBlockReturnExpression(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isReturnExpressBlock(n));
        return n.getFirstChild().getFirstChild();
    }

    private static boolean isVarBlock(Node n) {
        Node first;
        if (n.isBlock() && n.hasOneChild() && (first = n.getFirstChild()).isVar()) {
            return first.hasOneChild();
        }
        return false;
    }

    private static Node getBlockVar(Node n) {
        Preconditions.checkState((boolean)PeepholeMinimizeConditions.isVarBlock(n));
        return n.getFirstChild();
    }

    private static boolean consumesDanglingElse(Node n) {
        block5: while (true) {
            switch (n.getType()) {
                case 108: {
                    if (n.getChildCount() < 3) {
                        return true;
                    }
                    n = n.getLastChild();
                    continue block5;
                }
                case 125: {
                    if (n.getChildCount() != 1) {
                        return false;
                    }
                    n = n.getLastChild();
                    continue block5;
                }
                case 113: 
                case 115: 
                case 119: {
                    n = n.getLastChild();
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    static boolean isLowerPrecedence(Node n, int precedence) {
        return NodeUtil.precedence(n.getType()) < precedence;
    }

    private static boolean isHigherPrecedence(Node n, int precedence) {
        return NodeUtil.precedence(n.getType()) > precedence;
    }

    private static boolean isPropertyAssignmentInExpression(Node n) {
        Predicate<Node> isPropertyAssignmentInExpressionPredicate = new Predicate<Node>(){

            public boolean apply(Node input) {
                return input.isGetProp() && input.getParent().isAssign();
            }
        };
        return NodeUtil.has(n, isPropertyAssignmentInExpressionPredicate, DONT_TRAVERSE_FUNCTIONS_PREDICATE);
    }

    private Node tryMinimizeCondition(Node n) {
        n = this.performConditionSubstitutions(n);
        if (this.aggressiveMinimization) {
            MinimizedCondition minCond = MinimizedCondition.fromConditionNode(n);
            return this.replaceNode(minCond.getPlaceholder(), minCond.getMinimized(MinimizedCondition.MinimizationStyle.PREFER_UNNEGATED));
        }
        return n;
    }

    private Node replaceNode(Node lhs, MinimizedCondition.MeasuredNode rhs) {
        Node parent = lhs.getParent();
        parent.replaceChild(lhs, rhs.getNode());
        if (rhs.isChanged()) {
            this.reportCodeChange();
        }
        return rhs.getNode();
    }

    private Node performConditionSubstitutions(Node n) {
        if (!this.aggressiveMinimization && n.isNot()) {
            return this.simpleDemorgan(n);
        }
        Node parent = n.getParent();
        switch (n.getType()) {
            case 100: 
            case 101: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                left = this.performConditionSubstitutions(left);
                right = this.performConditionSubstitutions(right);
                TernaryValue rightVal = NodeUtil.getPureBooleanValue(right);
                if (NodeUtil.getPureBooleanValue(right) != TernaryValue.UNKNOWN) {
                    int type = n.getType();
                    Node replacement = null;
                    boolean rval = rightVal.toBoolean(true);
                    if (type == 100 && !rval || type == 101 && rval) {
                        replacement = left;
                    } else if (!this.mayHaveSideEffects(left)) {
                        replacement = right;
                    }
                    if (replacement != null) {
                        n.detachChildren();
                        parent.replaceChild(n, replacement);
                        this.reportCodeChange();
                        return replacement;
                    }
                }
                return n;
            }
            case 98: {
                Node condition = n.getFirstChild();
                Node trueNode = n.getFirstChild().getNext();
                Node falseNode = n.getLastChild();
                trueNode = this.performConditionSubstitutions(trueNode);
                falseNode = this.performConditionSubstitutions(falseNode);
                Node replacement = null;
                TernaryValue trueNodeVal = NodeUtil.getPureBooleanValue(trueNode);
                TernaryValue falseNodeVal = NodeUtil.getPureBooleanValue(falseNode);
                if (trueNodeVal == TernaryValue.TRUE && falseNodeVal == TernaryValue.FALSE) {
                    condition.detachFromParent();
                    replacement = condition;
                } else if (trueNodeVal == TernaryValue.FALSE && falseNodeVal == TernaryValue.TRUE) {
                    condition.detachFromParent();
                    replacement = IR.not(condition);
                } else if (trueNodeVal == TernaryValue.TRUE) {
                    n.detachChildren();
                    replacement = IR.or(condition, falseNode);
                } else if (falseNodeVal == TernaryValue.FALSE) {
                    n.detachChildren();
                    replacement = IR.and(condition, trueNode);
                }
                if (replacement != null) {
                    parent.replaceChild(n, replacement);
                    n = replacement;
                    this.reportCodeChange();
                }
                return n;
            }
        }
        TernaryValue nVal = NodeUtil.getPureBooleanValue(n);
        if (nVal != TernaryValue.UNKNOWN) {
            boolean result = nVal.toBoolean(true);
            int equivalentResult = result ? 1 : 0;
            return this.maybeReplaceChildWithNumber(n, parent, equivalentResult);
        }
        return n;
    }

    private Node simpleDemorgan(Node n) {
        Node parent = n.getParent();
        Node first = n.getFirstChild();
        switch (first.getType()) {
            case 26: {
                Node newRoot = first.removeFirstChild();
                parent.replaceChild(n, newRoot);
                this.reportCodeChange();
                return newRoot;
            }
            case 100: 
            case 101: {
                Node right;
                Node left;
                Node leftParent = first.getFirstChild();
                Node rightParent = first.getLastChild();
                if (!leftParent.isNot() && !rightParent.isNot()) {
                    int opPrecedence = NodeUtil.precedence(first.getType());
                    if (PeepholeMinimizeConditions.isLowerPrecedence(leftParent, NOT_PRECEDENCE) && PeepholeMinimizeConditions.isHigherPrecedence(leftParent, opPrecedence) || PeepholeMinimizeConditions.isLowerPrecedence(rightParent, NOT_PRECEDENCE) && PeepholeMinimizeConditions.isHigherPrecedence(rightParent, opPrecedence)) {
                        return n;
                    }
                }
                if (leftParent.isNot()) {
                    left = leftParent.removeFirstChild();
                } else {
                    leftParent.detachFromParent();
                    left = IR.not(leftParent).srcref(leftParent);
                }
                if (rightParent.isNot()) {
                    right = rightParent.removeFirstChild();
                } else {
                    rightParent.detachFromParent();
                    right = IR.not(rightParent).srcref(rightParent);
                }
                int newOp = first.isAnd() ? 100 : 101;
                Node newRoot = new Node(newOp, left, right);
                parent.replaceChild(n, newRoot);
                this.reportCodeChange();
                return newRoot;
            }
        }
        TernaryValue nVal = NodeUtil.getPureBooleanValue(first);
        if (nVal != TernaryValue.UNKNOWN) {
            boolean result = nVal.not().toBoolean(true);
            int equivalentResult = result ? 1 : 0;
            return this.maybeReplaceChildWithNumber(n, parent, equivalentResult);
        }
        return n;
    }

    private Node maybeReplaceChildWithNumber(Node n, Node parent, int num) {
        Node newNode = IR.number(num);
        if (!newNode.isEquivalentTo(n)) {
            parent.replaceChild(n, newNode);
            this.reportCodeChange();
            return newNode;
        }
        return n;
    }
}

