/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ShadowVariables;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;

final class RenameVars
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ArrayList<Node> globalNameNodes = new ArrayList();
    private final ArrayList<Node> localNameNodes = new ArrayList();
    private final Map<Node, String> pseudoNameMap;
    private final Set<String> externNames = new HashSet<String>();
    private final Set<String> reservedNames;
    private final Map<String, String> renameMap = new HashMap<String, String>();
    private final VariableMap prevUsedRenameMap;
    private final String prefix;
    private int assignmentCount = 0;
    private StringBuilder assignmentLog;
    private final Set<Scope.Var> localBleedingFunctions = Sets.newHashSet();
    private final ArrayListMultimap<Scope, Scope.Var> localBleedingFunctionsPerScope = ArrayListMultimap.create();
    private final Map<String, Assignment> assignments = new HashMap<String, Assignment>();
    private final boolean localRenamingOnly;
    private final boolean preserveFunctionExpressionNames;
    private final boolean shouldShadow;
    private final char[] reservedCharacters;
    public static final String LOCAL_VAR_PREFIX = "L ";
    private final NameGenerator nameGeneratorGiven;
    private static final Comparator<Assignment> FREQUENCY_COMPARATOR = new Comparator<Assignment>(){

        @Override
        public int compare(Assignment a1, Assignment a2) {
            if (a1.count != a2.count) {
                return a2.count - a1.count;
            }
            return ORDER_OF_OCCURRENCE_COMPARATOR.compare(a1, a2);
        }
    };
    private static final Comparator<Assignment> ORDER_OF_OCCURRENCE_COMPARATOR = new Comparator<Assignment>(){

        @Override
        public int compare(Assignment a1, Assignment a2) {
            return a1.orderOfOccurrence - a2.orderOfOccurrence;
        }
    };

    RenameVars(AbstractCompiler compiler, String prefix, boolean localRenamingOnly, boolean preserveFunctionExpressionNames, boolean generatePseudoNames, boolean shouldShadow, VariableMap prevUsedRenameMap, @Nullable char[] reservedCharacters, @Nullable Set<String> reservedNames) {
        this(compiler, prefix, localRenamingOnly, preserveFunctionExpressionNames, generatePseudoNames, shouldShadow, prevUsedRenameMap, reservedCharacters, reservedNames, null);
    }

    RenameVars(AbstractCompiler compiler, String prefix, boolean localRenamingOnly, boolean preserveFunctionExpressionNames, boolean generatePseudoNames, boolean shouldShadow, VariableMap prevUsedRenameMap, @Nullable char[] reservedCharacters, @Nullable Set<String> reservedNames, @Nullable NameGenerator nameGenerator) {
        this.compiler = compiler;
        this.prefix = prefix == null ? "" : prefix;
        this.localRenamingOnly = localRenamingOnly;
        this.preserveFunctionExpressionNames = preserveFunctionExpressionNames;
        this.pseudoNameMap = generatePseudoNames ? Maps.newHashMap() : null;
        this.prevUsedRenameMap = prevUsedRenameMap;
        this.reservedCharacters = reservedCharacters;
        this.shouldShadow = shouldShadow;
        this.reservedNames = reservedNames == null ? Sets.newHashSet() : Sets.newHashSet(reservedNames);
        this.nameGeneratorGiven = nameGenerator;
    }

    @Override
    public void process(Node externs, Node root) {
        String newName;
        this.assignmentLog = new StringBuilder();
        NodeTraversal.traverse(this.compiler, externs, new ProcessVars(true));
        NodeTraversal.traverse(this.compiler, root, new ProcessVars(false));
        this.reservedNames.addAll(this.externNames);
        TreeSet<Assignment> varsByFrequency = new TreeSet<Assignment>(FREQUENCY_COMPARATOR);
        varsByFrequency.addAll(this.assignments.values());
        if (this.shouldShadow) {
            new ShadowVariables(this.compiler, this.assignments, varsByFrequency, this.pseudoNameMap).process(externs, root);
        }
        if (this.prevUsedRenameMap != null) {
            this.reusePreviouslyUsedVariableMap();
        }
        this.assignNames(varsByFrequency);
        boolean changed = false;
        for (Node n : this.globalNameNodes) {
            newName = this.getNewGlobalName(n);
            if (newName == null) continue;
            n.setString(newName);
            changed = true;
        }
        for (Node n : this.localNameNodes) {
            newName = this.getNewLocalName(n);
            if (newName == null) continue;
            n.setString(newName);
            changed = true;
        }
        if (changed) {
            this.compiler.reportCodeChange();
        }
        this.compiler.addToDebugLog("JS var assignments:\n" + this.assignmentLog);
        this.assignmentLog = null;
    }

    private String getNewGlobalName(Node n) {
        String oldName = n.getString();
        Assignment a = this.assignments.get(oldName);
        if (a.newName != null && !a.newName.equals(oldName)) {
            if (this.pseudoNameMap != null) {
                return this.pseudoNameMap.get(n);
            }
            return a.newName;
        }
        return null;
    }

    private String getNewLocalName(Node n) {
        String oldTempName = n.getString();
        Assignment a = this.assignments.get(oldTempName);
        if (!a.newName.equals(oldTempName)) {
            if (this.pseudoNameMap != null) {
                return this.pseudoNameMap.get(n);
            }
            return a.newName;
        }
        return null;
    }

    private void recordPseudoName(Node n) {
        this.pseudoNameMap.put(n, '$' + n.getString() + "$$");
    }

    private void reusePreviouslyUsedVariableMap() {
        Preconditions.checkNotNull(this.prevUsedRenameMap.getNewNameToOriginalNameMap());
        for (Assignment a : this.assignments.values()) {
            String prevNewName = this.prevUsedRenameMap.lookupNewName(a.oldName);
            if (prevNewName == null || this.reservedNames.contains(prevNewName) || !a.oldName.startsWith(LOCAL_VAR_PREFIX) && (this.externNames.contains(a.oldName) || !prevNewName.startsWith(this.prefix))) continue;
            this.reservedNames.add(prevNewName);
            this.finalizeNameAssignment(a, prevNewName);
        }
    }

    private void assignNames(SortedSet<Assignment> varsToRename) {
        NameGenerator globalNameGenerator = null;
        NameGenerator localNameGenerator = null;
        if (this.nameGeneratorGiven != null) {
            globalNameGenerator = localNameGenerator = this.nameGeneratorGiven;
            this.nameGeneratorGiven.restartNaming();
        } else {
            globalNameGenerator = new NameGenerator(this.reservedNames, this.prefix, this.reservedCharacters);
            localNameGenerator = this.prefix.isEmpty() ? globalNameGenerator : new NameGenerator(this.reservedNames, "", this.reservedCharacters);
        }
        ArrayList<Assignment> pendingAssignments = new ArrayList<Assignment>();
        ArrayList<String> generatedNamesForAssignments = new ArrayList<String>();
        for (Assignment a : varsToRename) {
            String newName;
            if (a.newName != null || this.externNames.contains(a.oldName)) continue;
            if (a.oldName.startsWith(LOCAL_VAR_PREFIX)) {
                newName = localNameGenerator.generateNextName();
                this.finalizeNameAssignment(a, newName);
            } else {
                newName = globalNameGenerator.generateNextName();
                pendingAssignments.add(a);
                generatedNamesForAssignments.add(newName);
            }
            this.reservedNames.add(newName);
        }
        int numPendingAssignments = generatedNamesForAssignments.size();
        int i = 0;
        while (i < numPendingAssignments) {
            TreeSet<Assignment> varsByOrderOfOccurrence = new TreeSet<Assignment>(ORDER_OF_OCCURRENCE_COMPARATOR);
            int len = ((String)generatedNamesForAssignments.get(i)).length();
            for (int j = i; j < numPendingAssignments && ((String)generatedNamesForAssignments.get(j)).length() == len; ++j) {
                varsByOrderOfOccurrence.add((Assignment)pendingAssignments.get(j));
            }
            for (Assignment a : varsByOrderOfOccurrence) {
                this.finalizeNameAssignment(a, (String)generatedNamesForAssignments.get(i));
                ++i;
            }
        }
    }

    private void finalizeNameAssignment(Assignment a, String newName) {
        a.setNewName(newName);
        this.renameMap.put(a.oldName, newName);
        this.assignmentLog.append(a.oldName).append(" => ").append(newName).append('\n');
    }

    VariableMap getVariableMap() {
        return new VariableMap((Map<String, String>)ImmutableMap.copyOf(this.renameMap));
    }

    private boolean okToRenameVar(String name, boolean isLocal) {
        return !this.compiler.getCodingConvention().isExported(name, isLocal);
    }

    private int getLocalVarIndex(Scope.Var v) {
        boolean isBleedingIntoScope;
        int num = v.index;
        Scope s = v.scope.getParent();
        if (s == null) {
            throw new IllegalArgumentException("Var is not local");
        }
        boolean bl = isBleedingIntoScope = s.getParent() != null && this.localBleedingFunctions.contains(v);
        while (s.getParent() != null) {
            if (isBleedingIntoScope) {
                num += this.localBleedingFunctionsPerScope.get((Object)s).indexOf(v) + 1;
                isBleedingIntoScope = false;
            } else {
                num += this.localBleedingFunctionsPerScope.get((Object)s).size();
            }
            num += s.getVarCount();
            s = s.getParent();
        }
        return num;
    }

    class ProcessVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private final boolean isExternsPass_;

        ProcessVars(boolean isExterns) {
            this.isExternsPass_ = isExterns;
        }

        @Override
        public void enterScope(NodeTraversal t) {
            if (t.inGlobalScope()) {
                return;
            }
            Iterator<Scope.Var> it = t.getScope().getVars();
            while (it.hasNext()) {
                Scope.Var current = it.next();
                if (!current.isBleedingFunction()) continue;
                RenameVars.this.localBleedingFunctions.add(current);
                RenameVars.this.localBleedingFunctionsPerScope.put((Object)t.getScope().getParent(), (Object)current);
            }
        }

        @Override
        public void exitScope(NodeTraversal t) {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            boolean local;
            if (!n.isName()) {
                return;
            }
            String name = n.getString();
            if (name.length() == 0) {
                return;
            }
            Scope.Var var = t.getScope().getVar(name);
            boolean bl = local = var != null && var.isLocal() && (!var.scope.getParent().isGlobal() || !var.isBleedingFunction());
            if (!local && RenameVars.this.localRenamingOnly) {
                RenameVars.this.reservedNames.add(name);
                return;
            }
            if (RenameVars.this.preserveFunctionExpressionNames && var != null && NodeUtil.isFunctionExpression(var.getParentNode())) {
                RenameVars.this.reservedNames.add(name);
                return;
            }
            if (!RenameVars.this.okToRenameVar(name, local)) {
                String newName;
                if (local && !(newName = MakeDeclaredNamesUnique.ContextualRenameInverter.getOrginalName(name)).equals(name)) {
                    n.setString(newName);
                }
                return;
            }
            if (this.isExternsPass_) {
                if (!local) {
                    RenameVars.this.externNames.add(name);
                }
                return;
            }
            if (RenameVars.this.pseudoNameMap != null) {
                RenameVars.this.recordPseudoName(n);
            }
            if (local) {
                String tempName = RenameVars.LOCAL_VAR_PREFIX + RenameVars.this.getLocalVarIndex(var);
                this.incCount(tempName);
                RenameVars.this.localNameNodes.add(n);
                n.setString(tempName);
            } else if (var != null) {
                this.incCount(name);
                RenameVars.this.globalNameNodes.add(n);
            }
        }

        void incCount(String name) {
            Assignment s = (Assignment)RenameVars.this.assignments.get(name);
            if (s == null) {
                s = new Assignment(name);
                RenameVars.this.assignments.put(name, s);
            }
            ++s.count;
        }
    }

    class Assignment {
        final String oldName;
        final int orderOfOccurrence;
        String newName;
        int count;

        Assignment(String name) {
            this.oldName = name;
            this.newName = null;
            this.count = 0;
            this.orderOfOccurrence = RenameVars.this.assignmentCount++;
        }

        void setNewName(String newName) {
            Preconditions.checkState((this.newName == null ? 1 : 0) != 0);
            this.newName = newName;
        }
    }
}

