/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.fuzzing;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.fuzzing.AbstractFuzzer;
import com.google.javascript.jscomp.fuzzing.ArrayFuzzer;
import com.google.javascript.jscomp.fuzzing.BooleanFuzzer;
import com.google.javascript.jscomp.fuzzing.Dispatcher;
import com.google.javascript.jscomp.fuzzing.FuzzingContext;
import com.google.javascript.jscomp.fuzzing.NumericFuzzer;
import com.google.javascript.jscomp.fuzzing.ObjectFuzzer;
import com.google.javascript.jscomp.fuzzing.RegularExprFuzzer;
import com.google.javascript.jscomp.fuzzing.SimpleFuzzer;
import com.google.javascript.jscomp.fuzzing.StringFuzzer;
import com.google.javascript.jscomp.fuzzing.Type;
import com.google.javascript.rhino.Node;
import java.util.Set;

class LiteralFuzzer
extends Dispatcher {
    LiteralFuzzer(FuzzingContext context) {
        super(context);
    }

    @Override
    protected void initCandidates() {
        this.candidates = new AbstractFuzzer[]{new SimpleFuzzer(41, "null", Type.OBJECT), new GlobalValueFuzzer("undefined", Type.UNDEFINED), new GlobalValueFuzzer("Infinity", Type.NUMBER), new GlobalValueFuzzer("NaN", Type.NUMBER), new BooleanFuzzer(this.context), new NumericFuzzer(this.context), new StringFuzzer(this.context), new ArrayFuzzer(this.context), new RegularExprFuzzer(this.context), new ObjectFuzzer(this.context)};
    }

    @Override
    protected String getConfigName() {
        return "literal";
    }

    private class GlobalValueFuzzer
    extends AbstractFuzzer {
        private String value;
        private Type type;

        GlobalValueFuzzer(String value, Type type) {
            super(null);
            this.value = value;
            this.type = type;
        }

        @Override
        protected boolean isEnough(int budget) {
            return budget >= 1;
        }

        @Override
        protected Node generate(int budget, Set<Type> types) {
            return Node.newString(38, this.value);
        }

        @Override
        protected String getConfigName() {
            return this.value;
        }

        @Override
        protected Set<Type> supportedTypes() {
            return Sets.newHashSet((Object[])new Type[]{this.type});
        }
    }
}

