/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.PersistentMap;
import java.util.Map;

public class TypeEnv {
    private final PersistentMap<String, JSType> typeMap;

    public TypeEnv() {
        this.typeMap = PersistentMap.create();
    }

    private TypeEnv(PersistentMap<String, JSType> typeMap) {
        this.typeMap = typeMap;
    }

    public JSType getType(String n) {
        Preconditions.checkArgument((!n.contains(".") ? 1 : 0) != 0);
        return (JSType)this.typeMap.get(n);
    }

    public TypeEnv putType(String n, JSType t) {
        Preconditions.checkArgument((!n.contains(".") ? 1 : 0) != 0);
        Preconditions.checkArgument((t != null ? 1 : 0) != 0);
        return new TypeEnv(this.typeMap.with(n, t));
    }

    public static TypeEnv join(TypeEnv e1, TypeEnv e2) {
        PersistentMap<String, JSType> newMap = e1.typeMap;
        for (String n : e2.typeMap.keySet()) {
            JSType type1 = e1.getType(n);
            JSType type2 = e2.getType(n);
            newMap = newMap.with(n, type1 == null ? type2 : JSType.join(type1, type2));
        }
        return new TypeEnv(newMap);
    }

    public Multimap<String, String> getTaints() {
        HashMultimap taints = HashMultimap.create();
        for (Map.Entry entry : this.typeMap.entrySet()) {
            String formal = ((JSType)entry.getValue()).getLocation();
            if (formal == null) continue;
            taints.put((Object)formal, entry.getKey());
        }
        return taints;
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass());
        for (String key : this.typeMap.keySet()) {
            helper.add(key, (Object)this.getType(key));
        }
        return helper.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TypeEnv)) {
            return false;
        }
        TypeEnv other = (TypeEnv)o;
        return this.typeMap.equals(other.typeMap);
    }

    public int hashCode() {
        return this.typeMap.hashCode();
    }
}

