/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.SimpleFunctionAliasAnalysis;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class SpecializeModule
implements CompilerPass {
    private AbstractCompiler compiler;
    private Map<Node, Node> specializedInputRootsByOriginal;
    private Map<Node, OriginalFunctionInformation> functionInfoBySpecializedFunctionNode;
    private SpecializationState specializationState;
    private final PassFactory[] specializationPassFactories;

    public SpecializeModule(AbstractCompiler compiler, PassFactory ... specializationPassFactories) {
        this.compiler = compiler;
        this.specializationPassFactories = specializationPassFactories;
    }

    @Override
    public void process(Node externs, Node root) {
        JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
        if (moduleGraph == null) {
            return;
        }
        JSModule module = moduleGraph.getRootModule();
        Node fakeModuleRoot = this.copyModuleInputs(module);
        SimpleDefinitionFinder defFinder = new SimpleDefinitionFinder(this.compiler);
        defFinder.process(externs, fakeModuleRoot);
        SimpleFunctionAliasAnalysis initialModuleFunctionAliasAnalysis = new SimpleFunctionAliasAnalysis();
        initialModuleFunctionAliasAnalysis.analyze(defFinder);
        this.specializationState = new SpecializationState(initialModuleFunctionAliasAnalysis);
        do {
            this.specializationState.resetHasChanged();
            for (SpecializationAwareCompilerPass pass : this.createSpecializingPasses()) {
                pass.enableSpecialization(this.specializationState);
                pass.process(externs, fakeModuleRoot);
            }
        } while (this.specializationState.hasChanged());
        this.addDummyVarDeclarationsToInitialModule(module);
        this.replaceOriginalModuleInputsWithSpecialized();
        this.addOriginalFunctionVersionsToDependentModules(module);
    }

    private Collection<SpecializationAwareCompilerPass> createSpecializingPasses() {
        LinkedList passes = Lists.newLinkedList();
        for (PassFactory passFactory : this.specializationPassFactories) {
            CompilerPass pass = passFactory.create(this.compiler);
            Preconditions.checkState((boolean)(pass instanceof SpecializationAwareCompilerPass));
            passes.add((SpecializationAwareCompilerPass)pass);
        }
        return passes;
    }

    private Node copyModuleInputs(JSModule module) {
        this.specializedInputRootsByOriginal = Maps.newLinkedHashMap();
        this.functionInfoBySpecializedFunctionNode = Maps.newLinkedHashMap();
        Node syntheticModuleJsRoot = IR.block();
        syntheticModuleJsRoot.setIsSyntheticBlock(true);
        for (CompilerInput input : module.getInputs()) {
            Node originalInputRoot = input.getAstRoot(this.compiler);
            Node copiedInputRoot = originalInputRoot.cloneTree();
            copiedInputRoot.copyInformationFromForTree(originalInputRoot);
            this.specializedInputRootsByOriginal.put(originalInputRoot, copiedInputRoot);
            this.matchTopLevelFunctions(originalInputRoot, copiedInputRoot);
            syntheticModuleJsRoot.addChildToBack(copiedInputRoot);
        }
        Node syntheticExternsAndJsRoot = IR.block();
        syntheticExternsAndJsRoot.addChildToBack(syntheticModuleJsRoot);
        return syntheticModuleJsRoot;
    }

    private void matchTopLevelFunctions(Node original, Node toBeSpecialized) {
        new NodeMatcher(){

            @Override
            public void reportMatch(Node original, Node specialized) {
                if (original.isFunction()) {
                    OriginalFunctionInformation functionInfo = new OriginalFunctionInformation(original);
                    SpecializeModule.this.functionInfoBySpecializedFunctionNode.put(specialized, functionInfo);
                }
            }

            @Override
            public boolean shouldTraverse(Node n1, Node n2) {
                return !n1.isFunction();
            }
        }.match(original, toBeSpecialized);
    }

    private void replaceOriginalModuleInputsWithSpecialized() {
        for (Map.Entry<Node, Node> nodeEntry : this.specializedInputRootsByOriginal.entrySet()) {
            Node original = nodeEntry.getKey();
            Node specialized = nodeEntry.getValue();
            original.removeChildren();
            while (specialized.getFirstChild() != null) {
                original.addChildToBack(specialized.removeFirstChild());
            }
        }
    }

    private void addDummyVarDeclarationsToInitialModule(JSModule module) {
        for (Map.Entry<Node, OriginalFunctionInformation> nodeEntry : this.functionInfoBySpecializedFunctionNode.entrySet()) {
            Node block;
            OriginalFunctionInformation originalInfo;
            Node modifiedFunction = nodeEntry.getKey();
            if (!this.specializationState.getRemovedFunctions().contains(modifiedFunction) || (originalInfo = nodeEntry.getValue()).name == null || !originalInfo.originalWasDeclaration() || (block = (Node)this.specializationState.removedFunctionToBlock.get(modifiedFunction)) == null) continue;
            block.addChildrenToBack(originalInfo.generateDummyDeclaration());
        }
    }

    private void addOriginalFunctionVersionsToDependentModules(JSModule module) {
        for (JSModule directDependent : this.getDirectDependents(module)) {
            CompilerInput firstInput = directDependent.getInputs().get(0);
            Node firstInputRootNode = firstInput.getAstRoot(this.compiler);
            ArrayList possiblyModifiedFunctions = Lists.newArrayList(this.functionInfoBySpecializedFunctionNode.keySet());
            Collections.reverse(possiblyModifiedFunctions);
            for (Node modifiedFunction : possiblyModifiedFunctions) {
                OriginalFunctionInformation originalInfo;
                boolean declarationWasSpecialized = this.specializationState.getSpecializedFunctions().contains(modifiedFunction);
                boolean declarationWasRemoved = this.specializationState.getRemovedFunctions().contains(modifiedFunction);
                if (!declarationWasSpecialized && !declarationWasRemoved || (originalInfo = this.functionInfoBySpecializedFunctionNode.get(modifiedFunction)).name == null) continue;
                Node newDefinition = originalInfo.generateFixupDefinition();
                firstInputRootNode.addChildrenToFront(newDefinition);
            }
        }
    }

    public Collection<JSModule> getDirectDependents(JSModule module) {
        HashSet directDependents = Sets.newHashSet();
        for (JSModule possibleDependent : this.compiler.getModuleGraph().getAllModules()) {
            if (!possibleDependent.getDependencies().contains(module)) continue;
            directDependents.add(possibleDependent);
        }
        return directDependents;
    }

    public static class SpecializationState {
        private Set<Node> specializedFunctions;
        private Set<Node> removedFunctions;
        private Map<Node, Node> removedFunctionToBlock;
        private SimpleFunctionAliasAnalysis initialModuleAliasAnalysis;
        private boolean hasChanged = false;

        public SpecializationState(SimpleFunctionAliasAnalysis initialModuleAliasAnalysis) {
            this.initialModuleAliasAnalysis = initialModuleAliasAnalysis;
            this.specializedFunctions = Sets.newLinkedHashSet();
            this.removedFunctions = Sets.newLinkedHashSet();
            this.removedFunctionToBlock = Maps.newLinkedHashMap();
        }

        private boolean hasChanged() {
            return this.hasChanged;
        }

        private void resetHasChanged() {
            this.hasChanged = false;
        }

        public Set<Node> getSpecializedFunctions() {
            return this.specializedFunctions;
        }

        public void reportSpecializedFunction(Node functionNode) {
            if (this.specializedFunctions.add(functionNode)) {
                this.hasChanged = true;
            }
        }

        public void reportSpecializedFunctionContainingNode(Node node) {
            Node containingFunction = SpecializationState.containingFunction(node);
            if (containingFunction != null) {
                this.reportSpecializedFunction(containingFunction);
            }
        }

        public Set<Node> getRemovedFunctions() {
            return this.removedFunctions;
        }

        public void reportRemovedFunction(Node functionNode, Node declaringBlock) {
            if (this.removedFunctions.add(functionNode)) {
                this.hasChanged = true;
                this.removedFunctionToBlock.put(functionNode, declaringBlock);
            }
        }

        public boolean canFixupFunction(Node functionNode) {
            Preconditions.checkArgument((boolean)functionNode.isFunction());
            if (!this.nodeIsInGlobalScope(functionNode) || this.initialModuleAliasAnalysis.isAliased(functionNode)) {
                return false;
            }
            if (NodeUtil.isStatement(functionNode)) {
                return true;
            }
            Node parent = functionNode.getParent();
            Node gramps = parent.getParent();
            if (parent.isName() && gramps.isVar()) {
                return true;
            }
            return NodeUtil.isExprAssign(gramps) && parent.getChildAtIndex(1) == functionNode;
        }

        public boolean canFixupSpecializedFunctionContainingNode(Node n) {
            Node containingFunction = SpecializationState.containingFunction(n);
            if (containingFunction != null) {
                return this.canFixupFunction(containingFunction);
            }
            return true;
        }

        private boolean nodeIsInGlobalScope(Node node) {
            return SpecializationState.containingFunction(node) == null;
        }

        private static Node containingFunction(Node node) {
            for (Node ancestor : node.getAncestors()) {
                if (!ancestor.isFunction()) continue;
                return ancestor;
            }
            return null;
        }
    }

    private class OriginalFunctionInformation {
        private String name;
        private boolean isAssignFunction;
        private boolean assignHasVar;
        private Node originalFunctionCopy;

        public OriginalFunctionInformation(Node originalFunction) {
            this.name = NodeUtil.getFunctionName(originalFunction);
            this.originalFunctionCopy = originalFunction.cloneTree();
            this.originalFunctionCopy.copyInformationFromForTree(originalFunction);
            Node originalParent = originalFunction.getParent();
            this.isAssignFunction = originalParent.isAssign() || originalParent.isName();
            this.assignHasVar = this.isAssignFunction && originalParent.getParent().isVar();
        }

        private Node copiedOriginalFunction() {
            Node copy = this.originalFunctionCopy.cloneTree();
            copy.copyInformationFromForTree(this.originalFunctionCopy);
            return copy;
        }

        private boolean originalWasDeclaration() {
            return !this.isAssignFunction || this.assignHasVar;
        }

        private Node generateFixupDefinition() {
            Node nameNode;
            Node functionCopy = this.copiedOriginalFunction();
            if (this.isAssignFunction) {
                nameNode = NodeUtil.newQName(SpecializeModule.this.compiler, this.name, functionCopy, this.name);
            } else {
                nameNode = functionCopy.getFirstChild();
                functionCopy.replaceChild(nameNode, NodeUtil.newName(SpecializeModule.this.compiler, "", nameNode));
            }
            Node assignment = IR.assign(nameNode, functionCopy);
            assignment.copyInformationFrom(functionCopy);
            return NodeUtil.newExpr(assignment);
        }

        private Node generateDummyDeclaration() {
            Node declaration = NodeUtil.newVarNode(this.name, null);
            declaration.copyInformationFromForTree(this.originalFunctionCopy);
            return declaration;
        }
    }

    private static abstract class NodeMatcher {
        private NodeMatcher() {
        }

        public void match(Node ast1, Node ast2) {
            this.reportMatch(ast1, ast2);
            if (this.shouldTraverse(ast1, ast2)) {
                Node childOf1 = ast1.getFirstChild();
                Node childOf2 = ast2.getFirstChild();
                while (childOf1 != null) {
                    this.match(childOf1, childOf2);
                    childOf1 = childOf1.getNext();
                    childOf2 = childOf2.getNext();
                }
            }
        }

        public abstract void reportMatch(Node var1, Node var2);

        public boolean shouldTraverse(Node node1, Node n2) {
            return true;
        }
    }
}

