/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.DbSupportFactory;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.java.JavaMigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigrationResolver;
import com.googlecode.flyway.core.runtime.DbCleaner;
import com.googlecode.flyway.core.runtime.DbMigrator;
import com.googlecode.flyway.core.runtime.MetaDataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private String basePackage = "db.migration";
    private String baseDir = "db/migration";
    private String encoding = "UTF-8";
    private String table = "schema_version";
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private DbSupport dbSupport;
    private MetaDataTable metaDataTable;
    private String sqlMigrationPrefix = "V";
    private String sqlMigrationSuffix = ".sql";

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Deprecated
    public void setSchemaMetaDataTable(String table) {
        this.table = table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dbSupport = DbSupportFactory.createDbSupport(this.jdbcTemplate);
        LOG.debug((Object)("Schema: " + this.dbSupport.getCurrentSchema(this.jdbcTemplate)));
        this.metaDataTable = new MetaDataTable(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table);
    }

    public int migrate() throws Exception {
        this.metaDataTable.createIfNotExists();
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        migrationResolvers.add(new SqlMigrationResolver(this.baseDir, placeholderReplacer, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix));
        migrationResolvers.add(new JavaMigrationResolver(this.basePackage));
        DbMigrator dbMigrator = new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, migrationResolvers, this.metaDataTable);
        return dbMigrator.migrate();
    }

    public void clean() {
        DbCleaner dbCleaner = new DbCleaner(this.transactionTemplate, this.jdbcTemplate, this.dbSupport);
        dbCleaner.clean();
    }

    public Migration status() {
        return this.metaDataTable.latestAppliedMigration();
    }

    public List<Migration> history() {
        return this.metaDataTable.allAppliedMigrations();
    }

    public void init(SchemaVersion initialVersion) {
        this.metaDataTable.createIfNotExists();
        this.metaDataTable.init(initialVersion);
    }
}

