/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.h2.H2DbSupport;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlDbSupport;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLDbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleDbSupport;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSupportFactory {
    private static final Log LOG = LogFactory.getLog(DbSupportFactory.class);

    private DbSupportFactory() {
    }

    public static DbSupport createDbSupport(JdbcTemplate jdbcTemplate) {
        String databaseProductName = DbSupportFactory.getDatabaseProductName(jdbcTemplate);
        LOG.debug((Object)("Database: " + databaseProductName));
        ArrayList<DbSupport> dbSupports = new ArrayList<DbSupport>();
        dbSupports.add(new HsqlDbSupport());
        dbSupports.add(new H2DbSupport());
        dbSupports.add(new MySQLDbSupport());
        dbSupports.add(new OracleDbSupport());
        for (DbSupport dbSupport : dbSupports) {
            if (!dbSupport.supportsDatabase(databaseProductName)) continue;
            if (!dbSupport.supportsLocking()) {
                LOG.info((Object)(databaseProductName + " does not support locking. No concurrent migration supported."));
            }
            return dbSupport;
        }
        throw new IllegalArgumentException("Unsupported Database: " + databaseProductName);
    }

    private static String getDatabaseProductName(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData == null) {
                    throw new IllegalStateException("Unable to read database metadata while it is null!");
                }
                return connection.getMetaData().getDatabaseProductName();
            }
        });
    }
}

