/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;

public class Migration
implements Comparable<Migration> {
    private static final Log LOG = LogFactory.getLog(Migration.class);
    protected SchemaVersion schemaVersion = SchemaVersion.EMPTY;
    protected MigrationState migrationState = MigrationState.UNKNOWN;
    protected Date installedOn;
    protected Integer executionTime;
    protected String scriptName;
    protected Long checksum;

    public Long getChecksum() {
        return this.checksum;
    }

    public SchemaVersion getVersion() {
        return this.schemaVersion;
    }

    public MigrationState getState() {
        return this.migrationState;
    }

    public Date getInstalledOn() {
        return this.installedOn;
    }

    public Integer getExecutionTime() {
        return this.executionTime;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void assertNotFailed() {
        if (MigrationState.FAILED == this.migrationState) {
            throw new IllegalStateException("Migration to version " + this.schemaVersion + " failed! Please restore backups and roll back database and code!");
        }
    }

    public final void migrate(final TransactionTemplate transactionTemplate, final JdbcTemplate jdbcTemplate, final DbSupport dbSupport) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Migration.this.doMigrate(transactionTemplate, jdbcTemplate, dbSupport);
                    Migration.this.migrationState = MigrationState.SUCCESS;
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage());
                    LOG.error((Object)e.getCause().getMessage());
                    Migration.this.migrationState = MigrationState.FAILED;
                }
            }
        };
        Thread migrationThread = new Thread(runnable, "Flyway Migration");
        migrationThread.start();
        try {
            migrationThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        stopWatch.stop();
        this.executionTime = (int)stopWatch.getLastTaskTimeMillis();
    }

    @Override
    public int compareTo(Migration o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    protected void doMigrate(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport) throws DataAccessException {
    }
}

