/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.java;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.BaseMigration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ClassUtils;

public abstract class BaseJavaMigration
extends BaseMigration {
    protected BaseJavaMigration() {
        String nameWithoutV = ClassUtils.getShortName(this.getClass()).substring(1);
        this.initVersion(nameWithoutV);
        this.scriptName = "Java Class: " + ClassUtils.getShortName(this.getClass());
    }

    @Override
    protected final void doMigrate(TransactionTemplate transactionTemplate, final JdbcTemplate jdbcTemplate, DbSupport dbSupport) throws IllegalStateException {
        transactionTemplate.execute(new TransactionCallback(){

            public Void doInTransaction(TransactionStatus status) {
                try {
                    BaseJavaMigration.this.doMigrateInTransaction(jdbcTemplate);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Migration failed !", e);
                }
                return null;
            }
        });
    }

    protected abstract void doMigrateInTransaction(JdbcTemplate var1) throws Exception;
}

