/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SqlMigrationResolver
implements MigrationResolver {
    private static final Log log = LogFactory.getLog(SqlMigrationResolver.class);
    private final PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
    private final String baseDir;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;

    public SqlMigrationResolver(String baseDir, PlaceholderReplacer placeholderReplacer, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix) {
        this.baseDir = baseDir;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    @Override
    public Collection<Migration> resolvesMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        ClassPathResource classPathBaseDir = new ClassPathResource(this.baseDir + "/");
        if (!classPathBaseDir.exists()) {
            log.warn((Object)("Unable to find path for sql migrations: " + this.baseDir));
            return migrations;
        }
        try {
            Resource[] resources;
            String searchPattern = this.sqlMigrationPrefix + "?*" + this.sqlMigrationSuffix;
            for (Resource resource : resources = this.pathMatchingResourcePatternResolver.getResources("classpath:" + this.baseDir + "/" + searchPattern)) {
                String versionString = SqlMigrationResolver.extractVersionStringFromFileName(resource.getFilename(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
                migrations.add(new SqlMigration(resource, this.placeholderReplacer, this.encoding, versionString));
            }
        }
        catch (IOException e) {
            log.error((Object)"Error loading sql migration files", (Throwable)e);
        }
        return migrations;
    }

    static String extractVersionStringFromFileName(String fileName, String prefix, String suffix) {
        int extension;
        int lastDirSeparator = fileName.lastIndexOf("/");
        String withoutPathAndSuffix = fileName.substring(lastDirSeparator + 1, extension = fileName.lastIndexOf(suffix));
        if (withoutPathAndSuffix.startsWith(prefix)) {
            return withoutPathAndSuffix.substring(prefix.length());
        }
        return withoutPathAndSuffix;
    }
}

