/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.runtime;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.TimeFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;

public class DbCleaner {
    private static final Log LOG = LogFactory.getLog(DbCleaner.class);
    private final DbSupport dbSupport;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;

    public DbCleaner(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
    }

    public void clean() {
        LOG.debug((Object)"Starting to drop all database objects ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        SqlScript cleanScript = this.dbSupport.createCleanScript(this.jdbcTemplate);
        cleanScript.execute(this.transactionTemplate, this.jdbcTemplate);
        stopWatch.stop();
        LOG.info((Object)String.format(Locale.ENGLISH, "Cleaned database schema '%s' (execution time %s)", this.dbSupport.getCurrentSchema(this.jdbcTemplate), TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }
}

