/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.runtime;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.runtime.MetaDataTable;
import com.googlecode.flyway.core.util.TimeFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DbMigrator {
    private static final Log LOG = LogFactory.getLog(DbMigrator.class);
    private final SchemaVersion targetVersion = SchemaVersion.LATEST;
    private final DbSupport dbSupport;
    private final Collection<MigrationResolver> migrationResolvers;
    private final MetaDataTable metaDataTable;
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;

    public DbMigrator(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, Collection<MigrationResolver> migrationResolvers, MetaDataTable metaDataTable) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.migrationResolvers = migrationResolvers;
        this.metaDataTable = metaDataTable;
    }

    public int migrate() throws Exception {
        Migration appliedMigration;
        final List<Migration> allMigrations = this.findAvailableMigrations();
        if (allMigrations.isEmpty()) {
            LOG.info((Object)"No migrations found");
            return 0;
        }
        int migrationSuccessCount = 0;
        while ((appliedMigration = (Migration)this.transactionTemplate.execute(new TransactionCallback(){

            public Migration doInTransaction(TransactionStatus status) {
                SchemaVersion currentSchemaVersion;
                DbMigrator.this.metaDataTable.lock();
                Migration latestAppliedMigration = DbMigrator.this.metaDataTable.latestAppliedMigration();
                if (latestAppliedMigration == null) {
                    currentSchemaVersion = SchemaVersion.EMPTY;
                } else {
                    latestAppliedMigration.assertNotFailed();
                    currentSchemaVersion = latestAppliedMigration.getVersion();
                }
                LOG.info((Object)("Current schema version: " + currentSchemaVersion));
                Migration migration = DbMigrator.this.getNextMigration(allMigrations, currentSchemaVersion);
                if (migration == null) {
                    return null;
                }
                LOG.info((Object)("Migrating to version " + migration.getVersion() + " - " + migration.getScriptName()));
                migration.migrate(DbMigrator.this.transactionTemplate, DbMigrator.this.jdbcTemplate, DbMigrator.this.dbSupport);
                if (MigrationState.FAILED.equals((Object)migration.getState()) && DbMigrator.this.dbSupport.supportsDdlTransactions()) {
                    throw new IllegalStateException("Migration failed! Changes rolled back. Aborting!");
                }
                LOG.info((Object)String.format("Finished migrating to version %s - %s (execution time %s)", migration.getVersion(), migration.getScriptName(), TimeFormat.format(migration.getExecutionTime().intValue())));
                DbMigrator.this.metaDataTable.finishMigration(migration);
                return migration;
            }
        })) != null) {
            appliedMigration.assertNotFailed();
            ++migrationSuccessCount;
        }
        if (migrationSuccessCount == 0) {
            LOG.info((Object)"Schema is up to date. No migration necessary.");
        } else if (migrationSuccessCount == 1) {
            LOG.info((Object)"Migration completed. Successfully applied 1 migration.");
        } else {
            LOG.info((Object)("Migration completed. Successfully applied " + migrationSuccessCount + " migrations."));
        }
        return migrationSuccessCount;
    }

    private Migration getNextMigration(List<Migration> allMigrations, SchemaVersion currentVersion) {
        SchemaVersion newestMigrationVersion = allMigrations.get(0).getVersion();
        if (newestMigrationVersion.compareTo(currentVersion) < 0) {
            LOG.warn((Object)("Database version (" + currentVersion.getVersion() + ") is newer than the latest migration (" + newestMigrationVersion + ") !"));
            return null;
        }
        Migration nextMigration = null;
        for (Migration migration : allMigrations) {
            if (migration.getVersion().compareTo(currentVersion) > 0 && migration.getVersion().compareTo(this.targetVersion) <= 0) {
                nextMigration = migration;
                continue;
            }
            return nextMigration;
        }
        return nextMigration;
    }

    private List<Migration> findAvailableMigrations() {
        ArrayList<Migration> allMigrations = new ArrayList<Migration>();
        for (MigrationResolver migrationResolver : this.migrationResolvers) {
            allMigrations.addAll(migrationResolver.resolvesMigrations());
        }
        if (allMigrations.isEmpty()) {
            LOG.warn((Object)"No migrations found!");
            return allMigrations;
        }
        Collections.sort(allMigrations);
        Collections.reverse(allMigrations);
        return allMigrations;
    }
}

