/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.runtime;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ResourceUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTable.class);
    private final DbSupport dbSupport;
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    public MetaDataTable(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, String tableName) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.tableName = tableName;
    }

    private boolean exists() {
        return this.dbSupport.metaDataTableExists(this.jdbcTemplate, this.tableName);
    }

    private void create() {
        String location = this.dbSupport.getCreateMetaDataTableScriptLocation();
        String createMetaDataTableScriptSource = ResourceUtils.loadResourceAsString(location);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("tableName", this.tableName);
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(placeholders, "${", "}");
        SqlScript sqlScript = new SqlScript(createMetaDataTableScriptSource, placeholderReplacer);
        sqlScript.execute(this.transactionTemplate, this.jdbcTemplate);
        LOG.info((Object)("Metadata table created: " + this.tableName));
    }

    public void createIfNotExists() {
        if (!this.exists()) {
            this.create();
        }
    }

    public void init(final SchemaVersion initialVersion) {
        Migration migration = this.latestAppliedMigration();
        if (migration != null) {
            throw new IllegalStateException("Schema already initialized. Current Version: " + migration.getVersion());
        }
        final Migration initialMigration = new Migration(){
            {
                this.schemaVersion = initialVersion;
                this.scriptName = initialVersion.getDescription();
                this.executionTime = 0;
                this.migrationState = MigrationState.SUCCESS;
            }
        };
        this.transactionTemplate.execute(new TransactionCallback(){

            public Void doInTransaction(TransactionStatus status) {
                MetaDataTable.this.finishMigration(initialMigration);
                return null;
            }
        });
        LOG.info((Object)("Schema initialized with version: " + initialVersion));
    }

    public void lock() {
        if (this.dbSupport.supportsLocking()) {
            this.jdbcTemplate.queryForList("SELECT script FROM " + this.tableName + " FOR UPDATE");
        }
    }

    public void finishMigration(Migration migration) {
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET current_version=0");
        SchemaVersion schemaVersion = migration.getVersion();
        String version = schemaVersion.getVersion();
        String description = schemaVersion.getDescription();
        String state = migration.getState().name();
        this.jdbcTemplate.update("INSERT INTO " + this.tableName + " (version, description, script, execution_time, state, current_version, checksum)" + " VALUES (?, ?, ?, ?, ?, 1, ?)", new Object[]{version, description, migration.getScriptName(), migration.getExecutionTime(), state, migration.getChecksum()});
    }

    public Migration latestAppliedMigration() {
        if (!this.exists()) {
            return null;
        }
        String query = this.getSelectStatement() + " where current_version=1";
        List migrations = this.jdbcTemplate.query(query, (RowMapper)new MigrationRowMapper());
        if (migrations.isEmpty()) {
            return null;
        }
        return (Migration)migrations.get(0);
    }

    public List<Migration> allAppliedMigrations() {
        if (!this.exists()) {
            return new ArrayList<Migration>();
        }
        String query = this.getSelectStatement();
        List migrations = this.jdbcTemplate.query(query, (RowMapper)new MigrationRowMapper());
        Collections.sort(migrations);
        return migrations;
    }

    private String getSelectStatement() {
        return "select VERSION, DESCRIPTION, SCRIPT, EXECUTION_TIME, STATE, INSTALLED_ON, CHECKSUM from " + this.tableName;
    }

    private Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    private Long toLong(Number number) {
        if (number == null) {
            return null;
        }
        return number.longValue();
    }

    private class MigrationRowMapper
    implements RowMapper {
        private MigrationRowMapper() {
        }

        public Migration mapRow(final ResultSet rs, int rowNum) throws SQLException {
            return new Migration(){
                {
                    this.schemaVersion = new SchemaVersion(rs.getString("VERSION"), rs.getString("DESCRIPTION"));
                    this.migrationState = MigrationState.valueOf(rs.getString("STATE"));
                    this.installedOn = rs.getTimestamp("INSTALLED_ON");
                    this.executionTime = MetaDataTable.this.toInteger((Number)rs.getObject("EXECUTION_TIME"));
                    this.scriptName = rs.getString("SCRIPT");
                    this.checksum = MetaDataTable.this.toLong((Number)rs.getObject("CHECKSUM"));
                }
            };
        }
    }
}

