/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.springframework.core.io.ClassPathResource;

public class CalculateChecksum {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private CalculateChecksum() {
    }

    public static long checksum(String location) throws IOException {
        return CalculateChecksum.checksum(location, new CRC32()).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Checksum checksum(String location, Checksum checksum) throws IOException {
        InputStream in = new ClassPathResource(location).getInputStream();
        try {
            in = new CheckedInputStream(in, checksum);
            CalculateChecksum.copyLarge(in, new NullOutputStream());
        }
        finally {
            CalculateChecksum.closeQuietly(in);
        }
        return checksum;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }
}

