/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class ResourceUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private ResourceUtils() {
    }

    public static String loadResourceAsString(String location) {
        return ResourceUtils.loadResourceAsString((Resource)new ClassPathResource(location), "UTF-8", null);
    }

    public static String loadResourceAsString(Resource resource, String encoding) {
        return ResourceUtils.loadResourceAsString(resource, encoding, null);
    }

    public static String loadResourceAsString(Resource resource, String encoding, Checksum checksum) {
        InputStream inputStream = null;
        try {
            inputStream = resource.getInputStream();
            InputStream checkedInputStream = checksum != null ? new CheckedInputStream(inputStream, checksum) : inputStream;
            InputStreamReader reader = new InputStreamReader(checkedInputStream, Charset.forName(encoding));
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load resource: " + resource.getDescription() + " (encoding: " + encoding + ")", e);
        }
        finally {
            ResourceUtils.closeQuietly(inputStream);
        }
    }

    public static long checksum(Resource resource) throws IOException {
        return ResourceUtils.checksum(resource, new CRC32()).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Checksum checksum(Resource resource, Checksum checksum) throws IOException {
        InputStream in = resource.getInputStream();
        try {
            in = new CheckedInputStream(in, checksum);
            ResourceUtils.copyLarge(in, new NullOutputStream());
        }
        finally {
            ResourceUtils.closeQuietly(in);
        }
        return checksum;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Long calculateChecksum(String source) {
        CRC32 crc32 = new CRC32();
        crc32.update(source.getBytes());
        return crc32.getValue();
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }
}

