/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.clean.DbCleaner;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.DbSupportFactory;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTable085Upgrader;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.DbMigrator;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.migration.java.JavaMigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigrationResolver;
import com.googlecode.flyway.core.validation.DbValidator;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String basePackage = "db.migration";
    private String baseDir = "db/migration";
    private String encoding = "UTF-8";
    private String table = "schema_version";
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String sqlMigrationSuffix = ".sql";
    private ValidationMode validationMode = ValidationMode.NONE;
    private ValidationErrorMode validationErrorMode = ValidationErrorMode.FAIL;
    private JdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private DbSupport dbSupport;
    private MetaDataTable metaDataTable;

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setValidationErrorMode(ValidationErrorMode validationErrorMode) {
        this.validationErrorMode = validationErrorMode;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Deprecated
    public void setSchemaMetaDataTable(String table) {
        this.table = table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dbSupport = DbSupportFactory.createDbSupport(this.jdbcTemplate);
        LOG.debug((Object)("Schema: " + this.dbSupport.getCurrentSchema()));
        this.metaDataTable = new MetaDataTable(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table);
    }

    public int migrate() throws Exception {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        List<Migration> migrations = this.findAvailableMigrations();
        this.validate(migrations, this.validationMode);
        this.metaDataTable.createIfNotExists();
        DbMigrator dbMigrator = new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.metaDataTable);
        return dbMigrator.migrate(migrations);
    }

    private void validate(List<Migration> migrations, ValidationMode validationMode) {
        DbValidator dbValidator = new DbValidator(validationMode, this.metaDataTable, migrations);
        String validationError = dbValidator.validate();
        if (validationError != null) {
            String msg = "Flyway validate failed. Found differences between applied migrations and classpath migrations: " + validationError;
            if (ValidationErrorMode.CLEAN.equals((Object)this.validationErrorMode)) {
                LOG.warn((Object)(msg + " running clean and migrate again."));
                this.clean();
            } else {
                throw new IllegalStateException(msg);
            }
        }
    }

    private List<Migration> findAvailableMigrations() {
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        migrationResolvers.add(new SqlMigrationResolver(this.baseDir, placeholderReplacer, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix));
        migrationResolvers.add(new JavaMigrationResolver(this.basePackage));
        ArrayList<Migration> allMigrations = new ArrayList<Migration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            allMigrations.addAll(migrationResolver.resolveMigrations());
        }
        if (allMigrations.isEmpty()) {
            LOG.warn((Object)"No migrations found!");
            return allMigrations;
        }
        Collections.sort(allMigrations);
        Collections.reverse(allMigrations);
        for (int i = 0; i < allMigrations.size() - 1; ++i) {
            Migration next;
            Migration current = (Migration)allMigrations.get(i);
            if (current.compareTo(next = (Migration)allMigrations.get(i + 1)) != 0) continue;
            throw new IllegalStateException("Found more than one migration with version: " + current.getVersion());
        }
        return allMigrations;
    }

    public void clean() {
        new DbCleaner(this.transactionTemplate, this.jdbcTemplate, this.dbSupport).clean();
    }

    public void validate() {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        List<Migration> migrations = this.findAvailableMigrations();
        this.validate(migrations, ValidationMode.ALL);
    }

    public MetaDataTableRow status() {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        return this.metaDataTable.latestAppliedMigration();
    }

    public List<MetaDataTableRow> history() {
        new MetaDataTable085Upgrader(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.table, this.baseDir, this.encoding).upgrade();
        return this.metaDataTable.allAppliedMigrations();
    }

    @Deprecated
    public void init(SchemaVersion initialVersion) {
        this.init(initialVersion, null);
    }

    public void init(SchemaVersion initialVersion, String description) {
        new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.metaDataTable).init(initialVersion, description);
    }

    public void configure(Properties properties) {
        String validationErrorModeProp;
        String tableProp;
        String encodingProp;
        String basePackageProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Driver driverClazz;
        String driver = this.getRequiredProperty(properties, "flyway.driver");
        try {
            driverClazz = (Driver)Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating database driver: " + driver, e);
        }
        String url = this.getRequiredProperty(properties, "flyway.url");
        String user = this.getRequiredProperty(properties, "flyway.user");
        String password = this.getRequiredProperty(properties, "flyway.password");
        this.setDataSource((DataSource)new SimpleDriverDataSource(driverClazz, url, user, password));
        String baseDirProp = properties.getProperty("flyway.baseDir");
        if (baseDirProp != null) {
            this.setBaseDir(baseDirProp);
        }
        if ((placeholderPrefixProp = properties.getProperty("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = properties.getProperty("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = properties.getProperty("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((sqlMigrationSuffixProp = properties.getProperty("flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffix(sqlMigrationSuffixProp);
        }
        if ((basePackageProp = properties.getProperty("flyway.basePackage")) != null) {
            this.setBasePackage(basePackageProp);
        }
        if ((encodingProp = properties.getProperty("flyway.encoding")) != null) {
            this.setEncoding(encodingProp);
        }
        if ((tableProp = properties.getProperty("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((validationErrorModeProp = properties.getProperty("flyway.validationErrorMode")) != null) {
            this.setValidationErrorMode(ValidationErrorMode.valueOf(validationErrorModeProp));
        }
        String validationModeProp = properties.getProperty("flyway.validationMode");
        if (validationErrorModeProp != null) {
            this.setValidationMode(ValidationMode.valueOf(validationModeProp));
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>();
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholdersFromProps.put(placeholderName, placeholderValue);
        }
        this.setPlaceholders(placeholdersFromProps);
    }

    private String getRequiredProperty(Properties properties, String name) {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Missing required property: " + name);
        }
        return value;
    }
}

