/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.h2.H2DbSupport;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlDbSupport;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLDbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleDbSupport;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLDbSupport;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSupportFactory {
    private static final Log LOG = LogFactory.getLog(DbSupportFactory.class);

    private DbSupportFactory() {
    }

    public static DbSupport createDbSupport(JdbcTemplate jdbcTemplate) {
        String databaseProductName = DbSupportFactory.getDatabaseProductName(jdbcTemplate);
        LOG.debug((Object)("Database: " + databaseProductName));
        DbSupport dbSupport = null;
        if ("H2".equals(databaseProductName)) {
            dbSupport = new H2DbSupport(jdbcTemplate);
        }
        if ("HSQL Database Engine".equals(databaseProductName)) {
            dbSupport = new HsqlDbSupport(jdbcTemplate);
        }
        if ("MySQL".equals(databaseProductName)) {
            dbSupport = new MySQLDbSupport(jdbcTemplate);
        }
        if ("Oracle".equals(databaseProductName)) {
            dbSupport = new OracleDbSupport(jdbcTemplate);
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            dbSupport = new PostgreSQLDbSupport(jdbcTemplate);
        }
        if (dbSupport == null) {
            throw new IllegalStateException("Unsupported Database: " + databaseProductName);
        }
        if (!dbSupport.supportsLocking()) {
            LOG.info((Object)(databaseProductName + " does not support locking. No concurrent migration supported."));
        }
        return dbSupport;
    }

    private static String getDatabaseProductName(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData == null) {
                    throw new IllegalStateException("Unable to read database metadata while it is null!");
                }
                return connection.getMetaData().getDatabaseProductName();
            }
        });
    }
}

