/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class OracleDbSupport
implements DbSupport {
    private static final Log LOG = LogFactory.getLog(OracleDbSupport.class);
    private final JdbcTemplate jdbcTemplate;

    public OracleDbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/oracle/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getUserName();
            }
        });
    }

    @Override
    public boolean tableExists(final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, OracleDbSupport.this.getCurrentSchema(), table.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean columnExists(final String table, final String column) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getColumns(null, OracleDbSupport.this.getCurrentSchema(), table.toUpperCase(), column.toUpperCase());
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new OracleSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript() {
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SEQUENCE", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("FUNCTION", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("MATERIALIZED VIEW", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PACKAGE", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PROCEDURE", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SYNONYM", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("VIEW", ""));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TABLE", "CASCADE CONSTRAINTS PURGE"));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TYPE", ""));
        allDropStatements.addAll(this.generateDropStatementsForSpatialExtensions());
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int count = 0;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(++count, dropStatement));
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatementsForObjectType(String objectType, final String extraArguments) {
        return this.jdbcTemplate.query("SELECT object_type, object_name FROM user_objects WHERE object_type = ? and object_name not like 'BIN$%'", new Object[]{objectType}, new RowMapper(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return "DROP " + rs.getString("OBJECT_TYPE") + " " + rs.getString("OBJECT_NAME") + " " + extraArguments;
            }
        });
    }

    private List<String> generateDropStatementsForSpatialExtensions() {
        ArrayList<String> statements = new ArrayList<String>();
        if (this.spatialExtensionsAvailable()) {
            String user = this.getCurrentSchema();
            statements.add("DELETE FROM mdsys.user_sdo_geom_metadata");
            statements.add("DELETE FROM mdsys.sdo_index_metadata_table WHERE sdo_index_owner = '" + user + "'");
        } else {
            LOG.debug((Object)"Oracle Spatial Extensions are not available. No cleaning of MDSYS tables and views.");
        }
        return statements;
    }

    private boolean spatialExtensionsAvailable() {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM all_tables WHERE owner = 'MDSYS' AND table_name = 'SDO_INDEX_METADATA_TABLE'") > 0;
    }
}

