/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigration;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ResourceUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class MetaDataTable085Upgrader {
    private static final Log LOG = LogFactory.getLog(MetaDataTable085Upgrader.class);
    private final DbSupport dbSupport;
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final String baseDir;
    private final String encoding;

    public MetaDataTable085Upgrader(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, String tableName, String baseDir, String encoding) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.tableName = tableName;
        this.baseDir = baseDir;
        this.encoding = encoding;
    }

    public void upgrade() {
        if (!this.dbSupport.tableExists(this.tableName)) {
            return;
        }
        if (this.dbSupport.columnExists(this.tableName, "checksum")) {
            return;
        }
        LOG.info((Object)("Upgrading MetaData table '" + this.tableName + "' from the old Flyway 0.8.5 format to new Flyway 0.9+ format"));
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                MetaDataTable085Upgrader.this.addColumns();
                MetaDataTable085Upgrader.this.migrateData();
                MetaDataTable085Upgrader.this.addConstraints();
            }
        });
        LOG.info((Object)("MetaData table '" + this.tableName + "' successfully upgraded"));
    }

    private void addColumns() {
        String location = this.dbSupport.getScriptLocation() + "upgradeMetaDataTable085Columns.sql";
        String scriptSource = ResourceUtils.loadResourceAsString(location);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("tableName", this.tableName);
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(placeholders, "${", "}");
        SqlScript sqlScript = new SqlScript(scriptSource, placeholderReplacer);
        sqlScript.execute(this.jdbcTemplate);
    }

    private void migrateData() {
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET type='SQL' where script LIKE 'Sql File:%'");
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET type='JAVA' where script LIKE 'Java Class:%'");
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET installed_by=" + this.dbSupport.getCurrentUserFunction());
        List migrations = this.jdbcTemplate.queryForList("SELECT VERSION, TYPE, SCRIPT FROM " + this.tableName + " ORDER BY installed_on");
        boolean first = true;
        for (Map migration : migrations) {
            String version = (String)migration.get("VERSION");
            String migrationType = (String)migration.get("TYPE");
            String oldScript = (String)migration.get("SCRIPT");
            String newScript = oldScript.substring(oldScript.indexOf(": ") + ": ".length());
            Integer checksum = null;
            if (MigrationType.SQL.name().equals(migrationType)) {
                ClassPathResource resource = new ClassPathResource(this.baseDir + "/" + newScript);
                if (first & !resource.exists()) {
                    this.jdbcTemplate.update("UPDATE " + this.tableName + " SET type='INIT' where version=?", new Object[]{version});
                    if (newScript.endsWith(".sql")) {
                        newScript = newScript.substring(0, newScript.length() - ".sql".length());
                    }
                } else {
                    checksum = new SqlMigration((Resource)resource, null, this.encoding, "1").getChecksum();
                }
            }
            this.jdbcTemplate.update("UPDATE " + this.tableName + " SET script=?, checksum=? where version=?", new Object[]{newScript, checksum, version});
            first = false;
        }
    }

    private void addConstraints() {
        String location = this.dbSupport.getScriptLocation() + "upgradeMetaDataTable085Constraints.sql";
        String scriptSource = ResourceUtils.loadResourceAsString(location);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("tableName", this.tableName);
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(placeholders, "${", "}");
        SqlScript sqlScript = new SqlScript(scriptSource, placeholderReplacer);
        sqlScript.execute(this.jdbcTemplate);
    }
}

